import AST.*;
import java.util.*;

public class TestDotList {

  private static final int N = 1000;

  public static void main(String[] args) {
    Prog p = createAST(2);
    String tree = p.printTree();
    System.out.println("Tree: " + tree);
  }

  public static Prog createAST(int level) {
    String packageName = "p";
    String fieldName = "f";
    ASTNode[] classes = new ASTNode[N];
    for (int i = 0; i < N; i++) {
      String className = "A" + i;
      classes[i] = new ClassDecl(className, new ParseName("Object"), 
        new AST.List().add(new FieldDecl(new ParseName(className), fieldName, 
        parseDots(packageName + "." + className + levelToStr(level,fieldName))))
        );
    }
    return new Prog(new AST.List().add(new CompUnit(packageName,new AST.List(classes))));
  }

  private static String levelToStr(int level, String fieldName) {
    StringBuffer buf = new StringBuffer();
    for (int i = 1; i <= level; i++) {
      buf.append("." + fieldName);
    }
    return buf.toString();
  }

  private static Name parseDots(String list) {
    Stack<Name> stack = new Stack<Name>();
    StringTokenizer tok = new StringTokenizer(list, ".");
    while (tok.hasMoreTokens()) {
      stack.push(new ParseName(tok.nextToken()));
    }
    while (stack.size() > 1) { 
      Name right = stack.pop();
      Name left = stack.pop();
      stack.push(new Dot("dot", left, right));
    }
    return stack.pop();
  }

}
