
package AST;

public class Opt<T extends ASTNode> extends ASTNode<T> implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public Opt<T> clone() throws CloneNotSupportedException {
    Opt node = (Opt) super.clone();
    node.in$Circle(false);
    node.is$Final(false);
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public Opt<T> copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      Opt node = (Opt) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public Opt<T> fullCopy() {
    Opt tree = (Opt) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public Opt() {
    super();
  }

  public void init$Children() {
  }

  public Opt(T opt) {
    setChild(opt, 0);
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public ASTNode rewriteTo() {    return super.rewriteTo();
  }
}
