
package AST;

public abstract class Name extends Expr implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public Name clone() throws CloneNotSupportedException {
    Name node = (Name) super.clone();
    node.predKind_visited = -1;
    node.predKind_computed = false;
    node.predKind_value = null;
    node.extra_visited = -1;
    node.kind_visited = -1;
    node.kind_computed = false;
    node.kind_value = null;
    node.in$Circle(false);
    node.is$Final(false);
    return node;
  }

  public Name() {
    super();
  }

  public void init$Children() {
  }

  public Name(String p0) {
    setname(p0);
  }

  protected int numChildren() {
    return 0;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
    if (((Object)tokenString_name) instanceof ASTNode) {
      tokenString_name = null;
    }
    predKind_visited = -1;
    predKind_computed = false;
    predKind_value = null;
    extra_visited = -1;
    kind_visited = -1;
    kind_computed = false;
    kind_value = null;
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setname(String value) {
    tokenString_name = value;
  }

  protected String tokenString_name;

  public String getname() {
    return tokenString_name != null ? tokenString_name : "";
  }

  protected int predKind_visited = -1;

  protected boolean predKind_computed = false;

  protected Kind predKind_value;

  public Kind predKind() {
    if(predKind_computed) {
      return predKind_value;
    }
    ASTNode$State state = state();
    if (predKind_visited == state().boundariesCrossed) {
      throw new RuntimeException("Circular definition of attr: predKind in class: ast.AST.SynDecl");
    }
    predKind_visited = state().boundariesCrossed;
    int num = state.boundariesCrossed;
    boolean isFinal = this.is$Final();
    predKind_value = predKind_compute();
    if(isFinal && num == state().boundariesCrossed) { 
      predKind_computed = true; 
      Tracer.traceCached(this, "Name.predKind", "", "" + predKind_value);
    } else Tracer.traceCacheAbort(this, "Name.predKind", "", "" + predKind_value);
    predKind_visited = -1;
    return predKind_value;
  }

  private Kind predKind_compute() {  return Kind.AMBIGUOUS_NAME;  }

  protected int extra_visited = -1;

  public String extra() {
    ASTNode$State state = state();
    if (extra_visited == state().boundariesCrossed) {
      throw new RuntimeException("Circular definition of attr: extra in class: ast.AST.SynDecl");
    }
          
    extra_visited = state().boundariesCrossed;
      
    try {  return ", name: " + getname();  }
    finally {
      extra_visited = -1;
    }
  }

  public Kind kind() {
    if(kind_computed) {
      return kind_value;
    }
    ASTNode$State state = state();
    if (kind_visited == state().boundariesCrossed) {
      throw new RuntimeException("Circular definition of attr: kind in class: ast.AST.InhDecl");
    }
    kind_visited = state().boundariesCrossed;
    int num = state.boundariesCrossed;
    boolean isFinal = this.is$Final();
    kind_value = getParent().Define_Kind_kind(this, null);
    if(isFinal && num == state().boundariesCrossed) { 
      kind_computed = true; 
      Tracer.traceCached(this, "Name.kind", "", "" + kind_value);
    } else Tracer.traceCacheAbort(this, "Name.kind", "", "" + kind_value);
    kind_visited = -1;
    return kind_value;
  }

  protected int kind_visited = -1;

  protected boolean kind_computed = false;

  protected Kind kind_value;

  public ASTNode rewriteTo() {    return super.rewriteTo();
  }
}
