
package AST;

public class List<T extends ASTNode> extends ASTNode<T> implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public List<T> clone() throws CloneNotSupportedException {
    List node = (List) super.clone();
    node.in$Circle(false);
    node.is$Final(false);
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public List<T> copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      List node = (List) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public List<T> fullCopy() {
    List tree = (List) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public List() {
    super();
  }

  public void init$Children() {
  }

  public List(T... initialChildren) {
    children = new ASTNode[initialChildren.length];
    for (int i = 0; i < children.length; ++i) {
      addChild(initialChildren[i]);
    }
  }

  public List<T> add(T node) {
    addChild(node);
    return this;
  }

  public void insertChild(ASTNode node, int i) {
    super.insertChild(node, i);
  }

  public void addChild(T node) {
    super.addChild(node);
  }

  public void removeChild(int i) {
    super.removeChild(i);
  }

  public int getNumChild() {
    return getNumChildNoTransform();
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public ASTNode rewriteTo() {    
    return super.rewriteTo();
  }
}
