
package AST;

public class ExpressionName extends Name implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public ExpressionName clone() throws CloneNotSupportedException {
    ExpressionName node = (ExpressionName) super.clone();
    node.type_visited = -1;
    node.type_computed = false;
    node.type_value = null;
    node.predKind_visited = -1;
    node.predKind_computed = false;
    node.predKind_value = null;
    node.in$Circle(false);
    node.is$Final(false);
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public ExpressionName copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      ExpressionName node = (ExpressionName) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public ExpressionName fullCopy() {
    ExpressionName tree = (ExpressionName) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public ExpressionName() {
    super();
  }

  public void init$Children() {
  }

  public ExpressionName(String p0) {
    setname(p0);
  }

  protected int numChildren() {
    return 0;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
    type_visited = -1;
    type_computed = false;
    type_value = null;
    predKind_visited = -1;
    predKind_computed = false;
    predKind_value = null;
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setname(String value) {
    tokenString_name = value;
  }

  public String getname() {
    return tokenString_name != null ? tokenString_name : "";
  }

  protected int type_visited = -1;

  protected boolean type_computed = false;

  protected ClassDecl type_value;

  public ClassDecl type() {
    if(type_computed) {
      return type_value;
    }
    ASTNode$State state = state();
    if (type_visited == state().boundariesCrossed) {
      throw new RuntimeException("Circular definition of attr: type in class: ast.AST.SynDecl");
    }     
    type_visited = state().boundariesCrossed; 
    int num = state.boundariesCrossed;
    boolean isFinal = this.is$Final();
    type_value = type_compute();
    if(isFinal && num == state().boundariesCrossed) { 
      type_computed = true;
      Tracer.traceCached(this, "ExpressionName.type", "", "" + type_value);
    } else Tracer.traceCacheAbort(this, "ExpressionName.type", "", "" + type_value);
    type_visited = -1;
    return type_value;
  }

  private ClassDecl type_compute() {  return lookupVariable(getname()) != null ?
        lookupVariable(getname()).type() : unknownType();  }


  protected int predKind_visited = -1;

  protected boolean predKind_computed = false;

  protected Kind predKind_value;

  public Kind predKind() {
    if(predKind_computed) {
      return predKind_value;
    }
    ASTNode$State state = state();
    if (predKind_visited == state().boundariesCrossed) {
      throw new RuntimeException("Circular definition of attr: predKind in class: ast.AST.SynDecl");
    }      
    predKind_visited = state().boundariesCrossed;
    int num = state.boundariesCrossed;
    boolean isFinal = this.is$Final();
    predKind_value = predKind_compute();
    if(isFinal && num == state().boundariesCrossed) { 
      predKind_computed = true; 
      Tracer.traceCached(this, "ExpressionName.predKind", "", "" + predKind_value);
    } else Tracer.traceCacheAbort(this, "ExpressionName.predKind", "", "" + predKind_value);
    predKind_visited = -1;
    return predKind_value;
  }

  private Kind predKind_compute() {  return Kind.AMBIGUOUS_NAME;  }

  public ASTNode rewriteTo() {    return super.rewriteTo();
  }
}
