
package AST;

public class Dot extends Name implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public Dot clone() throws CloneNotSupportedException {
    Dot node = (Dot) super.clone();
    node.type_visited = -1;
    node.type_computed = false;
    node.type_value = null;
    node.predKind_visited = -1;
    node.predKind_computed = false;
    node.predKind_value = null;
    node.in$Circle(false);
    node.is$Final(false);
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public Dot copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      Dot node = (Dot) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public Dot fullCopy() {
    Dot tree = (Dot) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public Dot() {
    super();
  }

  public void init$Children() {
    children = new ASTNode[2];
  }

  public Dot(String p0, Name p1, Name p2) {
    setname(p0);
    setChild(p1, 0);
    setChild(p2, 1);
  }

  protected int numChildren() {
    return 2;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
    type_visited = -1;
    type_computed = false;
    type_value = null;
    predKind_visited = -1;
    predKind_computed = false;
    predKind_value = null;
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setname(String value) {
    tokenString_name = value;
  }

  public String getname() {
    return tokenString_name != null ? tokenString_name : "";
  }

  public void setLeft(Name node) {
    setChild(node, 0);
  }

  public Name getLeft() {
    return (Name) getChild(0);
  }

  public Name getLeftNoTransform() {
    return (Name) getChildNoTransform(0);
  }

  public void setRight(Name node) {
    setChild(node, 1);
  }

  public Name getRight() {
    return (Name) getChild(1);
  }

  public Name getRightNoTransform() {
    return (Name) getChildNoTransform(1);
  }

  protected int type_visited = -1;

  protected boolean type_computed = false;

  protected ClassDecl type_value;

  public ClassDecl type() {
    if(type_computed) {
      return type_value;
    }
    ASTNode$State state = state();
    if (type_visited == state().boundariesCrossed) {
      throw new RuntimeException("Circular definition of attr: type in class: ast.AST.SynDecl");
    }      
    type_visited = state().boundariesCrossed; 
    int num = state.boundariesCrossed;
    boolean isFinal = this.is$Final();
    type_value = type_compute();
    if(isFinal && num == state().boundariesCrossed) { 
      type_computed = true;
      Tracer.traceCached(this, "Dot.type", "", "" + type_value);
    } else Tracer.traceCacheAbort(this, "Dot.type", "", "" + type_value);
    type_visited = -1;
    return type_value;
  }

  private ClassDecl type_compute() {  return getRight().type();  }

  protected int predKind_visited = -1;

  protected boolean predKind_computed = false;

  protected Kind predKind_value;

  public Kind predKind() {
    if(predKind_computed) {
      return predKind_value;
    }
    ASTNode$State state = state();
    if (predKind_visited == state().boundariesCrossed) {
      throw new RuntimeException("Circular definition of attr: predKind in class: ast.AST.SynDecl");
    }     
    predKind_visited = state().boundariesCrossed; 
    int num = state.boundariesCrossed;
    boolean isFinal = this.is$Final();
    predKind_value = predKind_compute();
    if(isFinal && num == state().boundariesCrossed) { 
      predKind_computed = true;
      Tracer.traceCached(this, "Dot.predKind", "", "" + predKind_value);
    } else Tracer.traceCacheAbort(this, "Dot.predKind", "", "" + predKind_value);
    predKind_visited = -1;
    return predKind_value;
  }

  private Kind predKind_compute() {  return getLeft().predKind();  }

  public Variable Define_Variable_lookupVariable(ASTNode caller, ASTNode child, String name) {
    Tracer.traceInhAttrEval(this, "Dot.child.lookupVariable", name, nodeToString(caller));
    if(caller == getRightNoTransform()) {
      return getLeft().type().memberField(name);
    }
    else {      
      return getParent().Define_Variable_lookupVariable(this, caller, name);
    }
  }

  public ClassDecl Define_ClassDecl_lookupType(ASTNode caller, ASTNode child, String name) {
    Tracer.traceInhAttrEval(this, "Dot.child.lookupType", name, nodeToString(caller));
    if(caller == getRightNoTransform()) {
      return getLeft().qualifiedLookupType(name);
    }
    else {      
      return getParent().Define_ClassDecl_lookupType(this, caller, name);
    }
  }

  public Kind Define_Kind_kind(ASTNode caller, ASTNode child) {
    Tracer.traceInhAttrEval(this, "Dot.child.kind", "", nodeToString(caller));
    if(caller == getLeftNoTransform()) {
      return getRight().predKind();
    }
    else {      
      return getParent().Define_Kind_kind(this, caller);
    }
  }

  public boolean Define_boolean_hasPackage(ASTNode caller, ASTNode child, String name) {
    Tracer.traceInhAttrEval(this, "Dot.child.hasPackage", "", nodeToString(caller));
    if(caller == getRightNoTransform()) {
      return getLeft().qualifiedHasPackage(name);
    }
    else {      
      return getParent().Define_boolean_hasPackage(this, caller, name);
    }
  }

  public ASTNode rewriteTo() {    return super.rewriteTo(); }
}
