
package AST;

/**
 * @production Block : {@link Stmt} ::= <span class="component">{@link Stmt}*</span>;
 * @ast node
 * @declaredat JavaDemoNames.ast:11
 */
public class Block extends Stmt implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public Block clone() throws CloneNotSupportedException {
    Block node = (Block) super.clone();
    node.lookupVariable_String_visited = null;
    node.lookupVariable_String_values = null;
    node.in$Circle(false);
    node.is$Final(false);
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public Block copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      Block node = (Block) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public Block fullCopy() {
    Block tree = (Block) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public Block() {
    super();
  }

  public void init$Children() {
    children = new ASTNode[1];
    setChild(new List(), 0);
  }

  public Block(List<Stmt> p0) {
    setChild(p0, 0);
  }

  protected int numChildren() {
    return 1;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
    lookupVariable_String_visited = null;
    lookupVariable_String_values = null;
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setStmtList(List<Stmt> list) {
    setChild(list, 0);
  }

  public int getNumStmt() {
    return getStmtList().getNumChild();
  }

  public int getNumStmtNoTransform() {
    return getStmtListNoTransform().getNumChildNoTransform();
  }

  @SuppressWarnings({"unchecked", "cast"})
  public Stmt getStmt(int i) {
    return (Stmt) getStmtList().getChild(i);
  }

  public void addStmt(Stmt node) {
    List<Stmt> list = (parent == null || state == null) ? getStmtListNoTransform() : getStmtList();
    list.addChild(node);
  }

  public void addStmtNoTransform(Stmt node) {
    List<Stmt> list = getStmtListNoTransform();
    list.addChild(node);
  }

  public void setStmt(Stmt node, int i) {
    List<Stmt> list = getStmtList();
    list.setChild(node, i);
  }

  @SuppressWarnings({"unchecked", "cast"})
  public List<Stmt> getStmtList() {
    List<Stmt> list = (List<Stmt>) getChild(0);
    list.getNumChild();
    return list;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public List<Stmt> getStmtListNoTransform() {
    return (List<Stmt>) getChildNoTransform(0);
  }

  public List<Stmt> getStmts() {
    return getStmtList();
  }

  public List<Stmt> getStmtsNoTransform() {
    return getStmtListNoTransform();
  }

  public Variable lookupVariable(String name) {
    Object _parameters = name;
    if(lookupVariable_String_visited == null) lookupVariable_String_visited = new java.util.HashMap(4);
    if(lookupVariable_String_values == null) lookupVariable_String_values = new java.util.HashMap(4);
    if(lookupVariable_String_values.containsKey(_parameters)) {
      return (Variable)lookupVariable_String_values.get(_parameters); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state().boundariesCrossed).equals(lookupVariable_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: lookupVariable in class: ast.AST.InhDecl");
    }           
    lookupVariable_String_visited.put(_parameters, Integer.valueOf(state().boundariesCrossed));     
    int num = state.boundariesCrossed;
    boolean isFinal = this.is$Final();
    Variable lookupVariable_String_value = getParent().Define_Variable_lookupVariable(this, null, name);
    if(isFinal && num == state().boundariesCrossed) { 
      lookupVariable_String_values.put(_parameters, lookupVariable_String_value); 
      Tracer.traceCached(this, "Block.lookupVariable", name, "" + lookupVariable_String_value);
    } else Tracer.traceCacheAbort(this, "Block.lookupVariable", name, "" + lookupVariable_String_value);
    lookupVariable_String_visited.remove(_parameters);
    return lookupVariable_String_value;
  } 

  protected java.util.Map lookupVariable_String_visited;
  protected java.util.Map lookupVariable_String_values;

  public Variable Define_Variable_lookupVariable(ASTNode caller, ASTNode child, String name) {
    Tracer.traceInhAttrEval(this, "Block.child.lookupVariable", name, nodeToString(caller));
    if(caller == getStmtListNoTransform())  {
      int index = caller.getIndexOfChild(child);
      {
        for(int i = 0; i < index; i++)
          if(getStmt(i).isLocalVariableDecl(name))
            return (LocalVariableDecl)getStmt(i);
          return lookupVariable(name);
      }
    } else {      
      return getParent().Define_Variable_lookupVariable(this, caller, name);
    }
  }

  public ASTNode rewriteTo() {    
    return super.rewriteTo();
  }
}
