
package AST;

public class LocalVariableDecl extends Stmt implements Cloneable, Variable {

  @SuppressWarnings({"unchecked", "cast"})
  public LocalVariableDecl clone() throws CloneNotSupportedException {
    LocalVariableDecl node = (LocalVariableDecl) super.clone();
    node.type_visited = -1;
    node.type_computed = false;
    node.type_value = null;
    node.isLocalVariableDecl_String_visited = null;
    node.isLocalVariableDecl_String_values = null;
    node.in$Circle(false);
    node.is$Final(false);
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public LocalVariableDecl copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      LocalVariableDecl node = (LocalVariableDecl) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public LocalVariableDecl fullCopy() {
    LocalVariableDecl tree = (LocalVariableDecl) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public LocalVariableDecl() {
    super();
  }

  public void init$Children() {
    children = new ASTNode[2];
  }

  public LocalVariableDecl(Name p0, String p1, Expr p2) {
    setChild(p0, 0);
    setname(p1);
    setChild(p2, 1);
  }

  protected int numChildren() {
    return 2;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
    type_visited = -1;
    type_computed = false;
    type_value = null;
    isLocalVariableDecl_String_visited = null;
    isLocalVariableDecl_String_values = null;
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setVarType(Name node) {
    setChild(node, 0);
  }

  public Name getVarType() {
    return (Name) getChild(0);
  }

  public Name getVarTypeNoTransform() {
    return (Name) getChildNoTransform(0);
  }

  public void setname(String value) {
    tokenString_name = value;
  }

  protected String tokenString_name;

  public String getname() {
    return tokenString_name != null ? tokenString_name : "";
  }

  public void setExpr(Expr node) {
    setChild(node, 1);
  }

  public Expr getExpr() {
    return (Expr) getChild(1);
  }

  public Expr getExprNoTransform() {
    return (Expr) getChildNoTransform(1);
  }

  protected int type_visited = -1;

  protected boolean type_computed = false;

  protected ClassDecl type_value;

  public ClassDecl type() {
    if(type_computed) {
      return type_value;
    }
    ASTNode$State state = state();
    if (type_visited == state().boundariesCrossed) {
      throw new RuntimeException("Circular definition of attr: type in class: ast.AST.SynDecl");
    }     
    type_visited = state().boundariesCrossed; 
    int num = state.boundariesCrossed;
    boolean isFinal = this.is$Final();
    type_value = type_compute();
    if(isFinal && num == state().boundariesCrossed) { 
      type_computed = true;
      Tracer.traceCached(this, "LocalVariableDecl.type", "", "" + type_value);
    } else Tracer.traceCacheAbort(this, "LocalVariableDecl.type", "", "" + type_value);
    type_visited = -1;
    return type_value;
  }

  private ClassDecl type_compute() {  return getVarType().type();  }

  protected java.util.Map isLocalVariableDecl_String_visited;
  protected java.util.Map isLocalVariableDecl_String_values;

  public boolean isLocalVariableDecl(String name) {
    Object _parameters = name;
    if(isLocalVariableDecl_String_visited == null) isLocalVariableDecl_String_visited = new java.util.HashMap(4);
    if(isLocalVariableDecl_String_values == null) isLocalVariableDecl_String_values = new java.util.HashMap(4);
    if(isLocalVariableDecl_String_values.containsKey(_parameters)) {
      return ((Boolean)isLocalVariableDecl_String_values.get(_parameters)).booleanValue(); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state().boundariesCrossed).equals(isLocalVariableDecl_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: isLocalVariableDecl in class: ast.AST.SynDecl");
    }           
    isLocalVariableDecl_String_visited.put(_parameters, Integer.valueOf(state().boundariesCrossed));     
    int num = state.boundariesCrossed;
    boolean isFinal = this.is$Final();
    boolean isLocalVariableDecl_String_value = isLocalVariableDecl_compute(name);
    if(isFinal && num == state().boundariesCrossed) { 
      isLocalVariableDecl_String_values.put(_parameters, Boolean.valueOf(isLocalVariableDecl_String_value)); 
      Tracer.traceCached(this, "LocalVariableDecl.isLocalVariableDecl", name, "" + isLocalVariableDecl_String_value);
    } else Tracer.traceCacheAbort(this, "LocalVariableDecl.isLocalVariableDecl", name, "" + isLocalVariableDecl_String_value);
    isLocalVariableDecl_String_visited.remove(_parameters);
    return isLocalVariableDecl_String_value;
  }

  private boolean isLocalVariableDecl_compute(String name) {  return getname().equals(name);  }

  public Kind Define_Kind_kind(ASTNode caller, ASTNode child) {
    Tracer.traceInhAttrEval(this, "LocalVariableDecl.child.kind", "", nodeToString(caller));
    if(caller == getExprNoTransform()) {
      return Kind.EXPRESSION_NAME;
    }
    else if(caller == getVarTypeNoTransform()) {
      return Kind.TYPE_NAME;
    }
    else {      
      return getParent().Define_Kind_kind(this, caller);
    }
  }

  public ASTNode rewriteTo() {    return super.rewriteTo(); }
}
