
package AST;

public class PackageName extends Name implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public PackageName clone() throws CloneNotSupportedException {
    PackageName node = (PackageName) super.clone();
    node.qualifiedLookupType_String_visited = null;
    node.qualifiedLookupType_String_values = null;
    node.predKind_visited = -1;
    node.predKind_computed = false;
    node.predKind_value = null;
    node.qualifiedHasPackage_String_visited = null;
    node.qualifiedHasPackage_String_values = null;
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public PackageName copy() {
    try {
      PackageName node = (PackageName) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public PackageName fullCopy() {
    PackageName tree = (PackageName) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public PackageName() {
    super();
  }

  public void init$Children() {
  }

  public PackageName(String p0) {
    setname(p0);
  }

  protected int numChildren() {
    return 0;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
    qualifiedLookupType_String_visited = null;
    qualifiedLookupType_String_values = null;
    predKind_visited = -1;
    predKind_computed = false;
    predKind_value = null;
    qualifiedHasPackage_String_visited = null;
    qualifiedHasPackage_String_values = null;
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setname(String value) {
    tokenString_name = value;
  }

  public String getname() {
    return tokenString_name != null ? tokenString_name : "";
  }

  protected java.util.Map qualifiedLookupType_String_visited;
  protected java.util.Map qualifiedLookupType_String_values;

  public ClassDecl qualifiedLookupType(String typeName) {
    Object _parameters = typeName;
    if(qualifiedLookupType_String_visited == null) qualifiedLookupType_String_visited = new java.util.HashMap(4);
    if(qualifiedLookupType_String_values == null) qualifiedLookupType_String_values = new java.util.HashMap(4);
    if(qualifiedLookupType_String_values.containsKey(_parameters)) {
      return (ClassDecl)qualifiedLookupType_String_values.get(_parameters); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(qualifiedLookupType_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: qualifiedLookupType in class: ast.AST.SynDecl");
    }           
    qualifiedLookupType_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));     
    boolean cycleEndStore = state.CYCLE_END;
    ClassDecl qualifiedLookupType_String_value = qualifiedLookupType_compute(typeName);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      qualifiedLookupType_String_values.put(_parameters, qualifiedLookupType_String_value);
      //Tracer.traceCached(this, "PackageName.qualifiedLookupType", typeName, "" + qualifiedLookupType_String_value);
    } //else Tracer.traceCacheAbort(this, "PackageName.qualifiedLookupType", typeName, "" + qualifiedLookupType_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    qualifiedLookupType_String_visited.remove(_parameters);
    return qualifiedLookupType_String_value;
  }

  private ClassDecl qualifiedLookupType_compute(String typeName) {  return lookupCanonical(getname(), typeName);  }

  protected int predKind_visited = -1;
  protected boolean predKind_computed = false;
  protected Kind predKind_value;

  public Kind predKind() {
    if(predKind_computed) {
      return predKind_value;
    }
    ASTNode$State state = state();
    if (predKind_visited == state.CIRCLE_INDEX) {
      throw new RuntimeException("Circular definition of attr: predKind in class: ast.AST.SynDecl");
    }     
    predKind_visited = state.CIRCLE_INDEX; 
    boolean cycleEndStore = state.CYCLE_END;
    predKind_value = predKind_compute();
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      predKind_computed = true; 
      //Tracer.traceCached(this, "PackageName.predKind", "", "" + predKind_value);
    } //else Tracer.traceCacheAbort(this, "PackageName.predKind", "", "" + predKind_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    predKind_visited = -1;
    return predKind_value;
  }

  private Kind predKind_compute() {  return Kind.PACKAGE_NAME;  }

  protected java.util.Map qualifiedHasPackage_String_visited;
  protected java.util.Map qualifiedHasPackage_String_values;

  public boolean qualifiedHasPackage(String name) {
    Object _parameters = name;
    if(qualifiedHasPackage_String_visited == null) qualifiedHasPackage_String_visited = new java.util.HashMap(4);
    if(qualifiedHasPackage_String_values == null) qualifiedHasPackage_String_values = new java.util.HashMap(4);
    if(qualifiedHasPackage_String_values.containsKey(_parameters)) {
      return ((Boolean)qualifiedHasPackage_String_values.get(_parameters)).booleanValue(); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(qualifiedHasPackage_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: qualifiedHasPackage in class: ast.AST.SynDecl");
    }
    qualifiedHasPackage_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));
    boolean cycleEndStore = state.CYCLE_END;
    boolean qualifiedHasPackage_String_value = qualifiedHasPackage_compute(name);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      qualifiedHasPackage_String_values.put(_parameters, Boolean.valueOf(qualifiedHasPackage_String_value)); 
      //Tracer.traceCached(this, "PackageName.qualifiedHasPackage", name, "" + qualifiedHasPackage_String_value);
    } //else Tracer.traceCacheAbort(this, "PackageName.qualifiedHasPackage", name, "" + qualifiedHasPackage_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    qualifiedHasPackage_String_visited.remove(_parameters);
    return qualifiedHasPackage_String_value;
  }

  private boolean qualifiedHasPackage_compute(String name) {  return hasPackage(getname() + '.' + name);  }

  public ASTNode rewriteTo() {    return super.rewriteTo(); }
}
