
package AST;

public class AmbiguousName extends Name implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public AmbiguousName clone() throws CloneNotSupportedException {
    AmbiguousName node = (AmbiguousName) super.clone();
    node.predKind_visited = -1;
    node.predKind_computed = false;
    node.predKind_value = null;
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public AmbiguousName copy() {
    try {
      AmbiguousName node = (AmbiguousName) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public AmbiguousName fullCopy() {
    AmbiguousName tree = (AmbiguousName) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public AmbiguousName() {
    super();
  }

  public void init$Children() {
  }

  public AmbiguousName(String p0) {
    setname(p0);
  }

  protected int numChildren() {
    return 0;
  }

  public boolean mayHaveRewrite() {
    return true;
  }

  public void flushCache() {
    super.flushCache();
    predKind_visited = -1;
    predKind_computed = false;
    predKind_value = null;
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setname(String value) {
    tokenString_name = value;
  }

  public String getname() {
    return tokenString_name != null ? tokenString_name : "";
  }

  protected int predKind_visited = -1;
  protected boolean predKind_computed = false;
  protected Kind predKind_value;

  public Kind predKind() {
    if(predKind_computed) {
    	return predKind_value;
    }
    ASTNode$State state = state();
    if (predKind_visited == state.CIRCLE_INDEX) {
      throw new RuntimeException("Circular definition of attr: predKind in class: ast.AST.SynDecl");
    }     
    predKind_visited = state.CIRCLE_INDEX; 
    boolean cycleEndStore = state.CYCLE_END;
    predKind_value = predKind_compute();
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
	  	predKind_computed = true;
      //Tracer.traceCached(this, "AmbiguousName.predKind", "", "" + predKind_value);
    } //else Tracer.traceCacheAbort(this, "AmbiguousName.predKind", "", "" + predKind_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    predKind_visited = -1;
    return predKind_value;
  }

  private Kind predKind_compute() {  return Kind.AMBIGUOUS_NAME;  }

  public ASTNode rewriteTo() {
    if (lookupVariable(getname()) != null) {
      state().duringJavaDemoNames++;
      ASTNode result = rewriteRule0();
      state().duringJavaDemoNames--;
      return result;
    }
    if (lookupType(getname()) != null) {
      state().duringJavaDemoNames++;
      ASTNode result = rewriteRule1();
      state().duringJavaDemoNames--;
      return result;
    }
    if (hasPackage(getname())) {
      state().duringJavaDemoNames++;
      ASTNode result = rewriteRule2();
      state().duringJavaDemoNames--;
      return result;
    }    return super.rewriteTo();
  }  

  private Name rewriteRule0() {
    return new ExpressionName(getname());
  }

  private Name rewriteRule1() {
    return new TypeName(getname());
  }

  private Name rewriteRule2() {
    return new PackageName(getname());
  }
}
