import AST.*;
public class CountTestNested {

  public static void main(String[] args) {

    // Nesting level
    if (args.length != 1) {
      System.err.println("Usage: java MeasureTest nestingLevel");
      System.exit(1);
    }
    int level = Integer.parseInt(args[0]);
    System.out.println("Using nesting level: " + level);

    Prog p = TestNestedDotList.createAST(level);
    p.traverse();
    Tracer.printComputeReport();
    //Tracer.printTrace();
    System.out.print("Initial AST:\n" + p.printInitTree());
    System.out.print("Computed AST:\n" + p.printTree());
    Tracer.printCopyReport();
    Tracer.printNestingReport();
    Tracer.printInhAttrEvalReport();
  }
}
