
package AST;

public class TypeName extends Name implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public TypeName clone() throws CloneNotSupportedException {
    TypeName node = (TypeName) super.clone();
    node.type_visited = -1;
    node.type_computed = false;
    node.type_value = null;
    node.predKind_visited = -1;
    node.predKind_computed = false;
    node.predKind_value = null;
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public TypeName copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      TypeName node = (TypeName) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public TypeName fullCopy() {
    TypeName tree = (TypeName) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public TypeName() {
    super();
  }

  public void init$Children() {
  }

  public TypeName(String p0) {
    setname(p0);
  }

  protected int numChildren() {
    return 0;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
    type_visited = -1;
    type_computed = false;
    type_value = null;
    predKind_visited = -1;
    predKind_computed = false;
    predKind_value = null;
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setname(String value) {
    tokenString_name = value;
  }

  public String getname() {
    return tokenString_name != null ? tokenString_name : "";
  }

  protected int type_visited = -1;
  protected boolean type_computed = false;
  protected ClassDecl type_value;

  public ClassDecl type() {
    if(type_computed) {
      return type_value;
    }
    ASTNode$State state = state();
    if (type_visited == state.CIRCLE_INDEX) {
      throw new RuntimeException("Circular definition of attr: type in class: ast.AST.SynDecl");
    }     
    type_visited = state.CIRCLE_INDEX; 
    boolean cycleEndStore = state.CYCLE_END;
    type_value = type_compute();
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      type_computed = true; 
      Tracer.traceCached(this, "TypeName.type", "", "" + type_value);
    } else Tracer.traceCacheAbort(this, "TypeName.type", "", "" + type_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    type_visited = -1;
    return type_value;
  }

  private ClassDecl type_compute() {  return lookupType(getname()) != null ?
        lookupType(getname()) : unknownType();  }

  protected int predKind_visited = -1;
  protected boolean predKind_computed = false;
  protected Kind predKind_value;

  public Kind predKind() {
    if(predKind_computed) {
      return predKind_value;
    }
    ASTNode$State state = state();
    if (predKind_visited == state.CIRCLE_INDEX) {
      throw new RuntimeException("Circular definition of attr: predKind in class: ast.AST.SynDecl");
    }     
    predKind_visited = state.CIRCLE_INDEX; 
    boolean cycleEndStore = state.CYCLE_END;
    predKind_value = predKind_compute();
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      predKind_computed = true; 
      Tracer.traceCached(this, "TypeName.predKind", "", "" + predKind_value);
    } else Tracer.traceCacheAbort(this, "TypeName.predKind", "", "" + predKind_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    predKind_visited = -1;
    return predKind_value;
  }

  private Kind predKind_compute() {  return Kind.PACKAGE_OR_TYPE_NAME;  }

  public ASTNode rewriteTo() {    return super.rewriteTo(); }
}
