
package AST;

public class Prog extends ASTNode<ASTNode> implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public Prog clone() throws CloneNotSupportedException {
    Prog node = (Prog) super.clone();
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public Prog copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      Prog node = (Prog) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public Prog fullCopy() {
    Prog tree = (Prog) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public String printTree() {
    StringBuffer buf = new StringBuffer();
    for(int i = 0; i < getNumCompUnit(); i++) {
      buf.append(getCompUnit(i).dumpTree(0));
    }
    return buf.toString();
  }

  public String printInitTree() {
    StringBuffer buf = new StringBuffer();
    for(int i = 0; i < getNumCompUnitNoTransform(); i++) {
      buf.append(getCompUnitListNoTransform().getChildNoTransform(i).dumpInitTree(0));
    }
    return buf.toString();
  }

  public Prog() {
    super();
  }

  public void init$Children() {
    children = new ASTNode[1];
    setChild(new List(), 0);
  }

  public Prog(List<CompUnit> p0) {
    setChild(p0, 0);
  }

  protected int numChildren() {
    return 1;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setCompUnitList(List<CompUnit> list) {
    setChild(list, 0);
  }

  public int getNumCompUnit() {
    return getCompUnitList().getNumChild();
  }

  public int getNumCompUnitNoTransform() {
    return getCompUnitListNoTransform().getNumChildNoTransform();
  }

  @SuppressWarnings({"unchecked", "cast"})
  public CompUnit getCompUnit(int i) {
    return (CompUnit) getCompUnitList().child(i);
  }

  public void addCompUnit(CompUnit node) {
    List<CompUnit> list = (parent == null || state == null) ? getCompUnitListNoTransform() : getCompUnitList();
    list.addChild(node);
  }

  public void addCompUnitNoTransform(CompUnit node) {
    List<CompUnit> list = getCompUnitListNoTransform();
    list.addChild(node);
  }

  public void setCompUnit(CompUnit node, int i) {
    List<CompUnit> list = getCompUnitList();
    list.setChild(node, i);
  }

  @SuppressWarnings({"unchecked", "cast"})
  public List<CompUnit> getCompUnitList() {
    return (List<CompUnit>) child(0);
  }

  @SuppressWarnings({"unchecked", "cast"})
  public List<CompUnit> getCompUnitListNoTransform() {
    return (List<CompUnit>) getChildNoTransform(0);
  }

  public List<CompUnit> getCompUnits() {
    return getCompUnitList();
  }

  public List<CompUnit> getCompUnitsNoTransform() {
    return getCompUnitListNoTransform();
  }

  public ClassDecl Define_ClassDecl_unknownType(ASTNode caller, ASTNode child) {
    Tracer.traceInhAttrEval(this, "Prog.child.unknownType", "", nodeToString(caller));
    if(caller == getCompUnitListNoTransform() || caller == rewriteChild_int_list)  {
    int childIndex = caller.getIndexOfChild(child);
    {
    return new ClassDecl("unknown", new TypeName("Object"), new List() ) {
      public ClassDecl memberClass(String name) {
        return null;
      }
      public FieldDecl memberField(String name) {
        return null;
      }
    };
  }
  }
    else {      return getParent().Define_ClassDecl_unknownType(this, caller);
    }
  }

  public Variable Define_Variable_lookupVariable(ASTNode caller, ASTNode child, String name) {
    Tracer.traceInhAttrEval(this, "Prog.child.lookupVariable", name, nodeToString(caller));
    if(caller == getCompUnitListNoTransform() || caller == rewriteChild_int_list)  {
    int childIndex = caller.getIndexOfChild(child);
    return null;
  }
    else {      return getParent().Define_Variable_lookupVariable(this, caller, name);
    }
  }

  public ClassDecl Define_ClassDecl_lookupCanonical(ASTNode caller, ASTNode child, String pack, String type) {
    Tracer.traceInhAttrEval(this, "Prog.child.lookupCanonical", "[" + pack + "," + type + "]", nodeToString(caller));
    if(caller == getCompUnitListNoTransform() || caller == rewriteChild_int_list)  {
    int childIndex = caller.getIndexOfChild(child);
    {
    for(int i = 0; i < getNumCompUnit(); i++)
      if(getCompUnit(i).getpackageName().equals(pack) && 
         getCompUnit(i).topLevelType(type) != null)
        return getCompUnit(i).topLevelType(type);
    return null;
  }
  }
    else {      return getParent().Define_ClassDecl_lookupCanonical(this, caller, pack, type);
    }
  }

  public ClassDecl Define_ClassDecl_lookupType(ASTNode caller, ASTNode child, String name) {
    Tracer.traceInhAttrEval(this, "Prog.child.lookupType", name, nodeToString(caller));
    if(caller == getCompUnitListNoTransform() || caller == rewriteChild_int_list)  {
    int childIndex = caller.getIndexOfChild(child);
    return null;
  }
    else {      return getParent().Define_ClassDecl_lookupType(this, caller, name);
    }
  }

  public Kind Define_Kind_kind(ASTNode caller, ASTNode child) {
    Tracer.traceInhAttrEval(this, "Prog.child.kind", "", nodeToString(caller));
    if(caller == getCompUnitListNoTransform() || caller == rewriteChild_int_list)  {
    int childIndex = caller.getIndexOfChild(child);
    return Kind.AMBIGUOUS_NAME;
  }
    else {      return getParent().Define_Kind_kind(this, caller);
    }
  }

  public boolean Define_boolean_hasPackage(ASTNode caller, ASTNode child, String name) {
    Tracer.traceInhAttrEval(this, "Prog.child.hasPackage", "", nodeToString(caller));
    if(caller == getCompUnitListNoTransform() || caller == rewriteChild_int_list)  {
    int childIndex = caller.getIndexOfChild(child);
    {
    for(int i = 0; i < getNumCompUnit(); i++)
      if(getCompUnit(i).getpackageName().equals(name))
        return true;
    return false;
  }
  }
    else {      return getParent().Define_boolean_hasPackage(this, caller, name);
    }
  }

  public ASTNode rewriteTo() {    return super.rewriteTo(); }
}
