
package AST;

public class ParseName extends Name implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public ParseName clone() throws CloneNotSupportedException {
    ParseName node = (ParseName) super.clone();
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public ParseName copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      ParseName node = (ParseName) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public ParseName fullCopy() {
    ParseName tree = (ParseName) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public ParseName() {
    super();
  }

  public void init$Children() {
  }

  public ParseName(String p0) {
    setname(p0);
  }

  protected int numChildren() {
    return 0;
  }

  public boolean mayHaveRewrite() {
    return true;
  }

  public void flushCache() {
    super.flushCache();
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setname(String value) {
    tokenString_name = value;
  }

  public String getname() {
    return tokenString_name != null ? tokenString_name : "";
  }

  public ASTNode rewriteTo() {
    if (kind() == Kind.PACKAGE_NAME) {
      ASTNode result = rewriteRule0();
      return result;
    }   
    if (kind() == Kind.TYPE_NAME) {
      ASTNode result = rewriteRule1();
      return result;
    }   
    if (kind() == Kind.EXPRESSION_NAME) {
      ASTNode result = rewriteRule2();
      return result;
    }   
    if (kind() == Kind.PACKAGE_OR_TYPE_NAME) {
      ASTNode result = rewriteRule3();
      return result;
    }   
    if (kind() == Kind.AMBIGUOUS_NAME) {
      ASTNode result = rewriteRule4();
      return result;
    }    
    return super.rewriteTo();
  }  

  private Name rewriteRule0() {
    return new PackageName(getname());
  }
  
  private Name rewriteRule1() {
    return new TypeName(getname());
  }
  
  private Name rewriteRule2() {
    return new ExpressionName(getname());
  }
  
  private Name rewriteRule3() {
    return new PackageOrTypeName(getname());
  }
  
  private Name rewriteRule4() {
    return new AmbiguousName(getname());
  }
}
