
package AST;

public class MemberClassDecl extends BodyDecl implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public MemberClassDecl clone() throws CloneNotSupportedException {
    MemberClassDecl node = (MemberClassDecl) super.clone();
    node.isMemberClass_String_visited = null;
    node.isMemberClass_String_values = null;
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public MemberClassDecl copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      MemberClassDecl node = (MemberClassDecl) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public MemberClassDecl fullCopy() {
    MemberClassDecl tree = (MemberClassDecl) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public MemberClassDecl() {
    super();
  }

  public void init$Children() {
    children = new ASTNode[1];
  }

  public MemberClassDecl(ClassDecl p0) {
    setChild(p0, 0);
  }

  protected int numChildren() {
    return 1;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
    isMemberClass_String_visited = null;
    isMemberClass_String_values = null;
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setClassDecl(ClassDecl node) {
    setChild(node, 0);
  }

  public ClassDecl getClassDecl() {
    return (ClassDecl) child(0);
  }

  public ClassDecl getClassDeclNoTransform() {
    return (ClassDecl) getChildNoTransform(0);
  }

  protected java.util.Map isMemberClass_String_visited;
  protected java.util.Map isMemberClass_String_values;

  public boolean isMemberClass(String name) {
    Object _parameters = name;
    if(isMemberClass_String_visited == null) isMemberClass_String_visited = new java.util.HashMap(4);
    if(isMemberClass_String_values == null) isMemberClass_String_values = new java.util.HashMap(4);
    if(isMemberClass_String_values.containsKey(_parameters)) {
      return ((Boolean)isMemberClass_String_values.get(_parameters)).booleanValue(); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(isMemberClass_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: isMemberClass in class: ast.AST.SynDecl");
    }
    isMemberClass_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));
    boolean cycleEndStore = state.CYCLE_END;
    boolean isMemberClass_String_value = isMemberClass_compute(name);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      isMemberClass_String_values.put(_parameters, Boolean.valueOf(isMemberClass_String_value)); 
      Tracer.traceCached(this, "MemberClassDecl.isMemberClass", name, "" + isMemberClass_String_value);
    } else Tracer.traceCacheAbort(this, "MemberClassDecl.isMemberClass", name, "" + isMemberClass_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    isMemberClass_String_visited.remove(_parameters);
    return isMemberClass_String_value;
  }

  private boolean isMemberClass_compute(String name) {  return getClassDecl().getname().equals(name);  }

  public ASTNode rewriteTo() {    return super.rewriteTo(); }
}
