
package AST;

public class Initializer extends BodyDecl implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public Initializer clone() throws CloneNotSupportedException {
    Initializer node = (Initializer) super.clone();
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public Initializer copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      Initializer node = (Initializer) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public Initializer fullCopy() {
    Initializer tree = (Initializer) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public Initializer() {
    super();
  }

  public void init$Children() {
    children = new ASTNode[1];
  }

  public Initializer(Block p0) {
    setChild(p0, 0);
  }

  protected int numChildren() {
    return 1;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setBlock(Block node) {
    setChild(node, 0);
  }

  public Block getBlock() {
    return (Block) getChild(0);
  }

  public Block getBlockNoTransform() {
    return (Block) getChildNoTransform(0);
  }

  public ASTNode rewriteTo() {    return super.rewriteTo(); }
}
