
package AST;

public class FieldDecl extends BodyDecl implements Cloneable, Variable {

  @SuppressWarnings({"unchecked", "cast"})
  public FieldDecl clone() throws CloneNotSupportedException {
    FieldDecl node = (FieldDecl) super.clone();
    node.type_visited = -1;
    node.type_computed = false;
    node.type_value = null;
    node.isField_String_visited = null;
    node.isField_String_values = null;
    node.extra_visited = -1;
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public FieldDecl copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      FieldDecl node = (FieldDecl) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public FieldDecl fullCopy() {
    FieldDecl tree = (FieldDecl) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public FieldDecl() {
    super();
  }

  public void init$Children() {
    children = new ASTNode[2];
  }

  public FieldDecl(Name p0, String p1, Expr p2) {
    setChild(p0, 0);
    setname(p1);
    setChild(p2, 1);
  }

  protected int numChildren() {
    return 2;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
    type_visited = -1;
    type_computed = false;
    type_value = null;
    isField_String_visited = null;
    isField_String_values = null;
    extra_visited = -1;
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setFieldType(Name node) {
    setChild(node, 0);
  }

  public Name getFieldType() {
    return (Name) child(0);
  }

  public Name getFieldTypeNoTransform() {
    return (Name) getChildNoTransform(0);
  }

  public void setname(String value) {
    tokenString_name = value;
  }

  protected String tokenString_name;

  public String getname() {
    return tokenString_name != null ? tokenString_name : "";
  }

  public void setExpr(Expr node) {
    setChild(node, 1);
  }

  public Expr getExpr() {
    return (Expr) child(1);
  }

  public Expr getExprNoTransform() {
    return (Expr) getChildNoTransform(1);
  }

  protected int type_visited = -1;
  protected boolean type_computed = false;
  protected ClassDecl type_value;

  public ClassDecl type() {
    if(type_computed) {
      return type_value;
    }
    ASTNode$State state = state();
    if (type_visited == state.CIRCLE_INDEX) {
      throw new RuntimeException("Circular definition of attr: type in class: ast.AST.SynDecl");
    }
    type_visited = state.CIRCLE_INDEX;
    boolean cycleEndStore = state.CYCLE_END;
    type_value = type_compute();
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      type_computed = true; 
      Tracer.traceCached(this, "FieldDecl.type", "", "" + type_value);
    } else Tracer.traceCacheAbort(this, "FieldDecl.type", "", "" + type_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    type_visited = -1;
    return type_value;
  }

  private ClassDecl type_compute() {  return getFieldType().type();  }

  protected java.util.Map isField_String_visited;
  protected java.util.Map isField_String_values;

  public boolean isField(String name) {
    Object _parameters = name;
    if(isField_String_visited == null) isField_String_visited = new java.util.HashMap(4);
    if(isField_String_values == null) isField_String_values = new java.util.HashMap(4);
    if(isField_String_values.containsKey(_parameters)) {
      return ((Boolean)isField_String_values.get(_parameters)).booleanValue(); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(isField_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: isField in class: ast.AST.SynDecl");
    }           
    isField_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));     
    boolean cycleEndStore = state.CYCLE_END;
    boolean isField_String_value = isField_compute(name);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      isField_String_values.put(_parameters, Boolean.valueOf(isField_String_value)); 
      Tracer.traceCached(this, "FieldDecl.isField", name, "" + isField_String_value);
    } else Tracer.traceCacheAbort(this, "FieldDecl.isField", name, "" + isField_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    isField_String_visited.remove(_parameters);
    return isField_String_value;
  }

  private boolean isField_compute(String name) {  return getname().equals(name);  }

  protected int extra_visited = -1;

  public String extra() {
    ASTNode$State state = state();
    if (extra_visited == state.CIRCLE_INDEX) {
      throw new RuntimeException("Circular definition of attr: extra in class: ast.AST.SynDecl");
    }          
    extra_visited = state.CIRCLE_INDEX; 
    try {  return ", fieldDecl: " + getname();  }
    finally {
      extra_visited = -1;
    }
  }

  public Kind Define_Kind_kind(ASTNode caller, ASTNode child) {
    Tracer.traceInhAttrEval(this, "FieldDecl.child.kind", "", nodeToString(caller));
    if(caller == getExprNoTransform() || (rewriteChild_int_values != null && 
                                          child == rewriteChild_int_values.get(Integer.valueOf(1)))) {
      return Kind.EXPRESSION_NAME;
    }
    else if(caller == getFieldTypeNoTransform() || (rewriteChild_int_values != null && 
                               child == rewriteChild_int_values.get(Integer.valueOf(0)))) {
      return Kind.TYPE_NAME;
    }
    else {      
      return getParent().Define_Kind_kind(this, caller);
    }
  }

  public ASTNode rewriteTo() {    return super.rewriteTo(); }
}
