
package AST;

public class CompUnit extends ASTNode<ASTNode> implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public CompUnit clone() throws CloneNotSupportedException {
    CompUnit node = (CompUnit) super.clone();
    node.topLevelType_String_visited = null;
    node.topLevelType_String_values = null;
    node.extra_visited = -1;
    node.unknownType_visited = -1;
    node.unknownType_computed = false;
    node.unknownType_value = null;
    node.lookupVariable_String_visited = null;
    node.lookupVariable_String_values = null;
    node.lookupType_String_visited = null;
    node.lookupType_String_values = null;
    node.lookupCanonical_String_String_visited = null;
    node.lookupCanonical_String_String_values = null;
    node.kind_visited = -1;
    node.kind_computed = false;
    node.kind_value = null;
    node.hasPackage_String_visited = null;
    node.hasPackage_String_values = null;
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public CompUnit copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      CompUnit node = (CompUnit) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public CompUnit fullCopy() {
    CompUnit tree = (CompUnit) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public CompUnit() {
    super();
  }

  public void init$Children() {
    children = new ASTNode[1];
    setChild(new List(), 0);
  }

  public CompUnit(String p0, List<ClassDecl> p1) {
    setpackageName(p0);
    setChild(p1, 0);
  }

  protected int numChildren() {
    return 1;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
    topLevelType_String_visited = null;
    topLevelType_String_values = null;
    extra_visited = -1;
    unknownType_visited = -1;
    unknownType_computed = false;
    unknownType_value = null;
    lookupVariable_String_visited = null;
    lookupVariable_String_values = null;
    lookupType_String_visited = null;
    lookupType_String_values = null;
    lookupCanonical_String_String_visited = null;
    lookupCanonical_String_String_values = null;
    kind_visited = -1;
    kind_computed = false;
    kind_value = null;
    hasPackage_String_visited = null;
    hasPackage_String_values = null;
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setpackageName(String value) {
    tokenString_packageName = value;
  }

  protected String tokenString_packageName;

  public String getpackageName() {
    return tokenString_packageName != null ? tokenString_packageName : "";
  }

  public void setClassDeclList(List<ClassDecl> list) {
    setChild(list, 0);
  }

  public int getNumClassDecl() {
    return getClassDeclList().getNumChild();
  }

  public int getNumClassDeclNoTransform() {
    return getClassDeclListNoTransform().getNumChildNoTransform();
  }

  @SuppressWarnings({"unchecked", "cast"})
  public ClassDecl getClassDecl(int i) {
    return (ClassDecl) getClassDeclList().child(i);
  }

  public void addClassDecl(ClassDecl node) {
    List<ClassDecl> list = (parent == null || state == null) ? getClassDeclListNoTransform() : getClassDeclList();
    list.addChild(node);
  }

  public void addClassDeclNoTransform(ClassDecl node) {
    List<ClassDecl> list = getClassDeclListNoTransform();
    list.addChild(node);
  }

  public void setClassDecl(ClassDecl node, int i) {
    List<ClassDecl> list = getClassDeclList();
    list.setChild(node, i);
  }

  @SuppressWarnings({"unchecked", "cast"})
  public List<ClassDecl> getClassDeclList() {
    return (List<ClassDecl>) child(0);
  }

  @SuppressWarnings({"unchecked", "cast"})
  public List<ClassDecl> getClassDeclListNoTransform() {
    return (List<ClassDecl>) getChildNoTransform(0);
  }

  public List<ClassDecl> getClassDecls() {
    return getClassDeclList();
  }

  public List<ClassDecl> getClassDeclsNoTransform() {
    return getClassDeclListNoTransform();
  }

  protected java.util.Map topLevelType_String_visited;
  protected java.util.Map topLevelType_String_values;

  public ClassDecl topLevelType(String name) {
    Object _parameters = name;
    if(topLevelType_String_visited == null) topLevelType_String_visited = new java.util.HashMap(4);
    if(topLevelType_String_values == null) topLevelType_String_values = new java.util.HashMap(4);
    if(topLevelType_String_values.containsKey(_parameters)) {
      return (ClassDecl)topLevelType_String_values.get(_parameters); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(topLevelType_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: topLevelType in class: ast.AST.SynDecl");
    }            
    topLevelType_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));      
    boolean cycleEndStore = state.CYCLE_END;
    ClassDecl topLevelType_String_value = topLevelType_compute(name);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      topLevelType_String_values.put(_parameters, topLevelType_String_value); 
      Tracer.traceCached(this, "ClassDecl.topLevelType", name, "" + topLevelType_String_value);
    } else Tracer.traceCacheAbort(this, "ClassDecl.topLevelType", name, "" + topLevelType_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    topLevelType_String_visited.remove(_parameters);
    return topLevelType_String_value;
  }

  private ClassDecl topLevelType_compute(String name) {
    for(int i = 0; i < getNumClassDecl(); i++)
      if(getClassDecl(i).getname().equals(name))
        return getClassDecl(i);
    return null;
  }

  protected int extra_visited = -1;

  public String extra() {
    ASTNode$State state = state();
    if (extra_visited == state.CIRCLE_INDEX) {
      throw new RuntimeException("Circular definition of attr: extra in class: ast.AST.SynDecl");
    }          
    extra_visited = state.CIRCLE_INDEX; 
    try {  return ", packageName: " + getpackageName();  }
    finally {
      extra_visited = -1;
    }
  }

  public ClassDecl unknownType() {
    if(unknownType_computed) {
      return unknownType_value;
    }
    ASTNode$State state = state();
    if (unknownType_visited == state.CIRCLE_INDEX) {
      throw new RuntimeException("Circular definition of attr: unknownType in class: ast.AST.InhDecl");
    }     
    unknownType_visited = state.CIRCLE_INDEX; 
    boolean cycleEndStore = state.CYCLE_END;
    unknownType_value = getParent().Define_ClassDecl_unknownType(this, null);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      unknownType_computed = true; 
      Tracer.traceCached(this, "CompUnit.unknownType", "", "" + unknownType_value);
    } else Tracer.traceCacheAbort(this, "CompUnit.unknownType", "", "" + unknownType_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    unknownType_visited = -1;
    return unknownType_value;
  }

  protected int unknownType_visited = -1;
  protected boolean unknownType_computed = false;
  protected ClassDecl unknownType_value;

  public Variable lookupVariable(String name) {
    Object _parameters = name;
    if(lookupVariable_String_visited == null) lookupVariable_String_visited = new java.util.HashMap(4);
    if(lookupVariable_String_values == null) lookupVariable_String_values = new java.util.HashMap(4);
    if(lookupVariable_String_values.containsKey(_parameters)) {
      return (Variable)lookupVariable_String_values.get(_parameters); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(lookupVariable_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: lookupVariable in class: ast.AST.InhDecl");
    }
    lookupVariable_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));
    boolean cycleEndStore = state.CYCLE_END;
    Variable lookupVariable_String_value = getParent().Define_Variable_lookupVariable(this, null, name);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      lookupVariable_String_values.put(_parameters, lookupVariable_String_value); 
      Tracer.traceCached(this, "CompUnit.lookupVariable", name, "" + lookupVariable_String_value);
    } else Tracer.traceCacheAbort(this, "CompUnit.lookupVariable", name, "" + lookupVariable_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    lookupVariable_String_visited.remove(_parameters);
    return lookupVariable_String_value;
  }

  protected java.util.Map lookupVariable_String_visited;
  protected java.util.Map lookupVariable_String_values;

  public ClassDecl lookupType(String name) {
    Object _parameters = name;
    if(lookupType_String_visited == null) lookupType_String_visited = new java.util.HashMap(4);
    if(lookupType_String_values == null) lookupType_String_values = new java.util.HashMap(4);
    if(lookupType_String_values.containsKey(_parameters)) {
      return (ClassDecl)lookupType_String_values.get(_parameters);
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(lookupType_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: lookupType in class: ast.AST.InhDecl");
    }
    lookupType_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));
    boolean cycleEndStore = state.CYCLE_END;
    ClassDecl lookupType_String_value = getParent().Define_ClassDecl_lookupType(this, null, name);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      lookupType_String_values.put(_parameters, lookupType_String_value); 
      Tracer.traceCached(this, "CompUnit.lookupType", name, "" + lookupType_String_value);
    } else Tracer.traceCacheAbort(this, "CompUnit.lookupType", name, "" + lookupType_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    lookupType_String_visited.remove(_parameters);
    return lookupType_String_value;
  }

  protected java.util.Map lookupType_String_visited;
  protected java.util.Map lookupType_String_values;

  public ClassDecl lookupCanonical(String pack, String type) {
    java.util.List _parameters = new java.util.ArrayList(2);
    _parameters.add(pack);
    _parameters.add(type);
    if(lookupCanonical_String_String_visited == null) lookupCanonical_String_String_visited = new java.util.HashMap(4);
    if(lookupCanonical_String_String_values == null) lookupCanonical_String_String_values = new java.util.HashMap(4);
    if(lookupCanonical_String_String_values.containsKey(_parameters)) {
      return (ClassDecl)lookupCanonical_String_String_values.get(_parameters); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(lookupCanonical_String_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: lookupCanonical in class: ast.AST.InhDecl");
    }
    lookupCanonical_String_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));
    boolean cycleEndStore = state.CYCLE_END;
    ClassDecl lookupCanonical_String_String_value = getParent().Define_ClassDecl_lookupCanonical(this, null, pack, type);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      lookupCanonical_String_String_values.put(_parameters, lookupCanonical_String_String_value); 
      Tracer.traceCached(this, "CompUnit.lookupCanonical", "" + _parameters, "" + lookupCanonical_String_String_value);
    } else Tracer.traceCacheAbort(this, "CompUnit.lookupCanonical", "" + _parameters, "" + lookupCanonical_String_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    lookupCanonical_String_String_visited.remove(_parameters);
    return lookupCanonical_String_String_value;
  }

  protected java.util.Map lookupCanonical_String_String_visited;
  protected java.util.Map lookupCanonical_String_String_values;

  public Kind kind() {
    if(kind_computed) {
      return kind_value;
    }
    ASTNode$State state = state();
    if (kind_visited == state.CIRCLE_INDEX) {
      throw new RuntimeException("Circular definition of attr: kind in class: ast.AST.InhDecl");
    }     
    kind_visited = state.CIRCLE_INDEX; 
    boolean cycleEndStore = state.CYCLE_END;    
    kind_value = getParent().Define_Kind_kind(this, null);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      kind_computed = true;
      Tracer.traceCached(this, "CompUnit.kind", "", "" + kind_value);
    } else Tracer.traceCacheAbort(this, "CompUnit.kind", "", "" + kind_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    kind_visited = -1;
    return kind_value;
  }

  protected int kind_visited = -1;
  protected boolean kind_computed = false;
  protected Kind kind_value;

  public boolean hasPackage(String name) {
    Object _parameters = name;
    if(hasPackage_String_visited == null) hasPackage_String_visited = new java.util.HashMap(4);
    if(hasPackage_String_values == null) hasPackage_String_values = new java.util.HashMap(4);
    if(hasPackage_String_values.containsKey(_parameters)) {
      return ((Boolean)hasPackage_String_values.get(_parameters)).booleanValue(); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(hasPackage_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: hasPackage in class: ast.AST.InhDecl");
    }           
    hasPackage_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));     
    boolean cycleEndStore = state.CYCLE_END;
    boolean hasPackage_String_value = getParent().Define_boolean_hasPackage(this, null, name);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      hasPackage_String_values.put(_parameters, Boolean.valueOf(hasPackage_String_value)); 
      Tracer.traceCached(this, "hasPackage", name, "" + hasPackage_String_value);
    } else Tracer.traceCacheAbort(this, "hasPackage", name, "" + hasPackage_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    hasPackage_String_visited.remove(_parameters);
    return hasPackage_String_value;
  }

  protected java.util.Map hasPackage_String_visited;
  protected java.util.Map hasPackage_String_values;

  public ClassDecl Define_ClassDecl_lookupType(ASTNode caller, ASTNode child, String name) {
    Tracer.traceInhAttrEval(this, "CompUnit.child.lookupType", name, nodeToString(caller));
    if(caller == getClassDeclListNoTransform() || caller == rewriteChild_int_list)  {
      int childIndex = caller.getIndexOfChild(child);
      {
        if(topLevelType(name) != null)
          return topLevelType(name);
        // declarations in same package
        return lookupCanonical(getpackageName(), name);
      }
    } else {      
      return getParent().Define_ClassDecl_lookupType(this, caller, name);
    }
  }

  public ASTNode rewriteTo() {    return super.rewriteTo(); }
}
