
package AST;

public class ClassDecl extends ASTNode<ASTNode> implements Cloneable {

  @SuppressWarnings({"unchecked", "cast"})
  public ClassDecl clone() throws CloneNotSupportedException {
    ClassDecl node = (ClassDecl) super.clone();
    node.memberField_String_visited = null;
    node.memberField_String_values = null;
    node.memberClass_String_visited = null;
    node.memberClass_String_values = null;
    node.extra_visited = -1;
    node.lookupVariable_String_visited = null;
    node.lookupVariable_String_values = null;
    node.lookupType_String_visited = null;
    node.lookupType_String_values = null;
    return node;
  }

  @SuppressWarnings({"unchecked", "cast"})
  public ClassDecl copy() {
    try {
      Tracer.traceCopy(this, nodeToString(this));
      ClassDecl node = (ClassDecl) clone();
      node.parent = null;
      if(children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }

  @SuppressWarnings({"unchecked", "cast"})
  public ClassDecl fullCopy() {
    ClassDecl tree = (ClassDecl) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if(child != null) {
          child = child.fullCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }

  public ClassDecl() {
    super();
  }

  public void init$Children() {
    children = new ASTNode[2];
    setChild(new List(), 1);
  }

  public ClassDecl(String p0, Name p1, List<BodyDecl> p2) {
    setname(p0);
    setChild(p1, 0);
    setChild(p2, 1);
  }

  protected int numChildren() {
    return 2;
  }

  public boolean mayHaveRewrite() {
    return false;
  }

  public void flushCache() {
    super.flushCache();
    memberField_String_visited = null;
    memberField_String_values = null;
    memberClass_String_visited = null;
    memberClass_String_values = null;
    extra_visited = -1;
    lookupVariable_String_visited = null;
    lookupVariable_String_values = null;
    lookupType_String_visited = null;
    lookupType_String_values = null;
  }

  public void flushCollectionCache() {
    super.flushCollectionCache();
  }

  public void setname(String value) {
    tokenString_name = value;
  }

  protected String tokenString_name;

  public String getname() {
    return tokenString_name != null ? tokenString_name : "";
  }

  public void setSuper(Name node) {
    setChild(node, 0);
  }

  public Name getSuper() {
    return (Name) child(0);
  }

  public Name getSuperNoTransform() {
    return (Name) getChildNoTransform(0);
  }

  public void setBodyDeclList(List<BodyDecl> list) {
    setChild(list, 1);
  }

  public int getNumBodyDecl() {
    return getBodyDeclList().getNumChild();
  }

  public int getNumBodyDeclNoTransform() {
    return getBodyDeclListNoTransform().getNumChildNoTransform();
  }

  @SuppressWarnings({"unchecked", "cast"})
  public BodyDecl getBodyDecl(int i) {
    return (BodyDecl) getBodyDeclList().child(i);
  }

  public void addBodyDecl(BodyDecl node) {
    List<BodyDecl> list = (parent == null || state == null) ? getBodyDeclListNoTransform() : getBodyDeclList();
    list.addChild(node);
  }

  public void addBodyDeclNoTransform(BodyDecl node) {
    List<BodyDecl> list = getBodyDeclListNoTransform();
    list.addChild(node);
  }

  public void setBodyDecl(BodyDecl node, int i) {
    List<BodyDecl> list = getBodyDeclList();
    list.setChild(node, i);
  }

  @SuppressWarnings({"unchecked", "cast"})
  public List<BodyDecl> getBodyDeclList() {
    return (List<BodyDecl>) child(1);
  }

  @SuppressWarnings({"unchecked", "cast"})
  public List<BodyDecl> getBodyDeclListNoTransform() {
    return (List<BodyDecl>) getChildNoTransform(1);
  }

  public List<BodyDecl> getBodyDecls() {
    return getBodyDeclList();
  }

  public List<BodyDecl> getBodyDeclsNoTransform() {
    return getBodyDeclListNoTransform();
  }

  protected java.util.Map memberField_String_visited;
  protected java.util.Map memberField_String_values;

  public FieldDecl memberField(String name) {
    Object _parameters = name;
    if(memberField_String_visited == null) memberField_String_visited = new java.util.HashMap(4);
    if(memberField_String_values == null) memberField_String_values = new java.util.HashMap(4);
    if(memberField_String_values.containsKey(_parameters)) {
      return (FieldDecl)memberField_String_values.get(_parameters); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(memberField_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: memberField in class: ast.AST.SynDecl");
    }           
    memberField_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));     
    boolean cycleEndStore = state.CYCLE_END;
    FieldDecl memberField_String_value = memberField_compute(name);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      memberField_String_values.put(_parameters, memberField_String_value);
      Tracer.traceCached(this, "ClassDecl.memberField", name, "" + memberField_String_value);
    } else Tracer.traceCacheAbort(this, "ClassDecl.memberField", name, "" + memberField_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    memberField_String_visited.remove(_parameters);
    return memberField_String_value;
  }

  private FieldDecl memberField_compute(String name) {
    for(int i = 0; i < getNumBodyDecl(); i++)
      if(getBodyDecl(i).isField(name))
        return (FieldDecl)getBodyDecl(i);
    if(!getname().equals("Object") && getSuper().type().memberField(name) != null)
      return getSuper().type().memberField(name);
    return null;
  }

  protected java.util.Map memberClass_String_visited;
  protected java.util.Map memberClass_String_values;

  public ClassDecl memberClass(String name) {
    Object _parameters = name;
    if(memberClass_String_visited == null) memberClass_String_visited = new java.util.HashMap(4);
    if(memberClass_String_values == null) memberClass_String_values = new java.util.HashMap(4);
    if(memberClass_String_values.containsKey(_parameters)) {
      return (ClassDecl)memberClass_String_values.get(_parameters); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(memberClass_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: memberClass in class: ast.AST.SynDecl");
    }           
    memberClass_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));
    boolean cycleEndStore = state.CYCLE_END;     
    ClassDecl memberClass_String_value = memberClass_compute(name);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      memberClass_String_values.put(_parameters, memberClass_String_value); 
      Tracer.traceCached(this, "ClassDecl.memberClass", name, "" + memberClass_String_value);
    } else Tracer.traceCacheAbort(this, "ClassDecl.memberClass", name, "" + memberClass_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    memberClass_String_visited.remove(_parameters);
    return memberClass_String_value;
  }

  private ClassDecl memberClass_compute(String name) {
    for(int i = 0; i < getNumBodyDecl(); i++)
      if(getBodyDecl(i).isMemberClass(name))
        return ((MemberClassDecl)getBodyDecl(i)).getClassDecl();
    if(!getname().equals("Object") && getSuper().type().memberClass(name) != null)
      return getSuper().type().memberClass(name);
    return null;
  }

  protected int extra_visited = -1;

  public String extra() {
    ASTNode$State state = state();
    if (extra_visited == state.CIRCLE_INDEX) {
      throw new RuntimeException("Circular definition of attr: extra in class: ast.AST.SynDecl");
    }          
    extra_visited = state.CIRCLE_INDEX; 
    try {  return ", classDecl: " + getname();  }
    finally {
      extra_visited = -1;
    }
  }

  public Variable lookupVariable(String name) {
    Object _parameters = name;
    if(lookupVariable_String_visited == null) lookupVariable_String_visited = new java.util.HashMap(4);
    if(lookupVariable_String_values == null) lookupVariable_String_values = new java.util.HashMap(4);
    if(lookupVariable_String_values.containsKey(_parameters)) {
      return (Variable)lookupVariable_String_values.get(_parameters); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(lookupVariable_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: lookupVariable in class: ast.AST.InhDecl");
    }            
    lookupVariable_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));
    boolean cycleEndStore = state.CYCLE_END;
    Variable lookupVariable_String_value = getParent().Define_Variable_lookupVariable(this, null, name);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      lookupVariable_String_values.put(_parameters, lookupVariable_String_value);
      Tracer.traceCached(this, "ClassDecl.lookupVariable", name, "" + lookupVariable_String_value);
    } else Tracer.traceCacheAbort(this, "ClassDecl.lookupVariable", name, "" + lookupVariable_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    lookupVariable_String_visited.remove(_parameters);
    return lookupVariable_String_value;
  }

  protected java.util.Map lookupVariable_String_visited;
  protected java.util.Map lookupVariable_String_values;

  public ClassDecl lookupType(String name) {
    Object _parameters = name;
    if(lookupType_String_visited == null) lookupType_String_visited = new java.util.HashMap(4);
    if(lookupType_String_values == null) lookupType_String_values = new java.util.HashMap(4);
    if(lookupType_String_values.containsKey(_parameters)) {
      return (ClassDecl)lookupType_String_values.get(_parameters); 
    }
    ASTNode$State state = state();
    if (Integer.valueOf(state.CIRCLE_INDEX).equals(lookupType_String_visited.get(_parameters))) {
      throw new RuntimeException("Circular definition of attr: lookupType in class: ast.AST.InhDecl");
    }           
    lookupType_String_visited.put(_parameters, Integer.valueOf(state.CIRCLE_INDEX));     
    boolean cycleEndStore = state.CYCLE_END;
    ClassDecl lookupType_String_value = getParent().Define_ClassDecl_lookupType(this, null, name);
    if (!state.IN_CIRCLE || state.IN_CIRCLE && (!state.CYCLE_END || state.LAST_CYCLE) ) {
      lookupType_String_values.put(_parameters, lookupType_String_value);
      Tracer.traceCached(this, "ClassDecl.lookupType", name, "" + lookupType_String_value);
    } else Tracer.traceCacheAbort(this, "ClassDecl.lookupType", name, "" + lookupType_String_value);
    state.CYCLE_END = cycleEndStore || state.CYCLE_END;
    lookupType_String_visited.remove(_parameters);
    return lookupType_String_value;
  }

  protected java.util.Map lookupType_String_visited;
  protected java.util.Map lookupType_String_values;

  public Variable Define_Variable_lookupVariable(ASTNode caller, ASTNode child, String name) {
    Tracer.traceInhAttrEval(this, "ClassDecl.child.lookupVariable", name, nodeToString(caller));
    if(caller == getBodyDeclListNoTransform() || caller == rewriteChild_int_list)  {
      int childIndex = caller.getIndexOfChild(child);
      {
        if(memberField(name) != null)
          return memberField(name);
        return lookupVariable(name);
      }
    } else {      
      return getParent().Define_Variable_lookupVariable(this, caller, name);
    }
  }

  public ClassDecl Define_ClassDecl_lookupType(ASTNode caller, ASTNode child, String name) {
    Tracer.traceInhAttrEval(this, "ClassDecl.child.lookupType", name, nodeToString(caller));
    if(caller == getBodyDeclListNoTransform() || caller == rewriteChild_int_list)  {
      int childIndex = caller.getIndexOfChild(child);
      {
        if(memberClass(name) != null)
          return memberClass(name);
        return lookupType(name);
      }
    } else {      
      return getParent().Define_ClassDecl_lookupType(this, caller, name);
    }
  }

  public Kind Define_Kind_kind(ASTNode caller, ASTNode child) {
    Tracer.traceInhAttrEval(this, "ClassDecl.child.kind", "", nodeToString(caller));
    if(caller == getSuperNoTransform() || (rewriteChild_int_values != null && child == rewriteChild_int_values.get(Integer.valueOf(0)))) {
      return Kind.PACKAGE_NAME;
    }
    else {      
      return getParent().Define_Kind_kind(this, caller);
    }
  }

  public ASTNode rewriteTo() { return super.rewriteTo(); }
}
