/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jastadd.util.PrettyPrintable;

public class PrettyPrinter {
    private final String indentation;
    private final List<String> ind = new ArrayList<String>(32);
    private final Stack<Integer> indentStack;
    private int currentIndent;
    private PrintStream out;
    private boolean newline;

    public PrettyPrinter(String string) {
        this.ind.add("");
        this.indentStack = new Stack();
        this.indentStack.push(0);
        this.currentIndent = 0;
        this.out = System.out;
        this.newline = false;
        this.indentation = string;
    }

    public void setTarget(PrintStream printStream) {
        this.out = printStream;
    }

    public String getIndentation(int n) {
        while (this.ind.size() < n + 1) {
            this.ind.add(this.ind.get(this.ind.size() - 1) + this.indentation);
        }
        return this.ind.get(n);
    }

    public void print(String string) {
        this.indentNewline();
        this.out.print(string);
    }

    public void println() {
        this.out.println();
        this.newline = true;
    }

    public void print(PrettyPrintable prettyPrintable) {
        this.pushIndentation();
        prettyPrintable.prettyPrint(this);
        this.popIndentation();
    }

    public void indent(int n) {
        this.currentIndent = n;
    }

    private void pushIndentation() {
        this.indentStack.push(this.currentIndent + this.indentStack.peek());
        this.currentIndent = 0;
    }

    private void popIndentation() {
        this.currentIndent = this.indentStack.pop();
        this.currentIndent -= this.indentStack.peek().intValue();
    }

    private void indentNewline() {
        if (this.newline) {
            this.out.print(this.getIndentation(this.indentStack.peek()));
            this.newline = false;
        }
    }
}

