/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate.fragment;

import java.io.PrintStream;
import org.jastadd.tinytemplate.EmptyTemplate;
import org.jastadd.tinytemplate.Indentation;
import org.jastadd.tinytemplate.Template;
import org.jastadd.tinytemplate.TemplateContext;
import org.jastadd.tinytemplate.TemplateParser;
import org.jastadd.tinytemplate.fragment.AbstractFragment;

public class Conditional
extends AbstractFragment {
    private String condition;
    private final Template thenPart;
    private final Template elsePart;
    private final boolean negated;
    private final boolean isAttribute;

    public Conditional(String string, Template template) throws TemplateParser.SyntaxError {
        this(string, template, EmptyTemplate.INSTANCE);
    }

    public Conditional(String string, Template template, Template template2) throws TemplateParser.SyntaxError {
        if (string.startsWith("!")) {
            this.negated = true;
            string = string.substring(1).trim();
        } else {
            this.negated = false;
        }
        if (string.startsWith("#")) {
            this.isAttribute = true;
            this.condition = string.substring(1);
        } else if (string.startsWith("$")) {
            this.isAttribute = false;
            this.condition = string.substring(1);
        } else {
            this.isAttribute = false;
            this.condition = string;
        }
        if (string.isEmpty()) {
            throw new TemplateParser.SyntaxError("empty if condition");
        }
        if (this.isAttribute) {
            TemplateParser.acceptAttributeName(-1, this.condition);
        } else {
            TemplateParser.acceptVariableName(-1, this.condition);
        }
        this.thenPart = template;
        this.thenPart.trimTrailingEmptyLine();
        this.elsePart = template2;
        this.elsePart.trimTrailingEmptyLine();
    }

    private boolean evalCondition(TemplateContext templateContext) {
        Object object = this.isAttribute ? templateContext.evalAttribute(this.condition) : templateContext.evalVariable(this.condition);
        boolean bl = object.toString().equals("true");
        return this.negated ? !bl : bl;
    }

    @Override
    public void expand(TemplateContext templateContext, StringBuilder stringBuilder) {
        if (this.evalCondition(templateContext)) {
            this.thenPart.expand(templateContext, stringBuilder);
        } else {
            this.elsePart.expand(templateContext, stringBuilder);
        }
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public boolean isExpansion() {
        return true;
    }

    @Override
    public void printAspectCode(Indentation indentation, int n, PrintStream printStream) {
        printStream.print(indentation.get(n) + "if (");
        if (this.negated) {
            printStream.print("!");
        }
        if (this.isAttribute) {
            printStream.print(this.condition + "()");
        } else {
            printStream.print("get" + this.condition + "()");
        }
        printStream.println(") {");
        this.thenPart.printITD(indentation, n + 1, printStream);
        if (!this.elsePart.isEmpty()) {
            printStream.println(indentation.get(n) + "} else {");
            this.elsePart.printITD(indentation, n + 1, printStream);
        }
        printStream.println(indentation.get(n) + "}");
    }
}

