/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate.fragment;

import java.io.PrintStream;
import org.jastadd.tinytemplate.Indentation;
import org.jastadd.tinytemplate.TemplateContext;
import org.jastadd.tinytemplate.TemplateExpansionWarning;
import org.jastadd.tinytemplate.TemplateParser;
import org.jastadd.tinytemplate.fragment.NestedIndentationFragment;

public class Concat
extends NestedIndentationFragment {
    private String iterable;
    private final String sep;
    private boolean isAttribute;

    public Concat(String string) throws TemplateParser.SyntaxError {
        this(string, null);
    }

    public Concat(String string, String string2) throws TemplateParser.SyntaxError {
        if (string.startsWith("#")) {
            this.iterable = string.substring(1);
            this.isAttribute = true;
        } else if (string.startsWith("$")) {
            this.iterable = string.substring(1);
            this.isAttribute = false;
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.sep = string2;
    }

    @Override
    public void expand(TemplateContext templateContext, StringBuilder stringBuilder) {
        if (!this.isAttribute) {
            throw new TemplateExpansionWarning("Variable " + this.iterable + " is not iterable");
        }
        this.expandAttribute(templateContext, stringBuilder);
    }

    private void expandAttribute(TemplateContext templateContext, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2;
        Object object = templateContext.evalAttribute(this.iterable);
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            stringBuilder2 = new StringBuilder();
            boolean bl = true;
            for (Object t : iterable) {
                if (this.sep != null && !bl) {
                    stringBuilder2.append(this.sep);
                }
                bl = false;
                stringBuilder2.append(String.valueOf(t));
            }
        } else {
            throw new TemplateExpansionWarning("Attribute " + this.iterable + " is not iterable");
        }
        this.expandWithIndentation(stringBuilder2.toString(), templateContext, stringBuilder);
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public boolean isExpansion() {
        return true;
    }

    @Override
    public void printAspectCode(Indentation indentation, int n, PrintStream printStream) {
        printStream.println(indentation.get(n++) + "{");
        if (!this.sep.isEmpty()) {
            printStream.println(indentation.get(n) + "boolean first = true;");
        }
        printStream.print(indentation.get(n++) + "for (PrettyPrintable p: ");
        if (this.isAttribute) {
            printStream.print(this.iterable + "()");
        } else {
            printStream.print("get" + this.iterable + "()");
        }
        printStream.println(") {");
        if (!this.sep.isEmpty()) {
            printStream.println(indentation.get(n++) + "if (!first) {");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.sep.length(); ++i) {
                if (i + 1 < this.sep.length() && this.sep.charAt(i) == '\\' && this.sep.charAt(i + 1) == 'n') {
                    ++i;
                    if (stringBuilder.length() > 0) {
                        printStream.println(indentation.get(n) + "out.print(\"" + stringBuilder.toString() + "\");");
                    }
                    printStream.println(indentation.get(n) + "out.println();");
                    stringBuilder.setLength(0);
                    continue;
                }
                stringBuilder.append(this.sep.charAt(i));
            }
            if (stringBuilder.length() > 0) {
                printStream.println(indentation.get(n) + "out.print(\"" + stringBuilder.toString() + "\");");
            }
            printStream.println(indentation.get(--n) + "}");
            printStream.println(indentation.get(n) + "first = false;");
        }
        printStream.println(indentation.get(n) + "out.print(p);");
        printStream.println(indentation.get(--n) + "}");
        printStream.println(indentation.get(--n) + "}");
    }
}

