/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import org.jastadd.io.LookaheadReader;
import org.jastadd.tinytemplate.Indentation;
import org.jastadd.tinytemplate.Template;
import org.jastadd.tinytemplate.TinyTemplate;
import org.jastadd.tinytemplate.fragment.AttributeReference;
import org.jastadd.tinytemplate.fragment.Concat;
import org.jastadd.tinytemplate.fragment.Conditional;
import org.jastadd.tinytemplate.fragment.EmptyFragment;
import org.jastadd.tinytemplate.fragment.Fragment;
import org.jastadd.tinytemplate.fragment.Include;
import org.jastadd.tinytemplate.fragment.NewlineFragment;
import org.jastadd.tinytemplate.fragment.StringFragment;
import org.jastadd.tinytemplate.fragment.VariableReference;

public class TemplateParser {
    private final TinyTemplate templates;
    private final LookaheadReader in;
    private int line = 1;

    public TemplateParser(TinyTemplate tinyTemplate, InputStream inputStream) {
        this.templates = tinyTemplate;
        this.in = new LookaheadReader(inputStream, 8);
    }

    public void parse() throws SyntaxError {
        try {
            while (this.in.peek(0) != -1) {
                this.parseTemplates();
            }
        }
        catch (IOException iOException) {
            throw new SyntaxError("IO error during template parsing: " + iOException.getMessage());
        }
    }

    private void parseTemplates() throws IOException, SyntaxError {
        LinkedList<String> linkedList = new LinkedList<String>();
        while (true) {
            this.skipWhitespace();
            if (this.isEOF()) {
                if (linkedList.isEmpty()) break;
                throw new SyntaxError(this.line, "missing template body at end of file");
            }
            if (this.isNewline()) {
                this.skipNewline();
                continue;
            }
            if (this.isLineComment()) {
                this.skipLinecomment();
                continue;
            }
            if (this.isAssign()) {
                if (linkedList.isEmpty()) {
                    throw new SyntaxError(this.line, "misplaced '='");
                }
                this.in.pop();
                continue;
            }
            if (this.isTemplateStart()) {
                if (linkedList.isEmpty()) {
                    throw new SyntaxError(this.line, "missing template name");
                }
                Template template = this.parseTemplate();
                for (String string : linkedList) {
                    this.templates.addTemplate(string, template);
                }
                linkedList.clear();
                continue;
            }
            if (this.in.peek(0) == 91 || this.in.peek(0) == 93) {
                throw new SyntaxError(this.line, "found bracket outside template body: '" + (char)this.in.peek(0) + "'");
            }
            linkedList.add(this.nextName());
        }
    }

    private void skipLinecomment() throws IOException {
        this.in.pop();
        while (!this.isNewline() && !this.isEOF()) {
            this.in.pop();
        }
    }

    private void skipWhitespace() throws IOException {
        while (this.isWhitespace()) {
            this.in.pop();
        }
    }

    private void skipIndentation() throws IOException {
        this.in.pop();
        this.in.pop();
    }

    private boolean isTemplateStart() throws IOException, SyntaxError {
        return this.in.peek(0) == 91 && this.in.peek(1) == 91;
    }

    private boolean isIndentation() throws IOException {
        return this.in.peek(0) == 32 && this.in.peek(1) == 32;
    }

    private boolean isTemplateEnd() throws IOException {
        return this.in.peek(0) == 93 && this.in.peek(1) == 93 && this.in.peek(2) != 93;
    }

    private boolean isAssign() throws IOException {
        return this.in.peek(0) == 61;
    }

    private boolean isLineComment() throws IOException {
        return this.in.peek(0) == 35;
    }

    private boolean isWhitespace() throws IOException {
        return Character.isWhitespace(this.in.peek(0)) && !this.isNewline();
    }

    private boolean isNewline() throws IOException {
        return this.isNewline(this.in.peek(0));
    }

    private boolean isNewline(int n) throws IOException {
        return n == 10 || n == 13;
    }

    private boolean isEOF() throws IOException {
        return this.in.peek(0) == -1;
    }

    private void skipNewline() throws IOException {
        if (this.in.peek(0) == 92) {
            this.in.pop();
        }
        if (this.in.peek(0) == 13 && this.in.peek(1) == 10) {
            this.in.pop();
        }
        this.in.pop();
        ++this.line;
    }

    private String nextName() throws IOException, SyntaxError {
        StringBuilder stringBuilder = new StringBuilder();
        while (!(this.isWhitespace() || this.isAssign() || this.isTemplateStart() || this.isEOF())) {
            stringBuilder.append((char)this.in.pop());
        }
        return stringBuilder.toString();
    }

    private Template parseTemplate() throws IOException, SyntaxError {
        Fragment fragment;
        this.in.consume(2);
        Template template = new Template();
        boolean bl = true;
        while (!(fragment = this.nextFragment(template, bl)).isEmpty()) {
            if (fragment.isKeyword("else")) {
                throw new SyntaxError(this.line, "stray $else");
            }
            if (fragment.isKeyword("endif")) {
                throw new SyntaxError(this.line, "stray $endif");
            }
            bl = fragment.isNewline();
            template.addFragment(fragment);
        }
        this.in.consume(2);
        template.trim();
        return template;
    }

    private Fragment nextFragment(Template template, boolean bl) throws IOException, SyntaxError {
        if (this.isEOF()) {
            throw new SyntaxError(this.line, "unexpected end of file while parsing template body");
        }
        if (bl) {
            int n = 0;
            while (this.isIndentation()) {
                this.skipIndentation();
                ++n;
            }
            if (n > 0) {
                return Indentation.getFragment(n);
            }
        }
        if (this.isKeyword("if")) {
            return this.parseIfStmt();
        }
        if (this.isKeyword("include")) {
            Include include = this.parseIncludeStmt();
            template.addIndentation(include);
            return include;
        }
        if (this.isKeyword("cat")) {
            Concat concat = this.parseConcatStmt();
            template.addIndentation(concat);
            return concat;
        }
        if (this.isVariable()) {
            String string = this.nextReference();
            if (string.isEmpty()) {
                throw new SyntaxError(this.line, "empty variable name");
            }
            TemplateParser.acceptVariableName(this.line, string);
            VariableReference variableReference = new VariableReference(string);
            template.addIndentation(variableReference);
            return variableReference;
        }
        if (this.isAttribute()) {
            String string = this.nextReference();
            if (string.isEmpty()) {
                throw new SyntaxError(this.line, "empty attribute name");
            }
            TemplateParser.acceptAttributeName(this.line, string);
            AttributeReference attributeReference = new AttributeReference(string);
            template.addIndentation(attributeReference);
            return attributeReference;
        }
        if (this.isNewline()) {
            this.skipNewline();
            return NewlineFragment.INSTANCE;
        }
        if (this.isTemplateEnd()) {
            return EmptyFragment.INSTANCE;
        }
        return new StringFragment(this.nextString());
    }

    private boolean isKeyword(String string) throws IOException {
        if (this.in.peek(0) != 36 && this.in.peek(0) != 35) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (this.in.peek(i + 1) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private Conditional parseIfStmt() throws IOException, SyntaxError {
        Template template;
        Template template2;
        String string;
        block4: {
            Fragment fragment;
            this.in.consume(3);
            string = this.parseCondition();
            template2 = new Template();
            template = new Template();
            Template template3 = template2;
            boolean bl = true;
            boolean bl2 = false;
            while (!(fragment = this.nextFragment(template3, bl)).isEmpty()) {
                if (fragment.isKeyword("else")) {
                    if (bl2) {
                        throw new SyntaxError(this.line, "too many $else");
                    }
                    bl2 = true;
                    template3 = template;
                    continue;
                }
                if (!fragment.isKeyword("endif")) {
                    bl = fragment.isNewline();
                    template3.addFragment(fragment);
                    continue;
                }
                break block4;
            }
            throw new SyntaxError(this.line, "missing $endif");
        }
        template2.trim();
        template.trim();
        return new Conditional(string, template2, template);
    }

    private Concat parseConcatStmt() throws IOException, SyntaxError {
        this.in.consume(4);
        this.skipWhitespace();
        if (this.in.peek(0) != 40) {
            throw new SyntaxError(this.line, "missing cat parameters");
        }
        this.in.pop();
        char c = this.acceptAlternatives('$', '#');
        String string = c + this.parseSimpleReference().trim();
        this.skipWhitespace();
        String string2 = "";
        if (this.in.peek(0) == 44) {
            this.in.pop();
            this.skipWhitespace();
            string2 = this.parseStringLiteral();
        }
        this.accept(')');
        return new Concat(string, string2);
    }

    private char accept(char c) throws SyntaxError, IOException {
        return this.acceptAlternatives(c);
    }

    private char acceptAlternatives(char ... cArray) throws IOException, SyntaxError {
        for (char c : cArray) {
            if (this.in.peek(0) != c) continue;
            this.in.pop();
            return c;
        }
        throw new SyntaxError(this.line, "wanted: " + Arrays.toString(cArray) + ", got: " + (char)this.in.peek(0));
    }

    private Include parseIncludeStmt() throws IOException, SyntaxError {
        this.in.consume(8);
        this.skipWhitespace();
        if (this.in.peek(0) != 40) {
            throw new SyntaxError(this.line, "missing template name");
        }
        String string = this.parseParenthesizedReference().trim();
        return new Include(string);
    }

    private String parseCondition() throws IOException, SyntaxError {
        this.skipWhitespace();
        if (this.in.peek(0) != 40) {
            throw new SyntaxError(this.line, "missing if condition");
        }
        return this.parseParenthesizedReference().trim();
    }

    private String parseStringLiteral() throws IOException, SyntaxError {
        StringBuilder stringBuilder = new StringBuilder();
        this.accept('\"');
        boolean bl = false;
        while (!this.isStringLiteralEnd(bl)) {
            bl = this.in.peek(0) == 92 && this.in.peek(1) == 34;
            stringBuilder.append((char)this.in.pop());
        }
        this.accept('\"');
        return stringBuilder.toString();
    }

    private boolean isStringLiteralEnd(boolean bl) throws IOException {
        return this.isEOF() || this.in.peek(0) == 34 && !bl;
    }

    private String nextString() throws IOException, SyntaxError {
        StringBuilder stringBuilder = new StringBuilder(512);
        while (!(this.isEOF() || this.isVariable() || this.isAttribute() || this.isNewline() || this.isTemplateEnd())) {
            if (this.in.peek(0) == 35 || this.in.peek(0) == 36) {
                this.in.pop();
            }
            stringBuilder.append((char)this.in.pop());
        }
        return stringBuilder.toString();
    }

    private String nextReference() throws IOException, SyntaxError {
        this.in.pop();
        if (this.in.peek(0) == 40) {
            return this.parseParenthesizedReference();
        }
        return this.parseSimpleReference();
    }

    private String parseSimpleReference() throws IOException, SyntaxError {
        StringBuilder stringBuilder = new StringBuilder(128);
        while (!this.isSimpleReferenceEnd()) {
            stringBuilder.append((char)this.in.pop());
        }
        return stringBuilder.toString();
    }

    private boolean isSimpleReferenceEnd() throws IOException {
        return this.isEOF() || this.in.peek(0) == 36 || !Character.isJavaIdentifierPart(this.in.peek(0));
    }

    private boolean isParenthesizedReferenceEnd() throws IOException {
        return this.isEOF() || this.isNewline() || this.in.peek(0) == 91 || this.in.peek(0) == 93;
    }

    private String parseParenthesizedReference() throws IOException, SyntaxError {
        this.in.pop();
        StringBuilder stringBuilder = new StringBuilder(128);
        int n = 1;
        while (true) {
            if (this.isParenthesizedReferenceEnd()) {
                throw new SyntaxError(this.line, "missing right parenthesis");
            }
            int n2 = this.in.pop();
            if (n2 == 40) {
                ++n;
            } else if (n2 == 41 && --n == 0) break;
            stringBuilder.append((char)n2);
        }
        return stringBuilder.toString();
    }

    private boolean isVariable() throws IOException {
        return this.in.peek(0) == 36 && !this.isEscapable(this.in.peek(1));
    }

    private boolean isAttribute() throws IOException {
        return this.in.peek(0) == 35 && this.in.peek(1) != 35;
    }

    private boolean isEscapable(int n) {
        return n == 36 || n == 93;
    }

    public static void acceptVariableName(int n, String string) throws SyntaxError {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.') continue;
            String string2 = "illegal characters in variable name '" + string + "'";
            if (n == -1) {
                throw new SyntaxError(string2);
            }
            throw new SyntaxError(n, string2);
        }
    }

    public static void acceptAttributeName(int n, String string) throws SyntaxError {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((i != 0 || Character.isJavaIdentifierStart(c)) && Character.isJavaIdentifierPart(c)) continue;
            String string2 = "the attribute name '" + string + "' is not a valid Java identifier";
            if (n == -1) {
                throw new SyntaxError(string2);
            }
            throw new SyntaxError(n, string2);
        }
    }

    public static class SyntaxError
    extends Exception {
        public SyntaxError(int n, String string) {
            super("Syntax error at line " + n + ": " + string);
        }

        public SyntaxError(String string) {
            super(string);
        }
    }
}

