/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jastadd.tinytemplate.DumbContext;
import org.jastadd.tinytemplate.Indentation;
import org.jastadd.tinytemplate.TemplateContext;
import org.jastadd.tinytemplate.fragment.Fragment;
import org.jastadd.tinytemplate.fragment.NestedIndentationFragment;

public class Template {
    private final List<List<Fragment>> lines = new ArrayList<List<Fragment>>();

    public Template() {
        this.lines.add(new ArrayList());
    }

    public void expand(TemplateContext templateContext, PrintStream printStream) {
        StringBuilder stringBuilder = new StringBuilder();
        for (List<Fragment> list : this.lines) {
            this.expandLine(templateContext, list, stringBuilder);
            printStream.print(stringBuilder.toString());
        }
    }

    public void expand(TemplateContext templateContext, PrintWriter printWriter) {
        StringBuilder stringBuilder = new StringBuilder();
        for (List<Fragment> list : this.lines) {
            this.expandLine(templateContext, list, stringBuilder);
            printWriter.print(stringBuilder.toString());
        }
    }

    public void expand(TemplateContext templateContext, StringBuffer stringBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        for (List<Fragment> list : this.lines) {
            this.expandLine(templateContext, list, stringBuilder);
            stringBuffer.append(stringBuilder.toString());
        }
    }

    public void expand(TemplateContext templateContext, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder();
        for (List<Fragment> list : this.lines) {
            this.expandLine(templateContext, list, stringBuilder2);
            stringBuilder.append(stringBuilder2.toString());
        }
    }

    private void expandLine(TemplateContext templateContext, List<Fragment> list, StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        boolean bl = false;
        for (Fragment fragment : list) {
            bl |= fragment.isExpansion();
            fragment.expand(templateContext, stringBuilder);
        }
        if (bl && this.isEmptyLine(stringBuilder)) {
            stringBuilder.setLength(0);
        }
    }

    private boolean isEmptyLine(StringBuilder stringBuilder) {
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (Character.isWhitespace(stringBuilder.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void load(InputStream inputStream) {
    }

    public void addIndentation(NestedIndentationFragment nestedIndentationFragment) {
        List<Fragment> list = this.lines.get(this.lines.size() - 1);
        if (!list.isEmpty() && list.get(0).isIndentation()) {
            nestedIndentationFragment.setIndentation((Indentation.IndentationFragment)list.get(0));
        }
    }

    public void addFragment(Fragment fragment) {
        this.lines.get(this.lines.size() - 1).add(fragment);
        if (fragment.isNewline()) {
            this.lines.add(new ArrayList());
        }
    }

    public void trim() {
        this.trimLeadingEmptyLine();
        this.trimConditionalWhitespace();
    }

    private void trimLeadingEmptyLine() {
        this.trimLineIfEmpty(0);
    }

    public void trimTrailingEmptyLine() {
        this.trimLineIfEmpty(this.lines.size() - 1);
    }

    private void trimLineIfEmpty(int n) {
        int n2;
        Object object = this.lines.get(n).iterator();
        while (object.hasNext()) {
            Fragment fragment = object.next();
            if (fragment.isWhitespace()) continue;
            return;
        }
        this.lines.remove(n);
        if (n > 0 && (n2 = (object = this.lines.get(n - 1)).size() - 1) >= 0 && ((Fragment)object.get(n2)).isNewline()) {
            object.remove(n2);
            if (n2 == 0) {
                this.lines.remove(n - 1);
            }
        }
        if (this.lines.isEmpty()) {
            this.lines.add(new ArrayList());
        }
    }

    private void trimConditionalWhitespace() {
        for (int i = 0; i < this.lines.size(); ++i) {
            boolean bl = true;
            boolean bl2 = false;
            for (Fragment fragment : this.lines.get(i)) {
                if (!fragment.isWhitespace() && !fragment.isConditional() || fragment.isConditional() && bl2) {
                    bl = false;
                    break;
                }
                bl2 |= fragment.isConditional();
            }
            List<Fragment> list = this.trimLine(this.lines.get(i), bl && bl2);
            this.lines.set(i, list);
        }
    }

    private List<Fragment> trimLine(List<Fragment> list, boolean bl) {
        ArrayList<Fragment> arrayList = new ArrayList<Fragment>(this.lines.size());
        for (Fragment fragment : list) {
            if (bl && fragment.isWhitespace() && !fragment.isNewline()) continue;
            arrayList.add(fragment);
        }
        return arrayList;
    }

    public void printITD(Indentation indentation, int n, PrintStream printStream) {
        for (List<Fragment> list : this.lines) {
            for (Fragment fragment : list) {
                fragment.printAspectCode(indentation, n, printStream);
            }
        }
    }

    public boolean isEmpty() {
        return this.lines.size() == 1 && this.lines.get(0).size() == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.expand((TemplateContext)new DumbContext(), stringBuilder);
        return stringBuilder.toString();
    }
}

