/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class LookaheadReader
extends FilterReader {
    private static final int BUFF_SIZE = 1024;
    private final int lookahead;
    private char[] buffer = new char[1024];
    private int pos = 0;
    private int length = 0;

    public LookaheadReader(Reader reader, int n) {
        super(reader);
        this.lookahead = n;
        if (this.lookahead >= 1024) {
            throw new IllegalArgumentException("Too large lookahead");
        }
    }

    public LookaheadReader(InputStream inputStream, int n) {
        this(new InputStreamReader(inputStream), n);
    }

    public void consume(int n) {
        this.pos += n;
    }

    public int peek(int n) throws IOException {
        this.refill();
        if (this.pos + n < this.length) {
            return this.buffer[this.pos + n];
        }
        return -1;
    }

    public int pop() throws IOException {
        this.refill();
        if (this.pos < this.length) {
            return this.buffer[this.pos++];
        }
        return -1;
    }

    private void refill() throws IOException {
        if (this.length - this.pos <= this.lookahead) {
            if (this.length - this.pos > 0) {
                System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.length - this.pos);
                this.length -= this.pos;
                this.pos = 0;
            } else {
                this.length = 0;
                this.pos = 0;
            }
            int n = super.read(this.buffer, this.length, 1024 - this.length);
            this.length += n != -1 ? n : 0;
        }
    }

    @Override
    public int read() throws IOException {
        return this.pop();
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (!this.ready()) {
            return -1;
        }
        n2 += n;
        for (int i = n; i < n2; ++i) {
            int n3 = this.read();
            if (n3 < 0) {
                return i - n;
            }
            cArray[i] = (char)n3;
        }
        return n2 - n;
    }

    @Override
    public boolean ready() throws IOException {
        return this.pos < this.length || super.ready();
    }
}

