/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd;

import java.io.PrintStream;

public class Option {
    public static final String OPTION_PREFIX = "--";
    protected String desc;
    protected String name;
    protected String longName;
    protected String longNameLower;
    protected boolean nonStandard = false;
    protected boolean deprecated = false;
    protected boolean matched = false;
    protected String value;
    protected String defaultValue;
    protected boolean needsValue = false;
    protected boolean hasDefaultValue = false;

    public Option(String string, String string2) {
        this(string, string2, false);
    }

    public Option(String string, String string2, boolean bl) {
        this(string, string2, bl, false);
    }

    public Option(String string, String string2, boolean bl, boolean bl2) {
        this.name = string;
        this.longName = OPTION_PREFIX + string;
        this.longNameLower = this.longName.toLowerCase();
        this.desc = string2;
        this.nonStandard = bl2;
        this.value = "";
        this.needsValue = bl;
    }

    public void setNonStandard() {
        this.nonStandard = true;
    }

    public void setDeprecated() {
        this.deprecated = true;
    }

    public boolean matched() {
        return this.matched;
    }

    public String value() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
        this.value = string;
        this.hasDefaultValue = true;
    }

    public void printHelp(PrintStream printStream) {
        int n = 18;
        printStream.print("  " + this.longName);
        if ((n -= this.longName.length()) < 1) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            printStream.print(' ');
        }
        if (this.hasDefaultValue) {
            printStream.print(this.desc);
            printStream.println(" (default = \"" + this.defaultValue + "\")");
        } else {
            printStream.println(this.desc);
        }
    }

    public int match(String[] stringArray, int n, PrintStream printStream) {
        int n2 = 0;
        boolean bl = false;
        if (stringArray[n].toLowerCase().equals(this.longNameLower)) {
            if (this.needsValue) {
                if (n < stringArray.length - 1 && !stringArray[n + 1].startsWith(OPTION_PREFIX)) {
                    this.value = stringArray[n + 1];
                    n2 = 2;
                } else {
                    printStream.println("Warning: Missing value for option " + this.name);
                    n2 = 1;
                }
            }
            bl = true;
            n2 = 1;
        } else if (this.needsValue && stringArray[n].toLowerCase().startsWith(this.longNameLower + "=")) {
            this.value = stringArray[n].substring(this.longNameLower.length() + 1);
            bl = true;
            n2 = 1;
        }
        if (bl && this.matched) {
            printStream.println("Warning: option " + this.name + " occurs more than once in the argument list!");
        } else if (bl && this.deprecated) {
            printStream.println("Warning: option " + this.name + " has been deprecated! Use of this option is discouraged!");
        }
        this.matched = bl || this.matched;
        return n2;
    }
}

