/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.jastadd.JastAdd;

public class JastAddTask
extends Task {
    private Set<String> files = new LinkedHashSet<String>();
    private boolean jjtree = false;
    private String grammar = null;
    private boolean beaver = false;
    private String packageName = null;
    private String outdir = null;
    private String defaultMap = null;
    private String defaultSet = null;
    private boolean lazyMaps = true;
    private boolean rewrite = false;
    private boolean novisitcheck = false;
    private boolean noCacheCycle = false;
    private boolean noComponentCheck = true;
    private boolean noInhEqCheck = false;
    private boolean suppressWarnings = false;
    private boolean doc = false;
    private String license = null;
    private boolean java14 = false;
    private boolean debug = false;
    private boolean synch = false;
    private boolean noStatic = false;
    private boolean refineLegacy = true;
    private boolean stagedRewrites = false;
    private boolean deterministic = false;
    private boolean tracing = false;
    private boolean cacheAll = false;
    private boolean noCaching = false;
    private boolean cacheNone = false;
    private boolean cacheImplicit = false;
    private boolean ignoreLazy = false;
    private String incremental = "";
    private boolean fullFlush = false;
    private String indent = "";
    private String minListSize = "";

    public void init() {
        super.init();
    }

    public void addConfiguredFileSet(FileSet fileSet) {
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        String string = directoryScanner.getBasedir().getPath();
        for (int i = 0; i < stringArray.length; ++i) {
            this.files.add(string + File.separator + stringArray[i]);
        }
    }

    public void setJjtree(boolean bl) {
        this.jjtree = bl;
    }

    public void setGrammar(String string) {
        this.grammar = string;
    }

    public void setBeaver(boolean bl) {
        this.beaver = bl;
    }

    public void setPackage(String string) {
        this.packageName = string;
    }

    public void setOutdir(String string) {
        this.outdir = string;
    }

    public void setDefaultMap(String string) {
        this.defaultMap = string;
    }

    public void setDefaultSet(String string) {
        this.defaultSet = string;
    }

    public void setLazyMaps(boolean bl) {
        this.lazyMaps = bl;
    }

    public void setRewrite(boolean bl) {
        this.rewrite = bl;
    }

    public void setNovisitcheck(boolean bl) {
        this.novisitcheck = bl;
    }

    public void setVisitCheck(boolean bl) {
        this.novisitcheck = !bl;
    }

    public void setNoCacheCycle(boolean bl) {
        this.noCacheCycle = bl;
    }

    public void setCacheCycle(boolean bl) {
        this.noCacheCycle = !bl;
    }

    public void setNoComponentCheck(boolean bl) {
        this.noComponentCheck = bl;
    }

    public void setComponentCheck(boolean bl) {
        this.noComponentCheck = !bl;
    }

    public void setNoInhEqCheck(boolean bl) {
        this.noInhEqCheck = bl;
    }

    public void setSuppressWarnings(boolean bl) {
        this.suppressWarnings = bl;
    }

    public void setDoc(boolean bl) {
        this.doc = bl;
    }

    public void setDoxygen(boolean bl) {
        this.doc = bl;
    }

    public void setLicense(String string) {
        this.license = string;
    }

    public void setJava14(boolean bl) {
        this.java14 = bl;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setSynch(boolean bl) {
        this.synch = bl;
    }

    public void setNoStatic(boolean bl) {
        this.noStatic = bl;
    }

    public void setRefineLegacy(boolean bl) {
        this.refineLegacy = bl;
    }

    public void setStagedRewrites(boolean bl) {
        this.stagedRewrites = bl;
    }

    public void setDeterministic(boolean bl) {
        this.deterministic = bl;
    }

    public void setTracing(boolean bl) {
        this.tracing = bl;
    }

    public void setCacheAll(boolean bl) {
        if (bl) {
            this.cacheAll = true;
        } else {
            this.noCaching = true;
        }
    }

    public void setCacheNone(boolean bl) {
        this.cacheNone = true;
    }

    public void setCacheImplicit(boolean bl) {
        this.cacheImplicit = true;
    }

    public void setIgnoreLazy(boolean bl) {
        this.ignoreLazy = true;
    }

    public void setIncremental(String string) {
        this.incremental = string;
    }

    public void setFullFlush(boolean bl) {
        this.fullFlush = bl;
    }

    public void setIndent(String string) {
        this.indent = string;
    }

    public void setMinListSize(String string) {
        this.minListSize = string;
    }

    public void execute() throws BuildException {
        Object n2;
        if (this.jjtree && this.grammar == null) {
            throw new BuildException("JJTree option requires grammar to be set");
        }
        if (this.jjtree && this.beaver) {
            throw new BuildException("Can not generate AST for both JJTree and Beaver");
        }
        if (this.files.size() == 0) {
            throw new BuildException("JastAdd requires grammar and aspect files");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.outdir != null) {
            stringBuffer.append(this.outdir);
            if (!this.outdir.endsWith(File.separator)) {
                stringBuffer.append(File.separator);
            }
        }
        if (this.packageName != null) {
            stringBuffer.append(this.packageName.replace('.', File.separatorChar) + File.separator);
        }
        stringBuffer.append("ASTNode.java");
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            boolean bl = false;
            for (String stringArray2 : this.files) {
                n2 = new File(stringArray2);
                if (((File)n2).exists() && ((File)n2).lastModified() <= file.lastModified()) continue;
                bl = true;
            }
            if (!bl) {
                return;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.jjtree) {
            arrayList.add("--jjtree");
            arrayList.add("--grammar=" + this.grammar);
        }
        if (this.beaver) {
            arrayList.add("--beaver");
        }
        if (this.packageName != null) {
            arrayList.add("--package=" + this.packageName);
        }
        if (this.outdir != null) {
            arrayList.add("--o=" + this.outdir);
        }
        if (this.defaultMap != null) {
            arrayList.add("--defaultMap=" + this.defaultMap);
        }
        if (this.defaultSet != null) {
            arrayList.add("--defaultSet=" + this.defaultSet);
        }
        if (this.lazyMaps) {
            arrayList.add("--lazyMaps");
        } else {
            arrayList.add("--noLazyMaps");
        }
        if (this.rewrite) {
            arrayList.add("--rewrite");
        }
        if (this.novisitcheck) {
            arrayList.add("--novisitcheck");
        }
        if (this.noCacheCycle) {
            arrayList.add("--noCacheCycle");
        }
        if (this.noComponentCheck) {
            arrayList.add("--noComponentCheck");
        }
        if (this.noInhEqCheck) {
            arrayList.add("--noInhEqCheck");
        }
        if (this.suppressWarnings) {
            arrayList.add("--suppressWarnings");
        }
        if (this.doc) {
            arrayList.add("--doc");
        }
        if (this.debug) {
            arrayList.add("--debug");
        }
        if (this.license != null) {
            arrayList.add("--license=" + this.license);
        }
        if (this.java14) {
            arrayList.add("--java1.4");
        }
        if (this.synch) {
            arrayList.add("--synch");
        }
        if (this.noStatic) {
            arrayList.add("--noStatic");
        }
        if (this.refineLegacy) {
            arrayList.add("--refineLegacy");
        }
        if (this.stagedRewrites) {
            arrayList.add("--stagedRewrites");
        }
        if (this.deterministic) {
            arrayList.add("--deterministic");
        }
        if (this.tracing) {
            arrayList.add("--tracing");
        }
        if (this.cacheAll) {
            arrayList.add("--cacheAll");
        }
        if (this.noCaching) {
            arrayList.add("--noCaching");
        }
        if (this.cacheNone) {
            arrayList.add("--cacheNone");
        }
        if (this.cacheImplicit) {
            arrayList.add("--cacheImplicit");
        }
        if (this.ignoreLazy) {
            arrayList.add("--ignoreLazy");
        }
        if (!this.incremental.equals("")) {
            arrayList.add("--incremental=" + this.incremental);
        }
        if (this.fullFlush) {
            arrayList.add("--fullFlush");
        }
        if (!this.indent.isEmpty()) {
            arrayList.add("--indent=" + this.indent);
        }
        if (!this.minListSize.isEmpty()) {
            arrayList.add("--minListSize=" + this.minListSize);
        }
        arrayList.addAll(this.files);
        int n = 0;
        String[] stringArray = new String[arrayList.size()];
        n2 = arrayList.iterator();
        while (n2.hasNext()) {
            stringArray[n] = ((String)n2.next()).trim();
            ++n;
        }
        System.err.println("generating node types and weaving aspects");
        int n3 = JastAdd.compile(stringArray, System.out, System.err);
        if (n3 != 0) {
            throw new BuildException("Failed to generate AST");
        }
        System.err.println("done");
    }
}

