/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd;

import ast.AST.Grammar;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jastadd.CommandLineArguments;
import org.jastadd.Option;
import org.jastadd.tinytemplate.TemplateContext;

public class JastAddConfiguration {
    private final CommandLineArguments options;
    private final Option jjtree = new Option("jjtree", "use jjtree base node, this requires --grammar to be set");
    private final Option grammarOption = new Option("grammar", "the name of the grammar's parser, required when using --jjtree", true);
    private final Option defaultMap = new Option("defaultMap", "use this expression to construct maps for attribute caches", true);
    private final Option defaultSet = new Option("defaultSet", "use this expression to construct sets for attribute caches", true);
    private final Option lazyMaps = new Option("lazyMaps", "use lazy maps");
    private final Option noLazyMaps = new Option("noLazyMaps", "don't use lazy maps");
    private final Option privateOption = new Option("private", "");
    private final Option rewrite = new Option("rewrite", "enable ReRAGs support");
    private final Option beaver = new Option("beaver", "use beaver base node");
    private final Option noVisitCheck = new Option("noVisitCheck", "disable circularity check for attributes");
    private final Option noCacheCycle = new Option("noCacheCycle", "disable cache cycle optimization for circular attributes");
    private final Option noComponentCheck = new Option("noComponentCheck", "enable strongly connected component optimization for circular attributes");
    private final Option componentCheck = new Option("componentCheck", "disable strongly connected component optimization for circular attributes");
    private final Option noInhEqCheck = new Option("noInhEqCheck", "disable check for inherited equations");
    private final Option suppressWarnings = new Option("suppressWarnings", "suppress warnings when using Java 5");
    private final Option refineLegacy = new Option("refineLegacy", "enable the legacy refine syntax");
    private final Option noRefineLegacy = new Option("noRefineLegacy", "disable the legacy refine syntax");
    private final Option stagedRewrites = new Option("stagedRewrites", "");
    private final Option doc = new Option("doc", "generate javadoc like .html pages from sources");
    private final Option license = new Option("license", "include the given file in each generated file", true);
    private final Option java1_4 = new Option("java1.4", "generate for Java 1.4");
    private final Option debug = new Option("debug", "generate run-time checks for debugging");
    private final Option synch = new Option("synch", "");
    private final Option noStatic = new Option("noStatic", "the generated state field is non-static");
    private final Option deterministic = new Option("deterministic", "");
    private final Option outputDirOption = new Option("o", "optional base output directory, default is current directory", true);
    private final Option tracing = new Option("tracing", "weaves in code generating a cache tree");
    private final Option cacheAll = new Option("cacheAll", "cache all attributes");
    private final Option noCaching = new Option("noCaching", "");
    private final Option cacheNone = new Option("cacheNone", "cache no attributes, except NTAs");
    private final Option cacheImplicit = new Option("cacheImplicit", "make caching implicit, .caching files have higher priority");
    private final Option ignoreLazy = new Option("ignoreLazy", "ignore the \"lazy\" keyword");
    private final Option packageOption = new Option("package", "optional package for generated files", true);
    private final Option version = new Option("version", "print version string and halts");
    private final Option help = new Option("help", "prints a short help output and halts");
    private final Option printNonStandardOptions = new Option("X", "print list of non-standard options and halt");
    private final Option indent = new Option("indent", "Type of indentation {2space|4space|8space|tab}", true);
    private final Option minListSize = new Option("minListSize", "Minimum (non-empty) list size", true);
    private final Option incremental = new Option("incremental", "turns on incremental evaluation with the given configuration\n    CONFIGURATION: ATTRIBUTE(,ATTRIBUTE)* (comma separated list of attributes)\n    ATTRIBUTE: param  (dependency tracking on parameter level, not combinable\n                       with attr, node, region)\n    ATTRIBUTE: attr  (dependency tracking on attribute level, default, not\n                      combinable with param, node, region)\n    ATTRIBUTE: node  (dependency tracking on node level, not combinable with\n                      param, attr, region)\n    ATTRIBUTE: region (dependency tracking on region level, not combinable\n                       with param, attr, node)\n    ATTRIBUTE: flush (invalidate with flush, default, not combinable with mark)\n    ATTRIBUTE: mark  (invalidate with mark, not combinable with flush, NOT\n                      SUPPORTED YET)\n    ATTRIBUTE: full  (full change propagation, default, not combinable with\n                      limit)\n    ATTRIBUTE: limit (limited change propagation, not combinable with full,\n                      NOT SUPPORTED YET)\n    ATTRIBUTE: debug (generate code for debugging and dumping of dependencies)", true);
    private final Option fullFlush = new Option("fullFlush", "full flush in incremental evaluation");

    public JastAddConfiguration(String[] stringArray, PrintStream printStream) {
        this.defaultMap.setNonStandard();
        this.defaultSet.setNonStandard();
        this.privateOption.setNonStandard();
        this.stagedRewrites.setNonStandard();
        this.synch.setNonStandard();
        this.noStatic.setNonStandard();
        this.noCaching.setNonStandard();
        this.grammarOption.setDefaultValue("Unknown");
        this.defaultMap.setDefaultValue("new java.util.HashMap(4)");
        this.defaultSet.setDefaultValue("new java.util.HashSet(4)");
        this.outputDirOption.setValue(System.getProperty("user.dir"));
        this.packageOption.setDefaultValue("");
        this.indent.setDefaultValue("2space");
        this.minListSize.setDefaultValue("4");
        this.options = new CommandLineArguments();
        this.options.addOption(this.jjtree);
        this.options.addOption(this.grammarOption);
        this.options.addOption(this.defaultMap);
        this.options.addOption(this.defaultSet);
        this.options.addOption(this.lazyMaps);
        this.options.addOption(this.noLazyMaps);
        this.options.addOption(this.privateOption);
        this.options.addOption(this.rewrite);
        this.options.addOption(this.beaver);
        this.options.addOption(this.noVisitCheck);
        this.options.addOption(this.noCacheCycle);
        this.options.addOption(this.noComponentCheck);
        this.options.addOption(this.componentCheck);
        this.options.addOption(this.noInhEqCheck);
        this.options.addOption(this.suppressWarnings);
        this.options.addOption(this.refineLegacy);
        this.options.addOption(this.noRefineLegacy);
        this.options.addOption(this.stagedRewrites);
        this.options.addOption(this.doc);
        this.options.addOption(this.license);
        this.options.addOption(this.java1_4);
        this.options.addOption(this.debug);
        this.options.addOption(this.synch);
        this.options.addOption(this.noStatic);
        this.options.addOption(this.deterministic);
        this.options.addOption(this.outputDirOption);
        this.options.addOption(this.tracing);
        this.options.addOption(this.cacheAll);
        this.options.addOption(this.noCaching);
        this.options.addOption(this.cacheNone);
        this.options.addOption(this.cacheImplicit);
        this.options.addOption(this.ignoreLazy);
        this.options.addOption(this.packageOption);
        this.options.addOption(this.version);
        this.options.addOption(this.help);
        this.options.addOption(this.printNonStandardOptions);
        this.options.addOption(this.indent);
        this.options.addOption(this.incremental);
        this.options.addOption(this.fullFlush);
        this.options.match(stringArray, printStream);
    }

    public File getOutputDir() {
        return new File(this.outputDirOption.value());
    }

    public boolean getPublicModifier() {
        return !this.privateOption.matched();
    }

    public Grammar buildRoot() {
        String string;
        Grammar grammar = new Grammar();
        grammar.jjtree = this.jjtree.matched();
        grammar.parserName = this.grammarOption.value();
        grammar.createDefaultMap = this.defaultMap.value();
        grammar.createDefaultSet = this.defaultSet.value();
        if (this.indent.value().equals("2space")) {
            grammar.ind = "  ";
        } else if (this.indent.value().equals("4space")) {
            grammar.ind = "    ";
        } else if (this.indent.value().equals("8space")) {
            grammar.ind = "        ";
        } else if (this.indent.value().equals("tab")) {
            grammar.ind = "\t";
        }
        try {
            grammar.minListSize = Integer.parseInt(this.minListSize.value());
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Warning: failed to parse minimum list size option!");
        }
        grammar.lazyMaps = !this.noLazyMaps.matched();
        grammar.rewriteEnabled = this.rewrite.matched();
        grammar.beaver = this.beaver.matched();
        grammar.visitCheckEnabled = !this.noVisitCheck.matched();
        grammar.cacheCycle = !this.noCacheCycle.matched();
        grammar.componentCheck = this.componentCheck.matched();
        grammar.noInhEqCheck = this.noInhEqCheck.matched();
        grammar.suppressWarnings = this.suppressWarnings.matched();
        grammar.refineLegacy = !this.noRefineLegacy.matched();
        grammar.stagedRewrites = this.stagedRewrites.matched();
        grammar.doc = this.doc.matched();
        grammar.license = "";
        if (this.license.matched()) {
            string = this.license.value();
            try {
                if (string != null) {
                    grammar.license = this.readFile(string);
                }
            }
            catch (IOException iOException) {
                System.err.println("Error loading license file " + string);
                System.exit(1);
            }
        }
        boolean bl = grammar.java5 = !this.java1_4.matched();
        if (this.debug.matched()) {
            grammar.debugMode = true;
            grammar.cycleLimit = 100;
            grammar.rewriteLimit = 100;
            grammar.visitCheckEnabled = true;
        }
        grammar.block = this.synch.matched();
        grammar.noStatic = this.noStatic.matched();
        grammar.deterministic = this.deterministic.matched();
        if (grammar.deterministic) {
            grammar.createDefaultMap = "new java.util.LinkedHashMap(4)";
            grammar.createDefaultSet = "new java.util.LinkedHashSet(4)";
        }
        grammar.tracing = this.tracing.matched();
        grammar.cacheAll = this.cacheAll.matched();
        grammar.noCaching = this.noCaching.matched();
        grammar.cacheNone = this.cacheNone.matched();
        grammar.cacheImplicit = this.cacheImplicit.matched();
        grammar.ignoreLazy = this.ignoreLazy.matched();
        grammar.incremental = this.incremental.matched();
        string = this.incremental.matched() ? this.incremental.value() : "";
        Map<String, String> map = this.parseIncrementalConfig(string);
        grammar.incrementalLevelParam = map.containsKey("param");
        grammar.incrementalLevelAttr = map.containsKey("attr");
        grammar.incrementalLevelNode = map.containsKey("node");
        grammar.incrementalLevelRegion = map.containsKey("region");
        grammar.incrementalChangeFlush = map.containsKey("flush");
        grammar.incrementalChangeMark = map.containsKey("mark");
        grammar.incrementalPropFull = map.containsKey("full");
        grammar.incrementalPropLimit = map.containsKey("limit");
        grammar.incrementalDebug = map.containsKey("debug");
        grammar.incrementalTrack = map.containsKey("track");
        grammar.fullFlush = this.fullFlush.matched();
        TemplateContext templateContext = grammar.templateContext();
        if (this.synch.matched()) {
            templateContext.bindExpansion("SynchBegin", "synchronized-block.begin");
            templateContext.bindExpansion("SynchEnd", "synchronized-block.end");
        } else {
            templateContext.bind("SynchBegin", "");
            templateContext.bind("SynchEnd", "");
        }
        templateContext.bind("NoStatic", grammar.noStatic);
        templateContext.bind("DebugMode", grammar.debugMode);
        templateContext.bind("MinListSize", "" + grammar.minListSize);
        templateContext.bind("Deterministic", grammar.deterministic);
        templateContext.bind("LazyMaps", grammar.lazyMaps);
        templateContext.bind("CircularEnabled", grammar.circularEnabled);
        templateContext.bind("ComponentCheck", grammar.componentCheck);
        templateContext.bind("CacheCycle", grammar.cacheCycle);
        templateContext.bind("Java5", grammar.java5);
        templateContext.bind("Beaver", grammar.beaver);
        templateContext.bind("VisitCheckEnabled", grammar.visitCheckEnabled);
        templateContext.bind("TraceVisitCheck", grammar.traceVisitCheck);
        templateContext.bind("RewriteLimit", "" + grammar.rewriteLimit);
        templateContext.bind("HasRewriteLimit", grammar.rewriteLimit > 0);
        templateContext.bind("StagedRewrites", grammar.stagedRewrites);
        templateContext.bind("RewriteEnabled", grammar.rewriteEnabled);
        templateContext.bind("CreateDefaultMap", grammar.createDefaultMap);
        templateContext.bind("DefaultMapType", grammar.typeDefaultMap);
        templateContext.bind("CreateDefaultSet", grammar.createDefaultSet);
        templateContext.bind("DefaultSetType", grammar.typeDefaultSet);
        templateContext.bind("CreateContributorSet", grammar.createContributorSet);
        templateContext.bind("JJTree", grammar.jjtree);
        templateContext.bind("ParserName", grammar.parserName);
        templateContext.bind("FullFlush", grammar.fullFlush);
        templateContext.bind("IncrementalEnabled", grammar.incremental);
        templateContext.bind("IncrementalLevelParam", grammar.incrementalLevelParam);
        templateContext.bind("IncrementalLevelAttr", grammar.incrementalLevelAttr);
        templateContext.bind("IncrementalLevelNode", grammar.incrementalLevelNode);
        templateContext.bind("IncrementalLevelRegion", grammar.incrementalLevelRegion);
        templateContext.bind("IncrementalChangeFlush", grammar.incrementalChangeFlush);
        templateContext.bind("IncrementalChangeMark", grammar.incrementalChangeMark);
        templateContext.bind("IncrementalPropFull", grammar.incrementalPropFull);
        templateContext.bind("IncrementalPropLimit", grammar.incrementalPropLimit);
        templateContext.bind("IncrementalDebug", grammar.incrementalDebug);
        templateContext.bind("IncrementalTrack", grammar.incrementalTrack);
        templateContext.bind("DDGNodeName", "ASTNode$DepGraphNode");
        return grammar;
    }

    public boolean checkProblems() {
        if (this.jjtree.matched() && !this.grammarOption.matched()) {
            System.err.println("Missing grammar option. It is required in jjtree-mode!");
            return true;
        }
        for (int i = 0; i < this.options.getNumOperands(); ++i) {
            String string = this.options.getOperand(i);
            if (string.endsWith(".ast") || string.endsWith(".jrag") || string.endsWith(".jadd") || string.endsWith(".caching")) continue;
            System.err.println("Unrecognized file extension: " + string);
            return true;
        }
        File file = this.getOutputDir();
        if (!file.exists()) {
            System.err.println("Output directory " + file.getAbsolutePath() + " does not exist");
            return true;
        }
        if (!file.isDirectory()) {
            System.err.println("Output directory " + file.getAbsolutePath() + " is not a directory");
            return true;
        }
        if (!file.canWrite()) {
            System.err.println("Output directory " + file.getAbsolutePath() + " is write protected");
            return true;
        }
        return !this.checkIncrementalConfig();
    }

    private Map<String, String> parseIncrementalConfig(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            hashMap.put(stringTokenizer.nextToken().trim(), "");
        }
        return hashMap;
    }

    private boolean checkIncrementalConfig() {
        String string = this.incremental.matched() ? this.incremental.value() : "";
        Map<String, String> map = this.parseIncrementalConfig(string);
        boolean bl = map.containsKey("param");
        boolean bl2 = map.containsKey("attr");
        boolean bl3 = map.containsKey("node");
        boolean bl4 = map.containsKey("region");
        boolean bl5 = map.containsKey("flush");
        boolean bl6 = map.containsKey("mark");
        boolean bl7 = map.containsKey("full");
        boolean bl8 = map.containsKey("limit");
        if (bl2 && bl3 || bl2 && bl || bl3 && bl || bl && bl4 || bl2 && bl4 || bl3 && bl4) {
            System.err.println("error: Conflict in incremental evaluation configuration. Cannot combine \"param\", \"attr\", \"node\" and \"region\".");
            return false;
        }
        if (!(bl2 || bl3 || bl || bl4)) {
            bl2 = true;
        }
        if (bl5 && bl6) {
            System.err.println("error: Conflict in incremental evaluation configuration. Cannot combine \"flush\" and \"mark\".");
            return false;
        }
        if (!bl5 && !bl6) {
            bl5 = true;
        }
        if (bl6) {
            System.err.println("error: Unsupported incremental evaluation configuration: \"mark\".");
            return false;
        }
        if (bl7 && bl8) {
            System.err.println("error: Conflict in incremental evaluation configuration. Cannot combine \"full\" and \"limit\".");
            return false;
        }
        if (!bl7 && !bl8) {
            bl7 = true;
        }
        return true;
    }

    private String readFile(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = bufferedReader.read(cArray)) != -1) {
            stringBuffer.append(String.valueOf(cArray, 0, n));
        }
        ((Reader)bufferedReader).close();
        return stringBuffer.toString();
    }

    public Collection<String> getFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.options.getNumOperands(); ++i) {
            String string = this.options.getOperand(i);
            if (!string.endsWith(".ast") && !string.endsWith(".jrag") && !string.endsWith(".jadd")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Collection<String> getCacheFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.options.getNumOperands(); ++i) {
            String string = this.options.getOperand(i);
            if (!string.endsWith(".caching")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public String getTargetPackage() {
        return this.packageOption.value().replace('/', '.');
    }

    public void printHelp(PrintStream printStream) {
        printStream.println("This program reads a number of .jrag, .jadd, and .ast files");
        printStream.println("and creates the nodes in the abstract syntax tree");
        printStream.println();
        printStream.println("The .jrag source files may contain declarations of synthesized ");
        printStream.println("and inherited attributes and their corresponding equations.");
        printStream.println("It may also contain ordinary Java methods and fields.");
        printStream.println();
        printStream.println("Source file syntax can be found at http://jastadd.org");
        printStream.println();
        printStream.println("Options:");
        this.options.printHelp(printStream);
        printStream.println();
        printStream.println("Arguments:");
        printStream.println("Names of .ast, .jrag, .jadd and .caching source files");
        printStream.println();
        printStream.println("Example: The following command reads and translates files NameAnalysis.jrag");
        printStream.println("and TypeAnalysis.jrag, weaves PrettyPrint.jadd into the abstract syntax tree");
        printStream.println("defined in the grammar Toy.ast.");
        printStream.println("The result is the generated classes for the nodes in the AST that are placed");
        printStream.println("in the package ast.");
        printStream.println();
        printStream.println("java -jar jastadd2.jar --package=ast Toy.ast NameAnalysis.jrag TypeAnalysis.jrag PrettyPrinter.jadd");
    }

    public void printNonStandardOptions(PrintStream printStream) {
        printStream.println("Non-standard options:");
        this.options.printNonStandardOptions(printStream);
    }

    public boolean shouldPrintVersion() {
        return this.version.matched();
    }

    public boolean shouldPrintHelp() {
        return this.help.matched() || this.getFiles().isEmpty();
    }

    public boolean shouldPrintNonStandardOptions() {
        return this.printNonStandardOptions.matched();
    }
}

