/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd;

import ast.AST.ASTDecl;
import ast.AST.Ast;
import ast.AST.Components;
import ast.AST.Grammar;
import ast.AST.ParseException;
import ast.AST.TokenComponent;
import ast.AST.TokenMgrError;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jrag.AST.ASTCompilationUnit;
import jrag.AST.JragParser;
import org.jastadd.JastAddConfiguration;
import org.jastadd.Problem;

public class JastAdd {
    private static ResourceBundle resources = null;
    private static String RESOURCE_NAME = "JastAdd";
    private final JastAddConfiguration config;

    private static String getString(String string) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle(RESOURCE_NAME);
            }
            catch (MissingResourceException missingResourceException) {
                throw new Error("Could not open the resource " + RESOURCE_NAME);
            }
        }
        return resources.getString(string);
    }

    public static String getVersionString() {
        return "JastAdd2 " + JastAdd.getString("version");
    }

    public static String getLongVersionString() {
        return "JastAdd2 (http://jastadd.org) version " + JastAdd.getString("version");
    }

    public JastAdd(JastAddConfiguration jastAddConfiguration) {
        this.config = jastAddConfiguration;
    }

    public static void main(String[] stringArray) {
        int n = JastAdd.compile(stringArray, System.out, System.err);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int compile(String[] stringArray, PrintStream printStream, PrintStream printStream2) {
        JastAdd jastAdd = new JastAdd(new JastAddConfiguration(stringArray, printStream2));
        return jastAdd.compile(printStream, printStream2);
    }

    public int compile(PrintStream printStream, PrintStream printStream2) {
        if (this.config.checkProblems()) {
            return 1;
        }
        if (this.config.shouldPrintVersion()) {
            printStream.println(JastAdd.getVersionString());
            printStream.println("Copyright (c) 2005-2013, The JastAdd Team. All rights reserved.");
            printStream.println("This software is covered by the modified BSD license.");
            return 0;
        }
        if (this.config.shouldPrintHelp()) {
            printStream.println(JastAdd.getVersionString());
            printStream.println();
            this.config.printHelp(printStream);
            return 0;
        }
        if (this.config.shouldPrintNonStandardOptions()) {
            this.config.printNonStandardOptions(printStream);
            return 0;
        }
        try {
            long l = System.currentTimeMillis();
            Grammar grammar = this.config.buildRoot();
            grammar.genDefaultNodeTypes();
            Collection<Problem> collection = this.parseAstGrammars(grammar);
            if (this.checkErrors(collection, printStream2)) {
                return 1;
            }
            long l2 = System.currentTimeMillis() - l;
            collection = grammar.problems();
            long l3 = System.currentTimeMillis() - l - l2;
            if (this.checkErrors(collection, printStream2)) {
                return 1;
            }
            grammar.problems.clear();
            this.genASTNode$State(grammar);
            this.genIncrementalDDGNode(grammar);
            collection = this.parseJragFiles(grammar);
            if (this.checkErrors(collection, printStream2)) {
                return 1;
            }
            long l4 = System.currentTimeMillis() - l - l3;
            grammar.processInterfaceRefinements();
            grammar.weaveInterfaceIntroductions();
            this.weaveAspects(grammar);
            grammar.processRefinements();
            collection = this.readCacheFiles(grammar);
            if (this.checkErrors(collection, printStream2)) {
                return 1;
            }
            grammar.weaveCollectionAttributes();
            collection = grammar.attributeProblems();
            collection.addAll(grammar.weavingProblems());
            if (this.checkErrors(collection, printStream2)) {
                return 1;
            }
            grammar.removeDuplicateInhDecls();
            long l5 = System.currentTimeMillis() - l - l4;
            grammar.jastAddGen(this.config.getOutputDir(), grammar.parserName, this.config.getTargetPackage(), this.config.getPublicModifier());
            long l6 = System.currentTimeMillis() - l - l5;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw nullPointerException;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            throw arrayIndexOutOfBoundsException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
        return 0;
    }

    private boolean checkErrors(Collection<Problem> collection, PrintStream printStream) {
        boolean bl = false;
        for (Problem problem : collection) {
            problem.print(printStream);
            bl |= problem.isError();
        }
        return bl;
    }

    private Collection<Problem> readCacheFiles(Grammar grammar) {
        LinkedList<Problem> linkedList = new LinkedList<Problem>();
        for (String string : this.config.getCacheFiles()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                JragParser jragParser = new JragParser(fileInputStream);
                jragParser.inputStream = fileInputStream;
                jragParser.root = grammar;
                jragParser.setFileName(string);
                jragParser.CacheDeclarations();
            }
            catch (jrag.AST.ParseException parseException) {
                linkedList.add(new Problem.Error("syntax error", string, parseException.currentToken.next.beginLine, parseException.currentToken.next.beginColumn));
            }
            catch (FileNotFoundException fileNotFoundException) {
                linkedList.add(new Problem.Error("could not find cache file '" + string + "'"));
            }
        }
        return linkedList;
    }

    private void weaveAspects(Grammar grammar) {
        for (int i = 0; i < grammar.getNumTypeDecl(); ++i) {
            if (!(grammar.getTypeDecl(i) instanceof ASTDecl)) continue;
            ASTDecl aSTDecl = (ASTDecl)grammar.getTypeDecl(i);
            StringWriter stringWriter = new StringWriter();
            aSTDecl.emitImplicitDeclarations(new PrintWriter(stringWriter));
            JragParser jragParser = new JragParser(new StringReader(stringWriter.toString()));
            jragParser.root = grammar;
            jragParser.setFileName("");
            jragParser.className = "ASTNode";
            jragParser.pushTopLevelOrAspect(true);
            try {
                while (true) {
                    jragParser.AspectBodyDeclaration();
                }
            }
            catch (Exception exception) {
                jragParser.popTopLevelOrAspect();
                int n = 0;
                Iterator iterator = aSTDecl.getComponents();
                while (iterator.hasNext()) {
                    Components components = (Components)iterator.next();
                    if (components instanceof TokenComponent) {
                        components.jaddGen(n, this.config.getPublicModifier(), aSTDecl);
                        continue;
                    }
                    components.jaddGen(n, this.config.getPublicModifier(), aSTDecl);
                    ++n;
                }
            }
        }
    }

    private Collection<Problem> parseJragFiles(Grammar grammar) {
        LinkedList<Problem> linkedList = new LinkedList<Problem>();
        for (String string : this.config.getFiles()) {
            if (!string.endsWith(".jrag") && !string.endsWith(".jadd")) continue;
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                JragParser jragParser = new JragParser(fileInputStream);
                jragParser.inputStream = fileInputStream;
                jragParser.root = grammar;
                jragParser.setFileName(string);
                ASTCompilationUnit aSTCompilationUnit = jragParser.CompilationUnit();
                grammar.addCompUnit(aSTCompilationUnit);
            }
            catch (jrag.AST.ParseException parseException) {
                linkedList.add(new Problem.Error("syntax error", string, parseException.currentToken.next.beginLine, parseException.currentToken.next.beginColumn));
            }
            catch (FileNotFoundException fileNotFoundException) {
                linkedList.add(new Problem.Error("could not find aspect file '" + string + "'"));
            }
            catch (Throwable throwable) {
                linkedList.add(new Problem.Error("exception occurred while parsing", string));
            }
        }
        return linkedList;
    }

    private void genIncrementalDDGNode(Grammar grammar) {
        if (grammar.incremental) {
            StringWriter stringWriter = new StringWriter();
            grammar.genIncrementalDDGNode(new PrintWriter(stringWriter));
            JragParser jragParser = new JragParser(new StringReader(stringWriter.toString()));
            jragParser.root = grammar;
            jragParser.setFileName("ASTNode");
            jragParser.className = "ASTNode";
            jragParser.pushTopLevelOrAspect(true);
            try {
                while (true) {
                    jragParser.AspectBodyDeclaration();
                }
            }
            catch (Exception exception) {
                jragParser.popTopLevelOrAspect();
            }
        }
    }

    private void genASTNode$State(Grammar grammar) {
        StringWriter stringWriter = new StringWriter();
        grammar.emitASTNode$State(new PrintWriter(stringWriter));
        JragParser jragParser = new JragParser(new StringReader(stringWriter.toString()));
        jragParser.root = grammar;
        jragParser.setFileName("ASTNode");
        jragParser.className = "ASTNode";
        jragParser.pushTopLevelOrAspect(true);
        try {
            while (true) {
                jragParser.AspectBodyDeclaration();
            }
        }
        catch (Exception exception) {
            jragParser.popTopLevelOrAspect();
            return;
        }
    }

    private Collection<Problem> parseAstGrammars(Grammar grammar) {
        LinkedList<Problem> linkedList = new LinkedList<Problem>();
        for (String string : this.config.getFiles()) {
            if (!string.endsWith(".ast")) continue;
            try {
                int n;
                Ast ast = new Ast(new FileInputStream(string));
                ast.fileName = string;
                Grammar grammar2 = ast.Grammar();
                for (n = 0; n < grammar2.getNumTypeDecl(); ++n) {
                    grammar.addTypeDecl(grammar2.getTypeDecl(n));
                }
                for (n = 0; n < grammar2.getNumRegionDecl(); ++n) {
                    grammar.addRegionDecl(grammar2.getRegionDecl(n));
                }
                linkedList.addAll(ast.parseProblems());
            }
            catch (TokenMgrError tokenMgrError) {
                linkedList.add(new Problem.Error(tokenMgrError.getMessage(), string));
            }
            catch (ParseException parseException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
                linkedList.add(new Problem.Error("could not find abstract syntax file '" + string + "'"));
            }
        }
        return linkedList;
    }

    private void checkMem(PrintStream printStream) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        long l3 = l - l2;
        printStream.println("Before GC: Total " + l + ", use " + l3);
        runtime.gc();
        l = runtime.totalMemory();
        l2 = runtime.freeMemory();
        l3 = l - l2;
        printStream.println("After GC: Total " + l + ", use " + l3);
    }
}

