/*
 * Decompiled with CFR 0.152.
 */
package jrag.AST;

import java.lang.reflect.Constructor;
import jrag.AST.JragParser;
import jrag.AST.JragParserTreeConstants;
import jrag.AST.JragParserVisitor;
import jrag.AST.Node;
import jrag.AST.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JragParser parser;
    public Token firstToken;
    public Token lastToken;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(JragParser jragParser, int n) {
        this(n);
        this.parser = jragParser;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public Object jjtAccept(JragParserVisitor jragParserVisitor, Object object) {
        return jragParserVisitor.visit(this, object);
    }

    public Object childrenAccept(JragParserVisitor jragParserVisitor, Object object) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(jragParserVisitor, object);
            }
        }
        return object;
    }

    public String toString() {
        return JragParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public SimpleNode copy() {
        try {
            Constructor<?> constructor = this.getClass().getDeclaredConstructor(Integer.TYPE);
            SimpleNode simpleNode = (SimpleNode)constructor.newInstance(new Integer(this.id));
            if (this.children != null) {
                simpleNode.children = (Node[])this.children.clone();
            }
            return simpleNode;
        }
        catch (Exception exception) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public SimpleNode fullCopy() {
        SimpleNode simpleNode = this.copy();
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode2 = (SimpleNode)this.jjtGetChild(i);
            if (simpleNode2 != null) {
                simpleNode2 = simpleNode2.fullCopy();
            }
            simpleNode2.jjtSetParent(simpleNode);
            simpleNode.jjtAddChild(simpleNode2, i);
        }
        return simpleNode;
    }
}

