/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.ASTNode$State;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.Components;
import ast.AST.Node;
import ast.AST.TokenId;
import java.io.PrintStream;
import org.jastadd.tinytemplate.TemplateContext;

public class TokenComponent
extends Components
implements Cloneable {
    private boolean called = false;
    protected int name_visited = -1;
    protected int type_visited = -1;
    protected int constrParmType_visited = -1;
    protected int annotations_visited = -1;

    @Override
    public TokenComponent clone() throws CloneNotSupportedException {
        TokenComponent tokenComponent = (TokenComponent)super.clone();
        tokenComponent.name_visited = -1;
        tokenComponent.type_visited = -1;
        tokenComponent.constrParmType_visited = -1;
        tokenComponent.annotations_visited = -1;
        tokenComponent.in$Circle(false);
        tokenComponent.is$Final(false);
        return tokenComponent;
    }

    public TokenComponent copy() {
        try {
            TokenComponent tokenComponent = this.clone();
            tokenComponent.parent = null;
            if (this.children != null) {
                tokenComponent.children = (ASTNode[])this.children.clone();
            }
            return tokenComponent;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public TokenComponent fullCopy() {
        TokenComponent tokenComponent = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode aSTNode = (ASTNode)this.children[i];
                if (aSTNode == null) continue;
                aSTNode = aSTNode.fullCopy();
                tokenComponent.setChild(aSTNode, i);
            }
        }
        return tokenComponent;
    }

    @Override
    public boolean declared() {
        return true;
    }

    @Override
    public void jaddGen(int n, boolean bl, ASTDecl aSTDecl) {
        TemplateContext templateContext = this.templateContext();
        templateContext.bind("Id", this.getTokenId().getID());
        templateContext.bind("Type", this.getTokenId().getTYPE());
        templateContext.bind("TypeInSignature", ASTNode.convTypeNameToSignature(this.getTokenId().getTYPE()));
        templateContext.bind("Host", aSTDecl.name());
        templateContext.bind("Modifier", bl ? "public" : "private");
        boolean bl2 = this.getTokenId().getTYPE().equals("String") || this.getTokenId().getTYPE().equals("java.lang.String");
        boolean bl3 = aSTDecl.redefinesTokenComponent(this);
        templateContext.bind("IsStringToken", bl2);
        templateContext.bind("IsRedefined", bl3);
        this.parse(templateContext.expand("TokenComponent"));
    }

    @Override
    public String componentString() {
        return "&lt;" + this.getTokenId().componentString() + "&gt;";
    }

    public boolean isPrimitive() {
        String string = this.getTokenId().getTYPE();
        return string.equals("int") || string.equals("short") || string.equals("long") || string.equals("float") || string.equals("double") || string.equals("boolean") || string.equals("char") || string.equals("byte");
    }

    public TokenComponent(int n) {
        super(n);
    }

    public TokenComponent(Ast ast, int n) {
        this(n);
        this.parser = ast;
    }

    public TokenComponent() {
        this(0);
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
    }

    public TokenComponent(TokenId tokenId) {
        this.setChild(tokenId, 0);
    }

    @Override
    public void dumpTree(String string, PrintStream printStream) {
        printStream.print(string + "TokenComponent");
        String string2 = string + "  ";
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).dumpTree(string2, printStream);
        }
    }

    @Override
    public Object jjtAccept(AstVisitor astVisitor, Object object) {
        return astVisitor.visit(this, object);
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        this.checkChild(node, n);
        super.jjtAddChild(node, n);
    }

    @Override
    public void checkChild(Node node, int n) {
        if (n == 0 && !(node instanceof TokenId)) {
            throw new Error("Child number 0 of TokenComponent has the type " + node.getClass().getName() + " which is not an instance of TokenId");
        }
    }

    @Override
    public int getNumChild() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushCache() {
        super.flushCache();
        this.name_visited = -1;
        this.type_visited = -1;
        this.constrParmType_visited = -1;
        this.annotations_visited = -1;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    public void setTokenId(TokenId tokenId) {
        this.setChild(tokenId, 0);
    }

    public TokenId getTokenId() {
        return (TokenId)this.getChild(0);
    }

    public TokenId getTokenIdNoTransform() {
        return (TokenId)this.getChildNoTransform(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String name() {
        ASTNode$State aSTNode$State = this.state();
        if (this.name_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: name in class: ast.AST.SynDecl");
        }
        this.name_visited = this.state().boundariesCrossed;
        try {
            String string = this.getTokenId().name();
            return string;
        }
        finally {
            this.name_visited = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String type() {
        ASTNode$State aSTNode$State = this.state();
        if (this.type_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: type in class: ast.AST.SynDecl");
        }
        this.type_visited = this.state().boundariesCrossed;
        try {
            String string = this.getTokenId().type();
            return string;
        }
        finally {
            this.type_visited = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String constrParmType() {
        ASTNode$State aSTNode$State = this.state();
        if (this.constrParmType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: constrParmType in class: ast.AST.SynDecl");
        }
        this.constrParmType_visited = this.state().boundariesCrossed;
        try {
            String string = this.getTokenId().getTYPE();
            return string;
        }
        finally {
            this.constrParmType_visited = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String annotations() {
        ASTNode$State aSTNode$State = this.state();
        if (this.annotations_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: annotations in class: ast.AST.SynDecl");
        }
        this.annotations_visited = this.state().boundariesCrossed;
        try {
            String string = this.suppressWarnings();
            return string;
        }
        finally {
            this.annotations_visited = -1;
        }
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

