/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTNode;
import ast.AST.ASTNode$State;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.IdUse;
import ast.AST.NameNode;
import ast.AST.Node;
import ast.AST.Opt;
import java.io.PrintStream;

public class Id
extends ASTNode<ASTNode>
implements Cloneable {
    protected int name_visited = -1;
    protected int type_visited = -1;

    @Override
    public Id clone() throws CloneNotSupportedException {
        Id id = (Id)super.clone();
        id.name_visited = -1;
        id.type_visited = -1;
        id.in$Circle(false);
        id.is$Final(false);
        return id;
    }

    public Id copy() {
        try {
            Id id = this.clone();
            id.parent = null;
            if (this.children != null) {
                id.children = (ASTNode[])this.children.clone();
            }
            return id;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public Id fullCopy() {
        Id id = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode aSTNode = (ASTNode)this.children[i];
                if (aSTNode == null) continue;
                aSTNode = aSTNode.fullCopy();
                id.setChild(aSTNode, i);
            }
        }
        return id;
    }

    public String componentString() {
        String string = "{@link " + this.getIdUse().getID() + "}";
        if (this.hasNameNode()) {
            return this.getNameNode().getID() + ":" + string;
        }
        return string;
    }

    public Id(int n) {
        super(n);
    }

    public Id(Ast ast, int n) {
        this(n);
        this.parser = ast;
    }

    public Id() {
        this(0);
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
        this.setChild(new Opt(), 0);
    }

    public Id(Opt<NameNode> opt, IdUse idUse) {
        this.setChild(opt, 0);
        this.setChild(idUse, 1);
    }

    @Override
    public void dumpTree(String string, PrintStream printStream) {
        printStream.print(string + "Id");
        String string2 = string + "  ";
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).dumpTree(string2, printStream);
        }
    }

    @Override
    public Object jjtAccept(AstVisitor astVisitor, Object object) {
        return astVisitor.visit(this, object);
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        this.checkChild(node, n);
        super.jjtAddChild(node, n);
    }

    @Override
    public void checkChild(Node node, int n) {
        if (n == 0) {
            if (!(node instanceof Opt)) {
                throw new Error("Child number 0 of Id has the type " + node.getClass().getName() + " which is not an instance of Opt");
            }
            if (((Opt)node).getNumChildNoTransform() != 0 && !(((Opt)node).getChildNoTransform(0) instanceof NameNode)) {
                throw new Error("Optional name() has the type " + ((Opt)node).getChildNoTransform(0).getClass().getName() + " which is not an instance of NameNode");
            }
        }
        if (n == 1 && !(node instanceof IdUse)) {
            throw new Error("Child number 1 of Id has the type " + node.getClass().getName() + " which is not an instance of IdUse");
        }
    }

    @Override
    public int getNumChild() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushCache() {
        super.flushCache();
        this.name_visited = -1;
        this.type_visited = -1;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    public void setNameNodeOpt(Opt<NameNode> opt) {
        this.setChild(opt, 0);
    }

    public void setNameNode(NameNode nameNode) {
        this.getNameNodeOpt().setChild(nameNode, 0);
    }

    public boolean hasNameNode() {
        return this.getNameNodeOpt().getNumChild() != 0;
    }

    public NameNode getNameNode() {
        return (NameNode)this.getNameNodeOpt().getChild(0);
    }

    public Opt<NameNode> getNameNodeOpt() {
        return (Opt)this.getChild(0);
    }

    public Opt<NameNode> getNameNodeOptNoTransform() {
        return (Opt)this.getChildNoTransform(0);
    }

    public void setIdUse(IdUse idUse) {
        this.setChild(idUse, 1);
    }

    public IdUse getIdUse() {
        return (IdUse)this.getChild(1);
    }

    public IdUse getIdUseNoTransform() {
        return (IdUse)this.getChildNoTransform(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String name() {
        ASTNode$State aSTNode$State = this.state();
        if (this.name_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: name in class: ast.AST.SynDecl");
        }
        this.name_visited = this.state().boundariesCrossed;
        try {
            String string = this.hasNameNode() ? this.getNameNode().name() : this.getIdUse().name();
            return string;
        }
        finally {
            this.name_visited = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String type() {
        ASTNode$State aSTNode$State = this.state();
        if (this.type_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: type in class: ast.AST.SynDecl");
        }
        this.type_visited = this.state().boundariesCrossed;
        try {
            String string = this.getIdUse().name();
            return string;
        }
        finally {
            this.type_visited = -1;
        }
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

