/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate.fragment;

import org.jastadd.tinytemplate.Template;
import org.jastadd.tinytemplate.TemplateContext;
import org.jastadd.tinytemplate.TemplateParser;
import org.jastadd.tinytemplate.fragment.AbstractFragment;

public class IfStmt
extends AbstractFragment {
    private String condition;
    private final Template thenPart;
    private Template elsePart = null;
    private final boolean negated;
    private final boolean isAttribute;

    public IfStmt(String string, Template template) throws TemplateParser.SyntaxError {
        this(string, template, null);
    }

    public IfStmt(String string, Template template, Template template2) throws TemplateParser.SyntaxError {
        if (string.startsWith("!")) {
            this.negated = true;
            string = string.substring(1).trim();
        } else {
            this.negated = false;
        }
        if (string.startsWith("#")) {
            this.isAttribute = true;
            this.condition = string.substring(1);
        } else if (string.startsWith("$")) {
            this.isAttribute = false;
            this.condition = string.substring(1);
        } else {
            this.isAttribute = false;
            this.condition = string;
        }
        if (string.isEmpty()) {
            throw new TemplateParser.SyntaxError("empty if condition");
        }
        TemplateParser.acceptVariableName(-1, this.condition);
        this.thenPart = template;
        this.elsePart = template2;
    }

    private boolean evalCondition(TemplateContext templateContext) {
        String string = this.isAttribute ? templateContext.evalAttribute(this.condition) : templateContext.evalVariable(this.condition);
        boolean bl = string.equals("true");
        return this.negated ? !bl : bl;
    }

    @Override
    public void expand(TemplateContext templateContext, StringBuilder stringBuilder) {
        if (this.evalCondition(templateContext)) {
            this.thenPart.expand(templateContext, stringBuilder);
        } else if (this.elsePart != null) {
            this.elsePart.expand(templateContext, stringBuilder);
        }
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public boolean isExpansion() {
        return true;
    }
}

