/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jastadd.tinytemplate.Indentation;
import org.jastadd.tinytemplate.Template;
import org.jastadd.tinytemplate.TemplateContext;
import org.jastadd.tinytemplate.TemplateExpansionWarning;
import org.jastadd.tinytemplate.TemplateParser;

public class TinyTemplate
extends TemplateContext {
    private Indentation indentation = new Indentation("  ");
    private Map<String, Template> templates = new HashMap<String, Template>();
    private static boolean throwExceptions = false;
    private static boolean printWarnings = true;

    public TinyTemplate() {
    }

    public TinyTemplate(InputStream inputStream) throws TemplateParser.SyntaxError {
        this.loadTemplates(inputStream);
    }

    public TinyTemplate(String string) throws TemplateParser.SyntaxError {
        this.loadTemplates(string);
    }

    public static void throwExceptions(boolean bl) {
        throwExceptions = bl;
    }

    public static void printWarnings(boolean bl) {
        printWarnings = bl;
    }

    @Override
    public void expand(TemplateContext templateContext, String string, PrintStream printStream) {
        Template template = this.lookupTemplate(string);
        if (template != null) {
            template.expand(templateContext, printStream);
        }
    }

    @Override
    public void expand(TemplateContext templateContext, String string, PrintWriter printWriter) {
        Template template = this.lookupTemplate(string);
        if (template != null) {
            template.expand(templateContext, printWriter);
        }
    }

    @Override
    public void expand(TemplateContext templateContext, String string, StringBuffer stringBuffer) {
        Template template = this.lookupTemplate(string);
        if (template != null) {
            template.expand(templateContext, stringBuffer);
        }
    }

    @Override
    public void expand(TemplateContext templateContext, String string, StringBuilder stringBuilder) {
        Template template = this.lookupTemplate(string);
        if (template != null) {
            template.expand(templateContext, stringBuilder);
        }
    }

    private Template lookupTemplate(String string) {
        Template template = this.templates.get(string);
        if (template == null) {
            TinyTemplate.expansionWarning("unknown template: " + string);
        }
        return template;
    }

    @Override
    public void flushVariables() {
    }

    @Override
    public void bind(String string, String string2) {
        throw new UnsupportedOperationException("Can not bind variable on root template context");
    }

    @Override
    public void bind(String string, boolean bl) {
        throw new UnsupportedOperationException("Can not bind variable on root template context");
    }

    @Override
    public String evalVariable(String string) {
        String string2 = "unbound variable " + string;
        return TinyTemplate.expansionWarning(string2);
    }

    public void loadTemplates(InputStream inputStream) throws TemplateParser.SyntaxError {
        TemplateParser templateParser = new TemplateParser(this, inputStream);
        templateParser.parse();
    }

    public void loadTemplates(String string) throws TemplateParser.SyntaxError {
        TemplateParser templateParser = new TemplateParser(this, new ByteArrayInputStream(string.getBytes()));
        templateParser.parse();
    }

    public void addTemplate(String string, Template template) {
        this.templates.put(string, template);
    }

    @Override
    public String evalAttribute(String string) {
        return TinyTemplate.evalAttribute(string, null);
    }

    public static String evalAttribute(String string, Object object) {
        try {
            if (object == null) {
                String string2 = "failed to eval " + string + "; reason: no context";
                return TinyTemplate.expansionWarning(string2);
            }
            Method method = object.getClass().getMethod(string, new Class[0]);
            return "" + method.invoke(object, new Object[0]);
        }
        catch (SecurityException securityException) {
            String string3 = "failed to eval attribute '" + string + "'; reason: security exception";
            return TinyTemplate.expansionWarning(string3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string4 = "failed to eval attribute '" + string + "'; reason: no such method";
            return TinyTemplate.expansionWarning(string4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string5 = "failed to eval attribute '" + string + "'; reason: illegal argument exception";
            return TinyTemplate.expansionWarning(string5);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string6 = "failed to eval attribute '" + string + "'; reason: illegal access exception";
            return TinyTemplate.expansionWarning(string6);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string7 = "failed to eval attribute '" + string + "'; reason: invocation target exception";
            return TinyTemplate.expansionWarning(string7);
        }
    }

    private static String expansionWarning(String string) {
        if (throwExceptions) {
            throw new TemplateExpansionWarning(string);
        }
        if (printWarnings) {
            System.err.println("Template expansion warning: " + string);
        }
        return "<" + string + ">";
    }

    @Override
    public String evalIndentation(int n) {
        return this.indentation.getIndentation(n);
    }

    public void setIndentation(String string) {
        this.indentation = new Indentation(string);
    }
}

