/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.jastadd.io.LookaheadReader;
import org.jastadd.tinytemplate.Indentation;
import org.jastadd.tinytemplate.Template;
import org.jastadd.tinytemplate.TinyTemplate;
import org.jastadd.tinytemplate.fragment.AttributeReference;
import org.jastadd.tinytemplate.fragment.EmptyFragment;
import org.jastadd.tinytemplate.fragment.IFragment;
import org.jastadd.tinytemplate.fragment.IfStmt;
import org.jastadd.tinytemplate.fragment.IncludeStmt;
import org.jastadd.tinytemplate.fragment.NewlineFragment;
import org.jastadd.tinytemplate.fragment.StringFragment;
import org.jastadd.tinytemplate.fragment.VariableReference;

public class TemplateParser {
    private final TinyTemplate templates;
    private final LookaheadReader in;
    private int line = 1;

    public TemplateParser(TinyTemplate tinyTemplate, InputStream inputStream) {
        this.templates = tinyTemplate;
        this.in = new LookaheadReader(inputStream, 2);
    }

    public void parse() throws SyntaxError {
        try {
            while (this.in.peek(0) != -1) {
                this.parseTemplates();
            }
        }
        catch (IOException iOException) {
            throw new SyntaxError("IO error during template parsing: " + iOException.getMessage());
        }
    }

    private void parseTemplates() throws IOException, SyntaxError {
        LinkedList<String> linkedList = new LinkedList<String>();
        while (true) {
            this.skipWhitespace();
            if (this.isEOF()) {
                if (linkedList.isEmpty()) break;
                throw new SyntaxError(this.line, "missing template body at end of file");
            }
            if (this.isNewline()) {
                this.skipNewline();
                continue;
            }
            if (this.isLinecomment()) {
                this.skipLinecomment();
                continue;
            }
            if (this.isAssign()) {
                if (linkedList.isEmpty()) {
                    throw new SyntaxError(this.line, "misplaced '='");
                }
                this.in.pop();
                continue;
            }
            if (this.isTemplateStart()) {
                if (linkedList.isEmpty()) {
                    throw new SyntaxError(this.line, "missing template name");
                }
                Template template = this.parseTemplate();
                for (String string : linkedList) {
                    this.templates.addTemplate(string, template);
                }
                linkedList.clear();
                continue;
            }
            linkedList.add(this.nextName());
        }
    }

    private void skipLinecomment() throws IOException {
        this.in.pop();
        while (!this.isNewline() && !this.isEOF()) {
            this.in.pop();
        }
    }

    private void skipWhitespace() throws IOException {
        while (this.isWhitespace()) {
            this.in.pop();
        }
    }

    private void skipIndentation() throws IOException {
        this.in.pop();
        this.in.pop();
    }

    private boolean isTemplateStart() throws IOException, SyntaxError {
        if (this.in.peek(0) == 91) {
            if (this.in.peek(1) == 91) {
                return true;
            }
            throw new SyntaxError(this.line, "misplaced '['");
        }
        if (this.in.peek(0) == 93) {
            throw new SyntaxError(this.line, "misplaced ']'");
        }
        return false;
    }

    private boolean isIndentation() throws IOException {
        return this.in.peek(0) == 32 && this.in.peek(1) == 32;
    }

    private boolean isTemplateEnd() throws IOException {
        return this.in.peek(0) == 93 && this.in.peek(1) == 93;
    }

    private boolean isAssign() throws IOException {
        return this.in.peek(0) == 61;
    }

    private boolean isLinecomment() throws IOException {
        return this.in.peek(0) == 35;
    }

    private boolean isWhitespace() throws IOException {
        return Character.isWhitespace(this.in.peek(0)) && !this.isNewline();
    }

    private boolean isNewline() throws IOException {
        return this.isNewline(this.in.peek(0));
    }

    private boolean isNewline(int n) throws IOException {
        return n == 10 || n == 13;
    }

    private boolean isEOF() throws IOException {
        return this.in.peek(0) == -1;
    }

    private void skipNewline() throws IOException {
        if (this.in.peek(0) == 92) {
            this.in.pop();
        }
        if (this.in.peek(0) == 13 && this.in.peek(1) == 10) {
            this.in.pop();
        }
        this.in.pop();
        ++this.line;
    }

    private String nextName() throws IOException, SyntaxError {
        StringBuilder stringBuilder = new StringBuilder();
        while (!(this.isWhitespace() || this.isAssign() || this.isTemplateStart() || this.isEOF())) {
            stringBuilder.append((char)this.in.pop());
        }
        return stringBuilder.toString();
    }

    private Template parseTemplate() throws IOException, SyntaxError {
        IFragment iFragment;
        this.in.pop();
        this.in.pop();
        Template template = new Template();
        boolean bl = true;
        while (!(iFragment = this.nextFragment(template, bl)).isEmpty()) {
            if (iFragment.isVar("else")) {
                throw new SyntaxError(this.line, "stray $else");
            }
            if (iFragment.isVar("endif")) {
                throw new SyntaxError(this.line, "stray $endif");
            }
            bl = iFragment.isNewline();
            template.addFragment(iFragment);
        }
        this.in.pop();
        this.in.pop();
        template.trim();
        return template;
    }

    private IFragment nextFragment(Template template, boolean bl) throws IOException, SyntaxError {
        if (this.isEOF()) {
            throw new SyntaxError(this.line, "unexpected end of file while parsing template body");
        }
        if (bl) {
            int n = 0;
            while (this.isIndentation()) {
                this.skipIndentation();
                ++n;
            }
            if (n > 0) {
                return Indentation.getFragment(n);
            }
        }
        if (this.isVariable()) {
            String string = this.nextReference();
            if (string.isEmpty()) {
                throw new SyntaxError(this.line, "empty variable name");
            }
            if (string.equals("if")) {
                return this.parseIfStmt();
            }
            if (string.equals("include")) {
                return this.parseIncludeStmt();
            }
            TemplateParser.acceptVariableName(this.line, string);
            VariableReference variableReference = new VariableReference(string);
            template.addIndentation(variableReference);
            return variableReference;
        }
        if (this.isAttribute()) {
            String string = this.nextReference();
            if (string.isEmpty()) {
                throw new SyntaxError(this.line, "empty attribute name");
            }
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if ((i != 0 || Character.isJavaIdentifierStart(c)) && Character.isJavaIdentifierPart(c)) continue;
                throw new SyntaxError(this.line, "the attribute " + string + " is not a valid Java identifier");
            }
            AttributeReference attributeReference = new AttributeReference(string);
            template.addIndentation(attributeReference);
            return attributeReference;
        }
        if (this.isNewline()) {
            this.skipNewline();
            return NewlineFragment.INSTANCE;
        }
        if (this.isTemplateEnd()) {
            return EmptyFragment.INSTANCE;
        }
        return new StringFragment(this.nextString());
    }

    private IfStmt parseIfStmt() throws IOException, SyntaxError {
        Template template;
        Template template2;
        String string;
        block5: {
            IFragment iFragment;
            string = this.parseCondition();
            template2 = new Template();
            template = null;
            Template template3 = template2;
            boolean bl = true;
            while (!(iFragment = this.nextFragment(template3, bl)).isEmpty()) {
                if (iFragment.isVar("else")) {
                    if (template != null) {
                        throw new SyntaxError(this.line, "too many $else");
                    }
                    template3 = template = new Template();
                    continue;
                }
                if (!iFragment.isVar("endif")) {
                    bl = iFragment.isNewline();
                    template3.addFragment(iFragment);
                    continue;
                }
                break block5;
            }
            throw new SyntaxError(this.line, "missing $endif");
        }
        template2.trim();
        if (template != null) {
            template.trim();
        }
        return new IfStmt(string, template2, template);
    }

    private IncludeStmt parseIncludeStmt() throws IOException, SyntaxError {
        while (this.isWhitespace()) {
            this.skipWhitespace();
        }
        if (this.in.peek(0) != 40) {
            throw new SyntaxError(this.line, "missing template name");
        }
        String string = this.parseParenthesizedReference().trim();
        return new IncludeStmt(string);
    }

    private String parseCondition() throws IOException, SyntaxError {
        while (this.isWhitespace()) {
            this.skipWhitespace();
        }
        if (this.in.peek(0) != 40) {
            throw new SyntaxError(this.line, "missing if condition");
        }
        return this.parseParenthesizedReference().trim();
    }

    private String nextString() throws IOException, SyntaxError {
        StringBuilder stringBuilder = new StringBuilder(512);
        while (!(this.isEOF() || this.isVariable() || this.isAttribute() || this.isNewline() || this.isTemplateEnd())) {
            if (this.in.peek(0) == 91 && this.in.peek(1) == 91) {
                throw new SyntaxError(this.line, "double brackets are not allowed inside templates");
            }
            if (this.in.peek(0) == 35 || this.in.peek(0) == 36) {
                this.in.pop();
            }
            stringBuilder.append((char)this.in.pop());
        }
        return stringBuilder.toString();
    }

    private String nextReference() throws IOException, SyntaxError {
        this.in.pop();
        if (this.in.peek(0) == 40) {
            return this.parseParenthesizedReference();
        }
        return this.parseSimpleReference();
    }

    private String parseSimpleReference() throws IOException, SyntaxError {
        StringBuilder stringBuilder = new StringBuilder(128);
        while (!this.isSimpleReferenceEnd()) {
            stringBuilder.append((char)this.in.pop());
        }
        return stringBuilder.toString();
    }

    private boolean isSimpleReferenceEnd() throws IOException {
        return this.isEOF() || this.in.peek(0) == 36 || !Character.isJavaIdentifierPart(this.in.peek(0));
    }

    private boolean isParenthesizedReferenceEnd() throws IOException {
        return this.isEOF() || this.isNewline() || this.in.peek(0) == 91 || this.in.peek(0) == 93;
    }

    private String parseParenthesizedReference() throws IOException, SyntaxError {
        this.in.pop();
        StringBuilder stringBuilder = new StringBuilder(128);
        int n = 1;
        while (true) {
            if (this.isParenthesizedReferenceEnd()) {
                throw new SyntaxError(this.line, "missing right parenthesis");
            }
            int n2 = this.in.pop();
            if (n2 == 40) {
                ++n;
            } else if (n2 == 41 && --n == 0) break;
            stringBuilder.append((char)n2);
        }
        return stringBuilder.toString();
    }

    private boolean isVariable() throws IOException {
        return this.in.peek(0) == 36 && this.in.peek(1) != 36;
    }

    private boolean isAttribute() throws IOException {
        return this.in.peek(0) == 35 && this.in.peek(1) != 35;
    }

    public static void acceptVariableName(int n, String string) throws SyntaxError {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.') continue;
            String string2 = "illegal characters in variable name " + string;
            if (n == -1) {
                throw new SyntaxError(string2);
            }
            throw new SyntaxError(n, string2);
        }
    }

    public static class SyntaxError
    extends Exception {
        public SyntaxError(int n, String string) {
            super("Syntax error at line " + n + ": " + string);
        }

        public SyntaxError(String string) {
            super(string);
        }
    }
}

