/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jastadd.tinytemplate.Indentation;
import org.jastadd.tinytemplate.TemplateContext;
import org.jastadd.tinytemplate.fragment.IFragment;
import org.jastadd.tinytemplate.fragment.NestedIndentationFragment;

public class Template {
    private List<List<IFragment>> lines = new ArrayList<List<IFragment>>();

    public Template() {
        this.lines.add(new ArrayList());
    }

    public void expand(TemplateContext templateContext, PrintStream printStream) {
        StringBuilder stringBuilder = new StringBuilder();
        for (List<IFragment> list : this.lines) {
            this.expandLine(templateContext, list, stringBuilder);
            printStream.print(stringBuilder.toString());
        }
    }

    public void expand(TemplateContext templateContext, PrintWriter printWriter) {
        StringBuilder stringBuilder = new StringBuilder();
        for (List<IFragment> list : this.lines) {
            this.expandLine(templateContext, list, stringBuilder);
            printWriter.print(stringBuilder.toString());
        }
    }

    public void expand(TemplateContext templateContext, StringBuffer stringBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        for (List<IFragment> list : this.lines) {
            this.expandLine(templateContext, list, stringBuilder);
            stringBuffer.append(stringBuilder.toString());
        }
    }

    public void expand(TemplateContext templateContext, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder();
        for (List<IFragment> list : this.lines) {
            this.expandLine(templateContext, list, stringBuilder2);
            stringBuilder.append(stringBuilder2.toString());
        }
    }

    private void expandLine(TemplateContext templateContext, List<IFragment> list, StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        boolean bl = false;
        for (IFragment iFragment : list) {
            bl |= iFragment.isExpansion();
            iFragment.expand(templateContext, stringBuilder);
        }
        if (bl && this.isEmptyLine(stringBuilder)) {
            stringBuilder.setLength(0);
        }
    }

    private boolean isEmptyLine(StringBuilder stringBuilder) {
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (Character.isWhitespace(stringBuilder.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void load(InputStream inputStream) {
    }

    public void addIndentation(NestedIndentationFragment nestedIndentationFragment) {
        List<IFragment> list = this.lines.get(this.lines.size() - 1);
        if (!list.isEmpty() && list.get(0).isIndentation()) {
            nestedIndentationFragment.setIndentation((Indentation.IndentationFragment)list.get(0));
        }
    }

    public void addFragment(IFragment iFragment) {
        this.lines.get(this.lines.size() - 1).add(iFragment);
        if (iFragment.isNewline()) {
            this.lines.add(new ArrayList());
        }
    }

    public void trim() {
        this.trimLeadingNewline();
        this.trimConditionalWhitespace();
    }

    private void trimLeadingNewline() {
        for (IFragment iFragment : this.lines.get(0)) {
            if (iFragment.isWhitespace()) continue;
            return;
        }
        this.lines.remove(0);
        if (this.lines.isEmpty()) {
            this.lines.add(new ArrayList());
        }
    }

    private void trimConditionalWhitespace() {
        for (int i = 0; i < this.lines.size(); ++i) {
            boolean bl = true;
            boolean bl2 = false;
            for (IFragment iFragment : this.lines.get(i)) {
                if (!iFragment.isWhitespace() && !iFragment.isConditional() || iFragment.isConditional() && bl2) {
                    bl = false;
                    break;
                }
                bl2 |= iFragment.isConditional();
            }
            List<IFragment> list = this.trimLine(this.lines.get(i), bl && bl2);
            this.lines.set(i, list);
        }
    }

    private List<IFragment> trimLine(List<IFragment> list, boolean bl) {
        ArrayList<IFragment> arrayList = new ArrayList<IFragment>(this.lines.size());
        for (IFragment iFragment : list) {
            if (bl && iFragment.isWhitespace()) continue;
            arrayList.add(iFragment);
        }
        return arrayList;
    }
}

