/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd;

import java.io.PrintStream;

public abstract class Problem {
    private final String message;
    private final String file;
    private final int line;
    private final int column;

    public Problem(String string, String string2, int n, int n2) {
        this.message = string;
        this.file = string2;
        this.line = n;
        this.column = n2;
    }

    public abstract boolean isError();

    public final void print(PrintStream printStream) {
        printStream.println(this.toString());
    }

    public String toString() {
        String string;
        String string2 = this.isError() ? "Error" : "Warning";
        String string3 = string = this.file.isEmpty() ? "" : this.file;
        if (this.line != -1) {
            String string4 = string = string.isEmpty() ? "" + this.line : string + ":" + this.line;
            if (this.column != -1) {
                string = string + ":" + this.column;
            }
        }
        if (!string.isEmpty()) {
            string = " at " + string;
        }
        return string2 + string + ": " + this.message;
    }

    public static class Warning
    extends Problem {
        public Warning(String string) {
            super(string, "", -1, -1);
        }

        public Warning(String string, String string2) {
            super(string, string2, -1, -1);
        }

        public Warning(String string, String string2, int n) {
            super(string, string2, n, -1);
        }

        public Warning(String string, int n) {
            super(string, "", n, -1);
        }

        public Warning(String string, int n, int n2) {
            super(string, "", n, n2);
        }

        public Warning(String string, String string2, int n, int n2) {
            super(string, string2, n, n2);
        }

        @Override
        public boolean isError() {
            return false;
        }
    }

    public static class Error
    extends Problem {
        public Error(String string) {
            super(string, "", -1, -1);
        }

        public Error(String string, String string2) {
            super(string, string2, -1, -1);
        }

        public Error(String string, String string2, int n) {
            super(string, string2, n, -1);
        }

        public Error(String string, int n) {
            super(string, "", n, -1);
        }

        public Error(String string, int n, int n2) {
            super(string, "", n, n2);
        }

        public Error(String string, String string2, int n, int n2) {
            super(string, string2, n, n2);
        }

        @Override
        public boolean isError() {
            return true;
        }
    }
}

