/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jastadd.Option;

public class CommandLineArguments {
    private final List<Option> options = new LinkedList<Option>();
    private final List<String> operands = new ArrayList<String>();

    public void addOption(Option option) {
        this.options.add(option);
    }

    public void match(String[] stringArray, PrintStream printStream) {
        int n = 0;
        Option option = null;
        while (n < stringArray.length) {
            Iterator<Option> iterator = this.options.iterator();
            while (iterator.hasNext() && n < stringArray.length) {
                Option option2 = iterator.next();
                int n2 = option2.match(stringArray, n, printStream);
                if (n2 > 0) {
                    option = option2;
                    n += n2;
                    continue;
                }
                if (option == option2) {
                    if (stringArray[n].startsWith("--")) {
                        printStream.println("Warning: Unknown option \"" + stringArray[n] + "\" will be ignored");
                    } else {
                        this.operands.add(stringArray[n]);
                    }
                    ++n;
                    continue;
                }
                if (option != null) continue;
                option = option2;
            }
        }
    }

    public void printHelp(PrintStream printStream) {
        for (Option option : this.options) {
            if (option.nonStandard || option.deprecated) continue;
            option.printHelp(printStream);
        }
    }

    public void printNonStandardOptions(PrintStream printStream) {
        for (Option option : this.options) {
            if (!option.nonStandard) continue;
            option.printHelp(printStream);
        }
    }

    public int getNumOperands() {
        return this.operands.size();
    }

    public String getOperand(int n) {
        return this.operands.get(n);
    }
}

