/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.Ast;
import ast.AST.AstTreeConstants;
import ast.AST.AstVisitor;
import ast.AST.Node;
import ast.AST.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Ast parser;
    public Token firstToken;
    public Token lastToken;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Ast ast, int n) {
        this(n);
        this.parser = ast;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public Object jjtAccept(AstVisitor astVisitor, Object object) {
        return astVisitor.visit(this, object);
    }

    public Object childrenAccept(AstVisitor astVisitor, Object object) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(astVisitor, object);
            }
        }
        return object;
    }

    public String toString() {
        return AstTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public void unparseComment(StringBuffer stringBuffer) {
        Token token = this.firstToken.specialToken;
        if (token != null) {
            while (token.specialToken != null) {
                token = token.specialToken;
            }
            while (token != null) {
                stringBuffer.append(this.addUnicodeEscapes(token.image));
                token = token.next;
            }
        }
    }

    public String unparseComment() {
        StringBuffer stringBuffer = new StringBuffer();
        this.unparseComment(stringBuffer);
        return stringBuffer.toString();
    }

    private String addUnicodeEscapes(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((c < ' ' || c > '~') && c != '\t' && c != '\n' && c != '\r' && c != '\f') {
                String string3 = "0000" + Integer.toString(c, 16);
                string2 = string2 + "\\u" + string3.substring(string3.length() - 4, string3.length());
                continue;
            }
            string2 = string2 + c;
        }
        return string2;
    }
}

