DROP TABLE IF EXISTS applications;
DROP TABLE IF EXISTS programs;
DROP TABLE IF EXISTS majors;
DROP TABLE IF EXISTS students;
DROP TABLE IF EXISTS colleges;

CREATE TABLE students (
  s_id         INT,
  s_name       TEXT,
  gpa          REAL,
  PRIMARY KEY  (s_id)
);

CREATE TABLE colleges (
  c_name       TEXT,
  state        TEXT,
  enrollment   INT,
  PRIMARY KEY  (c_name)
);

CREATE TABLE majors (
  major        TEXT,
  full_name    TEXT,
  credits      TEXT,
  PRIMARY KEY  (major)
);

CREATE TABLE programs (
  major        TEXT,
  c_name       TEXT,
  enrollment   INT,
  PRIMARY KEY  (major, c_name),
  FOREIGN KEY  (major) REFERENCES majors(major),
  FOREIGN KEY  (c_name) REFERENCES colleges(c_name)
);

CREATE TABLE applications (
  s_id         INT,
  c_name       TEXT,
  major        TEXT,
  decision     CHAR DEFAULT ('N'),
  PRIMARY KEY  (s_id, c_name, major),
  FOREIGN KEY  (s_id) REFERENCES students(s_id),
  FOREIGN KEY  (major, c_name) REFERENCES programs(major, c_name)
);

INSERT
INTO     students
VALUES   (123,'Amy',3.9),
         (234,'Bob',3.6),
         (345,'Craig',3.5),
         (456,'Doris',3.9),
         (543,'Craig',3.4),
         (567,'Edward',2.9),
         (654,'Amy',3.9),
         (678,'Fay',3.8),
         (765,'Jay',2.9),
         (789,'Gary',3.4),
         (876,'Irene',3.9),
         (987,'Helen',3.7);

INSERT
INTO     colleges
VALUES   ('Stanford','CA',15000),
         ('Berkeley','CA',36000),
         ('MIT','MA',10000),
         ('Cornell','NY',21000);

INSERT
INTO     majors(major, full_name, credits)
VALUES   ('CS', 'Computer Science', 300),
         ('EE', 'Electrical Engineering', 300),
         ('bioengineering', 'Bioengineering', 300),
         ('biology', 'Biology', 300),
         ('history', 'History', 300),
         ('marine biology', 'Marine Biology', 300),
         ('psychology', 'Psychology', 300);

-- INSERT
-- INTO     applications(s_id, c_name, major, decision)
-- VALUES   (123,'Berkeley','CS','Y'),
--          (123,'Cornell','EE','Y'),
--          (234,'Berkeley','biology','N'),
--          (345,'MIT','bioengineering','Y');
