PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
DROP TABLE IF EXISTS students;
CREATE TABLE students (
  ssn          CHAR(11),
  first_name   TEXT NOT NULL,
  last_name    TEXT NOT NULL,
  PRIMARY KEY  (ssn)
);
INSERT INTO students VALUES('19950705-2308','Anna','Johansson');
INSERT INTO students VALUES('19930702-3582','Anna','Johansson');
INSERT INTO students VALUES('19911212-1746','Emma','Alm');
INSERT INTO students VALUES('19910707-3787','Emma','Nilsson');
INSERT INTO students VALUES('19931213-2824','Elaine','Robertson');
INSERT INTO students VALUES('19951122-1048','Maria','Nordman');
INSERT INTO students VALUES('19910308-1826','Helena','Troberg');
INSERT INTO students VALUES('19941003-1225','Lotta','Emanuelsson');
INSERT INTO students VALUES('19950829-1848','Anna','Nyström');
INSERT INTO students VALUES('19860819-2864','Maria','Andersson');
INSERT INTO students VALUES('19930502-2040','Marie','Persson');
INSERT INTO students VALUES('19870909-3367','Tina','Lööf');
INSERT INTO students VALUES('19870915-2742','Salome','Zourabichvili');
INSERT INTO students VALUES('19900227-2369','Märit','Aspegren');
INSERT INTO students VALUES('19931208-3605','Ylva','Jacobsson');
INSERT INTO students VALUES('19951004-2346','Frida','Weidel');
INSERT INTO students VALUES('19910915-2068','Karolin','Ek');
INSERT INTO students VALUES('19860206-1065','Emma','Hjort');
INSERT INTO students VALUES('19900528-1540','Sofia','Kjellberg');
INSERT INTO students VALUES('19950317-3520','Lisa','Berg');
INSERT INTO students VALUES('19891021-1287','Nicole','Tan');
INSERT INTO students VALUES('19880620-2564','Valerie','Zhang');
INSERT INTO students VALUES('19940802-3861','Birgit','Ewesson');
INSERT INTO students VALUES('19850706-2762','Ulrika','Jonsson');
INSERT INTO students VALUES('19890622-1928','Jenny','Lundin');
INSERT INTO students VALUES('19910226-3409','Karin','Östberg');
INSERT INTO students VALUES('19861103-2438','Bo','Ek');
INSERT INTO students VALUES('19931225-3158','Bo','Ek');
INSERT INTO students VALUES('19850819-2139','Bo','Ek');
INSERT INTO students VALUES('19891220-1393','Erik','Andersson');
INSERT INTO students VALUES('19900313-2257','Erik','Andersson');
INSERT INTO students VALUES('19940825-1934','Filip','Gustavsson');
INSERT INTO students VALUES('19860323-1071','Niklas','Andersson');
INSERT INTO students VALUES('19920308-3854','David','Carlsson');
INSERT INTO students VALUES('19890820-2496','Tobias','Enberg');
INSERT INTO students VALUES('19920623-3258','Magnus','Pettersson');
INSERT INTO students VALUES('19850517-2597','Filip','Persson');
INSERT INTO students VALUES('19890621-3057','Ola','Nilsson');
INSERT INTO students VALUES('19920812-1857','Jakob','Malmberg');
INSERT INTO students VALUES('19850208-1213','Henrik','Berg');
INSERT INTO students VALUES('19930420-2833','John','Lind');
INSERT INTO students VALUES('19930716-3933','Patrik','Lundh');
INSERT INTO students VALUES('19940801-2971','Mikael','Nilsson');
INSERT INTO students VALUES('19931128-1333','Joakim','Nilsson');
INSERT INTO students VALUES('19940318-2373','Conny','Modig');
INSERT INTO students VALUES('19881030-2772','Christian','Wallman');
INSERT INTO students VALUES('19931015-1271','Magnus','Strömgren');
INSERT INTO students VALUES('19900206-3735','Daniel','Ahlman');
INSERT INTO students VALUES('19891231-2554','Lars','Molin');
INSERT INTO students VALUES('19900526-1450','Magnus','Nilsson');
INSERT INTO students VALUES('19950830-2637','Anders','Olsson');
INSERT INTO students VALUES('19880322-3951','Martin','Alm');
INSERT INTO students VALUES('19950714-2190','Håkan','Mossgren');
INSERT INTO students VALUES('19911020-3538','Fredrik','Ryd');
INSERT INTO students VALUES('19921222-2113','Mats','Wikström');
INSERT INTO students VALUES('19891106-1277','Anders','Magnusson');
INSERT INTO students VALUES('19920906-3371','Andreas','Molin');
INSERT INTO students VALUES('19890103-1256','Johan','Brattberg');
INSERT INTO students VALUES('19920514-3433','Johan','Olsson');
INSERT INTO students VALUES('19911015-3758','Jonathan','Jönsson');
INSERT INTO students VALUES('19950125-1153','Magnus','Hultgren');
INSERT INTO students VALUES('19950715-2090','Axel','Nord');
INSERT INTO students VALUES('19880206-1915','Henrik','Hult');
INSERT INTO students VALUES('19900918-3999','Jason','Li');
INSERT INTO students VALUES('19900129-3374','Henrik','Gustavsson');
INSERT INTO students VALUES('19881110-1272','Torbjörn','Modig');
INSERT INTO students VALUES('19921029-1995','Daniel','Axelsson');
INSERT INTO students VALUES('19901030-1895','Per-Erik','Pettersson');
INSERT INTO students VALUES('19920921-2499','Javier','Chan');
INSERT INTO students VALUES('19891007-3091','Roger','Brorsson');
INSERT INTO students VALUES('19930804-3050','Patrik','Ohlsson');
INSERT INTO students VALUES('19910101-1234','Peter','Solberg');
DROP TABLE IF EXISTS departments;
CREATE TABLE departments (
  department_code  TEXT,
  department_name  TEXT,
  PRIMARY KEY      (department_code)
);
INSERT INTO departments VALUES('eda','Datavetenskap');
INSERT INTO departments VALUES('edi','Informationsteori');
INSERT INTO departments VALUES('eem','Elektrisk mätteknik');
INSERT INTO departments VALUES('eie','Industriell elektroteknik och automation');
INSERT INTO departments VALUES('eit','Elektro- och informationsteknik');
INSERT INTO departments VALUES('sol','Språk och litteraturcentrum');
INSERT INTO departments VALUES('faf','Fysik');
INSERT INTO departments VALUES('fma','Matematik');
INSERT INTO departments VALUES('fmi','Teknik och samhälle');
INSERT INTO departments VALUES('fms','Matematisk statistik');
INSERT INTO departments VALUES('frt','Reglerteknik');
INSERT INTO departments VALUES('kii','Internationella institutet för industriell miljöekonomi');
INSERT INTO departments VALUES('mam','Designvetenskaper');
INSERT INTO departments VALUES('mie','Industriell automation');
INSERT INTO departments VALUES('mio','Maskinvetenskaper');
INSERT INTO departments VALUES('tek','Filosofi');
DROP TABLE IF EXISTS courses;
CREATE TABLE courses (
  course_code      CHAR(6),
  course_name      TEXT NOT NULL,
  department_code  TEXT,
  level            CHAR(2),
  credits          DOUBLE NOT NULL CHECK (credits > 0),
  PRIMARY KEY      (course_code),
  FOREIGN KEY      (department_code) REFERENCES departments(department_code)
);
INSERT INTO courses VALUES('EDA016','Programmeringsteknik','eda','G1',7.5);
INSERT INTO courses VALUES('EDA031','C++ - programmering','eda','G2',7.5);
INSERT INTO courses VALUES('EDA040','Realtidsprogrammering','eda','G2',6.0);
INSERT INTO courses VALUES('EDA050','Operativsystem','eda','G2',4.5);
INSERT INTO courses VALUES('EDA070','Datorer och datoranvändning','eda','G1',3.0);
INSERT INTO courses VALUES('EDA095','Nätverksprogrammering','eda','G2',7.5);
INSERT INTO courses VALUES('EDA132','Tillämpad artificiell intelligens','eda','G2',7.5);
INSERT INTO courses VALUES('EDA180','Kompilatorteknik','eda','G2',7.5);
INSERT INTO courses VALUES('EDAF75','Databasteknik','eda','G2',7.5);
INSERT INTO courses VALUES('EDA221','Datorgrafik','eda','G2',7.5);
INSERT INTO courses VALUES('EDA230','Optimerande kompilatorer','eda','A',7.5);
INSERT INTO courses VALUES('EDA260','Programvaruutveckling i grupp – projekt','eda','G2',6.0);
INSERT INTO courses VALUES('EDA270','Coachning av programvaruteam','eda','A',9.0);
INSERT INTO courses VALUES('EDA385','Konstruktion av inbyggda system, fördjupningskurs','eda','A',7.5);
INSERT INTO courses VALUES('EDAA01','Programmeringsteknik - fördjupningskurs','eda','G1',7.5);
INSERT INTO courses VALUES('EDAA05','Datorer i system','eda','G1',8.0);
INSERT INTO courses VALUES('EDAA25','C-programmering','eda','G1',3.0);
INSERT INTO courses VALUES('EDAF01','Operativsystem - projekt','eda','G2',3.0);
INSERT INTO courses VALUES('EDAF05','Algoritmer, datastrukturer och komplexitet','eda','G2',5.0);
INSERT INTO courses VALUES('EDAF10','Objektorienterad modellering och diskreta strukturer','eda','G2',7.5);
INSERT INTO courses VALUES('EDAF15','Algoritmimplementering','eda','G2',5.0);
INSERT INTO courses VALUES('EDAN01','Constraint-programmering','eda','A',7.5);
INSERT INTO courses VALUES('EDAN10','Konfigurationshantering','eda','A',7.5);
INSERT INTO courses VALUES('EDAN15','Konstruktion av inbyggda system','eda','A',7.5);
INSERT INTO courses VALUES('EDAN20','Språkteknologi','eda','A',7.5);
INSERT INTO courses VALUES('EDAN25','Multicoreprogrammering','eda','A',6.0);
INSERT INTO courses VALUES('EDAN30','Fotorealistisk datorgrafik','eda','A',7.5);
INSERT INTO courses VALUES('EDAN35','Högpresterande datorgrafik','eda','A',7.5);
INSERT INTO courses VALUES('EDAN40','Funktionsprogrammering','eda','A',7.5);
INSERT INTO courses VALUES('EDAN50','Intelligenta system - projekt','eda','A',7.5);
INSERT INTO courses VALUES('EDAN55','Avancerade algoritmer','eda','A',7.5);
INSERT INTO courses VALUES('EDAN60','Språkteknologi: Projekt','eda','A',7.5);
INSERT INTO courses VALUES('EDI042','Kodningsteknik','edi','A',7.5);
INSERT INTO courses VALUES('EDIN01','Kryptoteknik','edi','A',7.5);
INSERT INTO courses VALUES('EDIN05','Matematisk kryptologi','edi','A',7.5);
INSERT INTO courses VALUES('EEM031','Sensorteknik','eem','G2',7.5);
INSERT INTO courses VALUES('EEMF05','Medicinsk mätteknik','eem','G2',7.5);
INSERT INTO courses VALUES('EEMN01','Mikrosensorer','eem','A',7.5);
INSERT INTO courses VALUES('EEMN05','EMC, störningar och störningsbegränsning','eem','A',7.5);
INSERT INTO courses VALUES('EEMN10','Datorbaserade mätsystem','eem','A',7.5);
INSERT INTO courses VALUES('EEMN15','Ultraljudsfysik och teknik','eem','A',7.5);
INSERT INTO courses VALUES('EIE061','Projekt i industriell elektroteknik och automation','eie','A',7.5);
INSERT INTO courses VALUES('EIEF01','Tillämpad mekatronik','eie','G2',10.0);
INSERT INTO courses VALUES('EIEN01','Mekatronik, industriell produktframtagning','eie','A',10.0);
INSERT INTO courses VALUES('EIT020','Digitalteknik','eit','G2',9.0);
INSERT INTO courses VALUES('EIT060','Datasäkerhet','eit','G1',7.5);
INSERT INTO courses VALUES('EIT070','Datorteknik','eit','G2',6.0);
INSERT INTO courses VALUES('EIT140','OFDM för bredbandskommunikation','eit','A',7.5);
INSERT INTO courses VALUES('EITF01','Digitala bilder – kompression','eit','G2',9.0);
INSERT INTO courses VALUES('EITF05','Webbsäkerhet','eit','G2',4.0);
INSERT INTO courses VALUES('EITF20','Datorarkitektur','eit','G2',7.5);
INSERT INTO courses VALUES('EITF35','Digitala strukturer på kisel','eit','G2',7.5);
INSERT INTO courses VALUES('EITF40','Digitala och analoga projekt','eit','G2',7.5);
INSERT INTO courses VALUES('EITN10','Multipelantennsystem','eit','A',7.5);
INSERT INTO courses VALUES('EITN30','Internet inuti','eit','A',7.5);
INSERT INTO courses VALUES('EITN35','Projekt i elektro- och informationsteknik','eit','A',7.5);
INSERT INTO courses VALUES('EITN40','Avancerad webbsäkerhet','eit','A',4.0);
INSERT INTO courses VALUES('EITN45','Informationsteori','eit','A',7.5);
INSERT INTO courses VALUES('EITN50','Avancerad datasäkerhet','eit','A',7.5);
INSERT INTO courses VALUES('ESS030','Komponentfysik','faf','G2',4.5);
INSERT INTO courses VALUES('ESS050','Elektromagnetisk fältteori','faf','G2',9.0);
INSERT INTO courses VALUES('ESSF10','Mätteknik','faf','G2',5.0);
INSERT INTO courses VALUES('ETI265','Signalbehandling i multimedia','eit','G1',7.5);
INSERT INTO courses VALUES('ETIA01','Elektronik','eit','G1',8.0);
INSERT INTO courses VALUES('ETIA10','Patent och annan immaterialrätt','eit','G1',7.5);
INSERT INTO courses VALUES('ETIF05','Grundläggande radioteknik','eit','G2',7.5);
INSERT INTO courses VALUES('ETIF10','Signalbehandling - design och implementering','eit','G2',7.5);
INSERT INTO courses VALUES('ETIF15','Medicinsk signalbehandling','eit','G2',7.5);
INSERT INTO courses VALUES('ETIN10','Kanalmodellering för trådlös kommunikation','eit','A',7.5);
INSERT INTO courses VALUES('ETIN15','Radiosystem','eit','A',7.5);
INSERT INTO courses VALUES('ETIN20','Digital IC-konstruktion','eit','A',7.5);
INSERT INTO courses VALUES('ETIN35','IC-projekt 1','eit','A',7.5);
INSERT INTO courses VALUES('ETIN40','IC-projekt 2','eit','A',7.5);
INSERT INTO courses VALUES('ETIN45','DSP-design','eit','A',7.5);
INSERT INTO courses VALUES('ETIN55','Integrerade A/D och D/A omvandlare','eit','A',7.5);
INSERT INTO courses VALUES('ETIN60','Avancerade A/D och D/A omvandlare','eit','A',7.5);
INSERT INTO courses VALUES('ETIN70','Modern elektronik','eit','A',7.5);
INSERT INTO courses VALUES('ETIN80','Algoritmer i signalprocessorer - projektkurs','eit','A',7.5);
INSERT INTO courses VALUES('ETS052','Datorkommunikation','eit','G2',4.5);
INSERT INTO courses VALUES('ETS061','Simulering','eit','A',7.5);
INSERT INTO courses VALUES('ETS075','Kösystem','eit','G2',4.5);
INSERT INTO courses VALUES('ETS170','Kravhantering','eit','A',7.5);
INSERT INTO courses VALUES('ETS200','Programvarutestning','eit','A',7.5);
INSERT INTO courses VALUES('ETSA01','Ingenjörsprocessen för programvaruutveckling - metodik','eit','G1',5.0);
INSERT INTO courses VALUES('ETSA05','Ingenjörsprocessen för programvaruutveckling - samhällsaspekter','eit','G1',4.0);
INSERT INTO courses VALUES('ETSF01','Ingenjörsprocessen för programvaruutveckling - ekonomi och kvalitet','eit','G2',4.0);
INSERT INTO courses VALUES('ETSF10','Internetprotokoll','eit','G2',7.5);
INSERT INTO courses VALUES('ETSN01','Avancerad telekommunikation','eit','A',7.5);
INSERT INTO courses VALUES('ETSN05','Programvaruutveckling för stora system','eit','A',7.5);
INSERT INTO courses VALUES('ETT051','Digital kommunikation','eit','G2',7.5);
INSERT INTO courses VALUES('ETTN01','Digital kommunikation, fortsättningskurs','eit','A',7.5);
INSERT INTO courses VALUES('ETTN05','Adaptiv signalbehandling','eit','A',7.5);
INSERT INTO courses VALUES('ETTN10','Optimal signalbehandling','eit','A',7.5);
INSERT INTO courses VALUES('ETTN15','Moderna trådlösa system - LTE och dess efterföljare','eit','A',7.5);
INSERT INTO courses VALUES('EXTA10','Introduktion till Kinas samhällsliv, kultur och språk','sol','G1',3.0);
INSERT INTO courses VALUES('EXTA35','Introduktionskurs i kinesiska för civilingenjörer','sol','G1',15.0);
INSERT INTO courses VALUES('EXTF60','Introduktionskurs i kinesiska för civilingenjörer, del 2','sol','G2',15.0);
INSERT INTO courses VALUES('FAF150','Medicinsk optik','faf','A',7.5);
INSERT INTO courses VALUES('FAFF20','Multispektral avbildning','faf','G2',7.5);
INSERT INTO courses VALUES('FAFF25','Fysik','faf','G2',11.0);
INSERT INTO courses VALUES('FMA021','Kontinuerliga system','fma','A',7.5);
INSERT INTO courses VALUES('FMA051','Optimering','fma','A',6.0);
INSERT INTO courses VALUES('FMA091','Diskret matematik','fma','G1',6.0);
INSERT INTO courses VALUES('FMA111','Matematiska strukturer','fma','A',6.0);
INSERT INTO courses VALUES('FMA120','Matristeori','fma','A',6.0);
INSERT INTO courses VALUES('FMA125','Matristeori, projektdel','fma','A',3.0);
INSERT INTO courses VALUES('FMA135','Geometri','fma','G1',6.0);
INSERT INTO courses VALUES('FMA140','Olinjära dynamiska system','fma','A',6.0);
INSERT INTO courses VALUES('FMA145','Olinjära dynamiska system, projektdel','fma','A',3.0);
INSERT INTO courses VALUES('FMA170','Bildanalys','fma','A',6.0);
INSERT INTO courses VALUES('FMA175','Bildanalys, projektdel','fma','A',3.0);
INSERT INTO courses VALUES('FMA200','Variationskalkyl','fma','A',6.0);
INSERT INTO courses VALUES('FMA240','Linjär och kombinatorisk optimering','fma','G2',6.0);
INSERT INTO courses VALUES('FMA270','Datorseende','fma','A',6.0);
INSERT INTO courses VALUES('FMA272','Datorseende, projektdel','fma','A',3.0);
INSERT INTO courses VALUES('FMA420','Linjär algebra','fma','G1',6.0);
INSERT INTO courses VALUES('FMA430','Flerdimensionell analys','fma','G1',6.0);
INSERT INTO courses VALUES('FMAA01','Endimensionell analys','fma','G1',15.0);
INSERT INTO courses VALUES('FMAF01','Matematik - Funktionsteori','fma','G2',7.0);
INSERT INTO courses VALUES('FMAF05','Matematik - System och transformer','fma','G2',7.0);
INSERT INTO courses VALUES('FMAF10','Tillämpad matematik - Linjära system','fma','G2',5.0);
INSERT INTO courses VALUES('FMAN10','Algebraiska strukturer','fma','A',7.5);
INSERT INTO courses VALUES('FMI040','Energisystemanalys: Förnybara energikällor','fmi','A',7.5);
INSERT INTO courses VALUES('FMI050','Energisystemanalys: energi, miljö och naturresurser','fmi','A',7.5);
INSERT INTO courses VALUES('FMIF15','Teknisk miljövetenskap','fmi','G2',7.5);
INSERT INTO courses VALUES('FMN011','Numerisk analys','fma','G2',6.0);
INSERT INTO courses VALUES('FMN100','Numeriska metoder för datorgrafik','fma','A',6.0);
INSERT INTO courses VALUES('FMNN05','Simuleringsverktyg','fma','A',7.5);
INSERT INTO courses VALUES('FMNN25','Avancerad kurs i numeriska algoritmer med Python/SciPy','fma','A',7.5);
INSERT INTO courses VALUES('FMS012','Matematisk statistik, allmän kurs','fms','G2',9.0);
INSERT INTO courses VALUES('FMS051','Matematisk statistik, tidsserieanalys','fms','A',7.5);
INSERT INTO courses VALUES('FMS072','Försöksplanering','fms','G2',7.5);
INSERT INTO courses VALUES('FMS091','Monte Carlo-baserade statistiska metoder','fms','A',7.5);
INSERT INTO courses VALUES('FMS110','Olinjära tidsserier','fms','A',7.5);
INSERT INTO courses VALUES('FMS155','Statistisk modellering av extremvärden','fms','A',7.5);
INSERT INTO courses VALUES('FMSF10','Stationära stokastiska processer','fms','G2',7.5);
INSERT INTO courses VALUES('FMSF15','Markovprocesser','fms','G2',7.5);
INSERT INTO courses VALUES('FMSN20','Spatial statistik med bildanalys','fms','A',7.5);
INSERT INTO courses VALUES('FMSN30','Linjär och logistisk regression','fms','A',7.5);
INSERT INTO courses VALUES('FMSN35','Stationär och icke-stationär spektralanalys','fms','A',7.5);
INSERT INTO courses VALUES('FRT010','Reglerteknik, allmän kurs','frt','G2',7.5);
INSERT INTO courses VALUES('FRT041','Systemidentifiering','frt','A',7.5);
INSERT INTO courses VALUES('FRT090','Projekt i reglerteknik','frt','A',7.5);
INSERT INTO courses VALUES('FRT130','Reglerteori','frt','G2',3.0);
INSERT INTO courses VALUES('FRTN01','Realtidssystem','frt','A',10.0);
INSERT INTO courses VALUES('FRTN05','Olinjär reglering och servosystem','frt','A',7.5);
INSERT INTO courses VALUES('FRTN10','Flervariabel reglering','frt','A',7.5);
INSERT INTO courses VALUES('FRTN15','Prediktiv reglering','frt','A',7.5);
INSERT INTO courses VALUES('GEMA01','Franska för tekniker: språk, kultur och samhällsliv, grundkurs','sol','G1',7.5);
INSERT INTO courses VALUES('GEMA20','Engelska för tekniker','sol','G1',7.5);
INSERT INTO courses VALUES('GEMA25','Tyska för tekniker','sol','G1',7.5);
INSERT INTO courses VALUES('GEMA40','Entreprenörskap och affärsutveckling','sol','G1',7.5);
INSERT INTO courses VALUES('GEMA45','Förståelse och lärande','sol','G1',3.0);
INSERT INTO courses VALUES('GEMA50','Teknikhistoria','sol','G1',4.5);
INSERT INTO courses VALUES('GEMA55','Medicin för tekniker','sol','G1',6.0);
INSERT INTO courses VALUES('GEMA60','Juridik för tekniker','sol','G1',7.5);
INSERT INTO courses VALUES('GEMA65','Kinesiska för tekniker','sol','G1',7.5);
INSERT INTO courses VALUES('GEMA70','Japanska för tekniker','sol','G1',15.0);
INSERT INTO courses VALUES('KII010','Industriellt miljöarbete','kii','G2',7.5);
INSERT INTO courses VALUES('MAM032','Arbete-människa-teknik, projekt','mam','A',7.5);
INSERT INTO courses VALUES('MAM101','Virtual Reality i teori och praktik','mam','G2',7.5);
INSERT INTO courses VALUES('MAM120','Användbarhetsutvärdering','mam','G2',7.5);
INSERT INTO courses VALUES('MAMF15','Arbetsorganisation och ledarskap','mam','G2',6.0);
INSERT INTO courses VALUES('MAMN01','Avancerad interaktionsdesign','mam','A',7.5);
INSERT INTO courses VALUES('MAMN10','Interaktion 1: Neuromodellering, kognitiv robotik och agenter','mam','A',7.5);
INSERT INTO courses VALUES('MAMN15','Interaktion 2: Virtualitet och kognitiv modellering','mam','A',7.5);
INSERT INTO courses VALUES('MAMN25','Interaktionsdesign','mam','A',7.5);
INSERT INTO courses VALUES('MIE080','Automation','mie','G2',7.5);
INSERT INTO courses VALUES('MIE090','Automation för komplexa system','mie','A',7.5);
INSERT INTO courses VALUES('MIO012','Industriell ekonomi, allmän kurs','mio','G1',6.0);
INSERT INTO courses VALUES('MIO022','Företagsorganisation','mio','G2',6.0);
INSERT INTO courses VALUES('MIO040','Industriell ekonomi, fortsättningskurs','mio','G2',6.0);
INSERT INTO courses VALUES('MIOA01','Industriell ekonomi, allmän kurs','mio','G1',9.0);
INSERT INTO courses VALUES('MMKF15','Tillämpad robotteknik','frt','G2',7.5);
INSERT INTO courses VALUES('TEK210','Kognition','tek','G1',4.5);
INSERT INTO courses VALUES('TEK280','Teknikstödd kommunikation','tek','G2',7.5);
INSERT INTO courses VALUES('TNX097','Rehabiliteringsteknik','mam','G2',7.5);
INSERT INTO courses VALUES('TNX153','Rehabiliteringsteknik och design','mam','G2',7.5);
DROP TABLE IF EXISTS finished_courses;
CREATE TABLE finished_courses (
  ssn           CHAR(11),
  course_code   CHAR(6),
  grade         INTEGER NOT NULL CHECK (grade >= 3 AND grade <= 5),
  PRIMARY KEY   (ssn, course_code),
  FOREIGN KEY   (ssn) REFERENCES students(ssn),
  FOREIGN KEY   (course_code) REFERENCES courses(course_code)
);
INSERT INTO finished_courses VALUES('19950705-2308','EITN35',5);
INSERT INTO finished_courses VALUES('19950705-2308','ESS050',3);
INSERT INTO finished_courses VALUES('19950705-2308','ETIN70',4);
INSERT INTO finished_courses VALUES('19950705-2308','FMA140',4);
INSERT INTO finished_courses VALUES('19950705-2308','MAM032',5);
INSERT INTO finished_courses VALUES('19930702-3582','EDA040',4);
INSERT INTO finished_courses VALUES('19930702-3582','EDA180',4);
INSERT INTO finished_courses VALUES('19930702-3582','EDAF75',4);
INSERT INTO finished_courses VALUES('19930702-3582','EDA260',5);
INSERT INTO finished_courses VALUES('19930702-3582','EDA385',3);
INSERT INTO finished_courses VALUES('19930702-3582','EDAF10',4);
INSERT INTO finished_courses VALUES('19930702-3582','EDAN15',5);
INSERT INTO finished_courses VALUES('19930702-3582','EDAN40',3);
INSERT INTO finished_courses VALUES('19930702-3582','EDAN60',3);
INSERT INTO finished_courses VALUES('19930702-3582','EEMN10',4);
INSERT INTO finished_courses VALUES('19930702-3582','EIT140',5);
INSERT INTO finished_courses VALUES('19930702-3582','EITF01',5);
INSERT INTO finished_courses VALUES('19930702-3582','EITN35',5);
INSERT INTO finished_courses VALUES('19930702-3582','ESSF10',5);
INSERT INTO finished_courses VALUES('19930702-3582','ETIA01',4);
INSERT INTO finished_courses VALUES('19930702-3582','ETIF10',5);
INSERT INTO finished_courses VALUES('19930702-3582','ETIN60',3);
INSERT INTO finished_courses VALUES('19930702-3582','ETSF10',4);
INSERT INTO finished_courses VALUES('19930702-3582','ETT051',4);
INSERT INTO finished_courses VALUES('19930702-3582','ETTN15',4);
INSERT INTO finished_courses VALUES('19930702-3582','FAF150',4);
INSERT INTO finished_courses VALUES('19930702-3582','FMA021',5);
INSERT INTO finished_courses VALUES('19930702-3582','FMA091',5);
INSERT INTO finished_courses VALUES('19930702-3582','FMA125',5);
INSERT INTO finished_courses VALUES('19930702-3582','FMA140',4);
INSERT INTO finished_courses VALUES('19930702-3582','FMAN10',5);
INSERT INTO finished_courses VALUES('19930702-3582','FMI040',5);
INSERT INTO finished_courses VALUES('19930702-3582','FMI050',5);
INSERT INTO finished_courses VALUES('19930702-3582','FMS091',3);
INSERT INTO finished_courses VALUES('19930702-3582','FMSF10',5);
INSERT INTO finished_courses VALUES('19930702-3582','FRTN01',3);
INSERT INTO finished_courses VALUES('19930702-3582','FRTN10',5);
INSERT INTO finished_courses VALUES('19930702-3582','GEMA20',3);
INSERT INTO finished_courses VALUES('19930702-3582','GEMA25',3);
INSERT INTO finished_courses VALUES('19930702-3582','GEMA40',4);
INSERT INTO finished_courses VALUES('19930702-3582','GEMA50',5);
INSERT INTO finished_courses VALUES('19930702-3582','GEMA70',5);
INSERT INTO finished_courses VALUES('19930702-3582','MAMN01',3);
INSERT INTO finished_courses VALUES('19930702-3582','MIE080',5);
INSERT INTO finished_courses VALUES('19911212-1746','EDA260',5);
INSERT INTO finished_courses VALUES('19911212-1746','EDAA25',3);
INSERT INTO finished_courses VALUES('19911212-1746','EDAF10',4);
INSERT INTO finished_courses VALUES('19911212-1746','EDAN01',5);
INSERT INTO finished_courses VALUES('19911212-1746','EDAN55',5);
INSERT INTO finished_courses VALUES('19911212-1746','EDAN60',3);
INSERT INTO finished_courses VALUES('19911212-1746','EDIN05',4);
INSERT INTO finished_courses VALUES('19911212-1746','EEMF05',5);
INSERT INTO finished_courses VALUES('19911212-1746','EEMN01',4);
INSERT INTO finished_courses VALUES('19911212-1746','EIT140',5);
INSERT INTO finished_courses VALUES('19911212-1746','EITF05',5);
INSERT INTO finished_courses VALUES('19911212-1746','ETIF15',5);
INSERT INTO finished_courses VALUES('19911212-1746','ETIN20',3);
INSERT INTO finished_courses VALUES('19911212-1746','ETS052',3);
INSERT INTO finished_courses VALUES('19911212-1746','ETS061',3);
INSERT INTO finished_courses VALUES('19911212-1746','ETSA05',3);
INSERT INTO finished_courses VALUES('19911212-1746','ETSN05',3);
INSERT INTO finished_courses VALUES('19911212-1746','ETTN01',3);
INSERT INTO finished_courses VALUES('19911212-1746','FAFF25',5);
INSERT INTO finished_courses VALUES('19911212-1746','FMIF15',3);
INSERT INTO finished_courses VALUES('19911212-1746','FMS155',4);
INSERT INTO finished_courses VALUES('19911212-1746','GEMA25',4);
INSERT INTO finished_courses VALUES('19911212-1746','GEMA55',4);
INSERT INTO finished_courses VALUES('19911212-1746','GEMA65',3);
INSERT INTO finished_courses VALUES('19911212-1746','MMKF15',5);
INSERT INTO finished_courses VALUES('19911212-1746','TEK280',4);
INSERT INTO finished_courses VALUES('19910707-3787','EDAN15',4);
INSERT INTO finished_courses VALUES('19910707-3787','ETSN01',3);
INSERT INTO finished_courses VALUES('19910707-3787','FMNN05',3);
INSERT INTO finished_courses VALUES('19910707-3787','MIO022',3);
INSERT INTO finished_courses VALUES('19931213-2824','EDA050',4);
INSERT INTO finished_courses VALUES('19931213-2824','EDA070',5);
INSERT INTO finished_courses VALUES('19931213-2824','EDAF05',5);
INSERT INTO finished_courses VALUES('19931213-2824','EDAN20',3);
INSERT INTO finished_courses VALUES('19931213-2824','EDAN60',4);
INSERT INTO finished_courses VALUES('19931213-2824','EEMN10',5);
INSERT INTO finished_courses VALUES('19931213-2824','EITN10',5);
INSERT INTO finished_courses VALUES('19931213-2824','ETIN45',5);
INSERT INTO finished_courses VALUES('19931213-2824','ETTN01',3);
INSERT INTO finished_courses VALUES('19931213-2824','ETTN05',5);
INSERT INTO finished_courses VALUES('19931213-2824','FMA125',5);
INSERT INTO finished_courses VALUES('19931213-2824','FMA240',4);
INSERT INTO finished_courses VALUES('19931213-2824','FMAF05',4);
INSERT INTO finished_courses VALUES('19931213-2824','FMAN10',3);
INSERT INTO finished_courses VALUES('19931213-2824','GEMA01',4);
INSERT INTO finished_courses VALUES('19931213-2824','MAM032',3);
INSERT INTO finished_courses VALUES('19931213-2824','MAM120',5);
INSERT INTO finished_courses VALUES('19951122-1048','EDAN20',4);
INSERT INTO finished_courses VALUES('19951122-1048','EDAN60',5);
INSERT INTO finished_courses VALUES('19951122-1048','ETIA01',3);
INSERT INTO finished_courses VALUES('19951122-1048','ETIF05',3);
INSERT INTO finished_courses VALUES('19951122-1048','ETIN10',5);
INSERT INTO finished_courses VALUES('19951122-1048','ETT051',3);
INSERT INTO finished_courses VALUES('19951122-1048','FMA240',4);
INSERT INTO finished_courses VALUES('19951122-1048','FMA430',4);
INSERT INTO finished_courses VALUES('19951122-1048','FMIF15',4);
INSERT INTO finished_courses VALUES('19951122-1048','FMS012',3);
INSERT INTO finished_courses VALUES('19951122-1048','FMS072',3);
INSERT INTO finished_courses VALUES('19951122-1048','MAM120',3);
INSERT INTO finished_courses VALUES('19951122-1048','MAMF15',4);
INSERT INTO finished_courses VALUES('19951122-1048','MIE080',3);
INSERT INTO finished_courses VALUES('19951122-1048','TNX153',4);
INSERT INTO finished_courses VALUES('19910308-1826','EDA040',3);
INSERT INTO finished_courses VALUES('19910308-1826','EDA385',4);
INSERT INTO finished_courses VALUES('19910308-1826','EDAN60',5);
INSERT INTO finished_courses VALUES('19910308-1826','EITF35',5);
INSERT INTO finished_courses VALUES('19910308-1826','ESS030',4);
INSERT INTO finished_courses VALUES('19910308-1826','ETIN15',4);
INSERT INTO finished_courses VALUES('19910308-1826','ETSA01',5);
INSERT INTO finished_courses VALUES('19910308-1826','FMA021',5);
INSERT INTO finished_courses VALUES('19910308-1826','FMA091',5);
INSERT INTO finished_courses VALUES('19910308-1826','FMA120',5);
INSERT INTO finished_courses VALUES('19910308-1826','FMA145',3);
INSERT INTO finished_courses VALUES('19910308-1826','FRT010',3);
INSERT INTO finished_courses VALUES('19910308-1826','FRTN05',5);
INSERT INTO finished_courses VALUES('19941003-1225','EDA095',5);
INSERT INTO finished_courses VALUES('19941003-1225','EDA180',3);
INSERT INTO finished_courses VALUES('19941003-1225','EDAN10',3);
INSERT INTO finished_courses VALUES('19941003-1225','FRT010',3);
INSERT INTO finished_courses VALUES('19941003-1225','FRT041',3);
INSERT INTO finished_courses VALUES('19941003-1225','FRTN15',3);
INSERT INTO finished_courses VALUES('19941003-1225','GEMA20',5);
INSERT INTO finished_courses VALUES('19860819-2864','EDAF15',5);
INSERT INTO finished_courses VALUES('19860819-2864','EDAN55',4);
INSERT INTO finished_courses VALUES('19860819-2864','EDI042',3);
INSERT INTO finished_courses VALUES('19860819-2864','EIE061',5);
INSERT INTO finished_courses VALUES('19860819-2864','EIT070',4);
INSERT INTO finished_courses VALUES('19860819-2864','ESS050',4);
INSERT INTO finished_courses VALUES('19860819-2864','ETIN55',4);
INSERT INTO finished_courses VALUES('19860819-2864','ETTN10',4);
INSERT INTO finished_courses VALUES('19860819-2864','FAFF25',5);
INSERT INTO finished_courses VALUES('19860819-2864','FMA021',3);
INSERT INTO finished_courses VALUES('19860819-2864','FMA140',5);
INSERT INTO finished_courses VALUES('19860819-2864','FMI050',3);
INSERT INTO finished_courses VALUES('19860819-2864','FMN100',5);
INSERT INTO finished_courses VALUES('19860819-2864','FMS072',4);
INSERT INTO finished_courses VALUES('19860819-2864','FMS091',5);
INSERT INTO finished_courses VALUES('19860819-2864','FRT010',4);
INSERT INTO finished_courses VALUES('19860819-2864','FRTN05',4);
INSERT INTO finished_courses VALUES('19860819-2864','GEMA20',3);
INSERT INTO finished_courses VALUES('19860819-2864','MAM101',5);
INSERT INTO finished_courses VALUES('19870915-2742','EDA031',4);
INSERT INTO finished_courses VALUES('19870915-2742','EDA132',4);
INSERT INTO finished_courses VALUES('19870915-2742','EDA270',4);
INSERT INTO finished_courses VALUES('19870915-2742','EDAN10',4);
INSERT INTO finished_courses VALUES('19870915-2742','EIEN01',5);
INSERT INTO finished_courses VALUES('19870915-2742','EITF01',4);
INSERT INTO finished_courses VALUES('19870915-2742','EITF05',3);
INSERT INTO finished_courses VALUES('19870915-2742','EITN30',5);
INSERT INTO finished_courses VALUES('19870915-2742','ESS030',5);
INSERT INTO finished_courses VALUES('19870915-2742','ETIF10',3);
INSERT INTO finished_courses VALUES('19870915-2742','ETIN35',5);
INSERT INTO finished_courses VALUES('19870915-2742','ETIN55',3);
INSERT INTO finished_courses VALUES('19870915-2742','ETIN60',3);
INSERT INTO finished_courses VALUES('19870915-2742','ETSA05',5);
INSERT INTO finished_courses VALUES('19870915-2742','ETSF01',5);
INSERT INTO finished_courses VALUES('19870915-2742','ETSN01',4);
INSERT INTO finished_courses VALUES('19870915-2742','ETTN10',4);
INSERT INTO finished_courses VALUES('19870915-2742','FMA021',4);
INSERT INTO finished_courses VALUES('19870915-2742','FMA170',4);
INSERT INTO finished_courses VALUES('19870915-2742','FMA200',4);
INSERT INTO finished_courses VALUES('19870915-2742','FMI040',3);
INSERT INTO finished_courses VALUES('19870915-2742','FMNN05',5);
INSERT INTO finished_courses VALUES('19870915-2742','FMS012',5);
INSERT INTO finished_courses VALUES('19870915-2742','FMSN20',5);
INSERT INTO finished_courses VALUES('19870915-2742','FRT010',3);
INSERT INTO finished_courses VALUES('19870915-2742','FRTN01',3);
INSERT INTO finished_courses VALUES('19870915-2742','GEMA45',4);
INSERT INTO finished_courses VALUES('19870915-2742','GEMA50',3);
INSERT INTO finished_courses VALUES('19870915-2742','GEMA55',3);
INSERT INTO finished_courses VALUES('19870915-2742','KII010',4);
INSERT INTO finished_courses VALUES('19870915-2742','MAMN10',4);
INSERT INTO finished_courses VALUES('19870915-2742','MAMN15',4);
INSERT INTO finished_courses VALUES('19870915-2742','MAMN25',5);
INSERT INTO finished_courses VALUES('19870915-2742','MIE090',3);
INSERT INTO finished_courses VALUES('19870915-2742','MMKF15',5);
INSERT INTO finished_courses VALUES('19870915-2742','TEK280',4);
INSERT INTO finished_courses VALUES('19900227-2369','EDA050',3);
INSERT INTO finished_courses VALUES('19900227-2369','EDA180',5);
INSERT INTO finished_courses VALUES('19900227-2369','EDA230',5);
INSERT INTO finished_courses VALUES('19900227-2369','EDA260',5);
INSERT INTO finished_courses VALUES('19900227-2369','EDAA01',4);
INSERT INTO finished_courses VALUES('19900227-2369','EDIN05',4);
INSERT INTO finished_courses VALUES('19900227-2369','EIT060',5);
INSERT INTO finished_courses VALUES('19900227-2369','EITF05',4);
INSERT INTO finished_courses VALUES('19900227-2369','EITF20',3);
INSERT INTO finished_courses VALUES('19900227-2369','EITN50',4);
INSERT INTO finished_courses VALUES('19900227-2369','ETIF10',3);
INSERT INTO finished_courses VALUES('19900227-2369','ETIN15',5);
INSERT INTO finished_courses VALUES('19900227-2369','ETIN45',3);
INSERT INTO finished_courses VALUES('19900227-2369','ETIN55',5);
INSERT INTO finished_courses VALUES('19900227-2369','ETIN60',5);
INSERT INTO finished_courses VALUES('19900227-2369','ETS170',3);
INSERT INTO finished_courses VALUES('19900227-2369','ETSA01',4);
INSERT INTO finished_courses VALUES('19900227-2369','ETSA05',4);
INSERT INTO finished_courses VALUES('19900227-2369','ETSN05',4);
INSERT INTO finished_courses VALUES('19900227-2369','ETTN05',3);
INSERT INTO finished_courses VALUES('19900227-2369','FMA021',3);
INSERT INTO finished_courses VALUES('19900227-2369','FMA051',3);
INSERT INTO finished_courses VALUES('19900227-2369','FMA270',3);
INSERT INTO finished_courses VALUES('19900227-2369','FMAF10',3);
INSERT INTO finished_courses VALUES('19900227-2369','FMS012',4);
INSERT INTO finished_courses VALUES('19900227-2369','FMS110',5);
INSERT INTO finished_courses VALUES('19900227-2369','FMSF10',3);
INSERT INTO finished_courses VALUES('19900227-2369','FMSF15',3);
INSERT INTO finished_courses VALUES('19900227-2369','FMSN20',5);
INSERT INTO finished_courses VALUES('19900227-2369','FRTN05',4);
INSERT INTO finished_courses VALUES('19900227-2369','GEMA25',4);
INSERT INTO finished_courses VALUES('19900227-2369','GEMA50',5);
INSERT INTO finished_courses VALUES('19900227-2369','GEMA70',4);
INSERT INTO finished_courses VALUES('19900227-2369','MAM101',4);
INSERT INTO finished_courses VALUES('19900227-2369','MAMF15',4);
INSERT INTO finished_courses VALUES('19900227-2369','MIO040',5);
INSERT INTO finished_courses VALUES('19900227-2369','MIOA01',5);
INSERT INTO finished_courses VALUES('19931208-3605','EDA050',5);
INSERT INTO finished_courses VALUES('19931208-3605','EDAF75',4);
INSERT INTO finished_courses VALUES('19931208-3605','EDA270',4);
INSERT INTO finished_courses VALUES('19931208-3605','EDAF01',5);
INSERT INTO finished_courses VALUES('19931208-3605','EDAN25',3);
INSERT INTO finished_courses VALUES('19931208-3605','EIT020',5);
INSERT INTO finished_courses VALUES('19931208-3605','EITN35',4);
INSERT INTO finished_courses VALUES('19931208-3605','EITN45',3);
INSERT INTO finished_courses VALUES('19931208-3605','EITN50',5);
INSERT INTO finished_courses VALUES('19931208-3605','ETIF10',3);
INSERT INTO finished_courses VALUES('19931208-3605','ETIN10',5);
INSERT INTO finished_courses VALUES('19931208-3605','ETIN15',5);
INSERT INTO finished_courses VALUES('19931208-3605','ETIN20',4);
INSERT INTO finished_courses VALUES('19931208-3605','ETIN80',3);
INSERT INTO finished_courses VALUES('19931208-3605','ETSN01',5);
INSERT INTO finished_courses VALUES('19931208-3605','EXTA10',4);
INSERT INTO finished_courses VALUES('19931208-3605','EXTA35',4);
INSERT INTO finished_courses VALUES('19931208-3605','FMA270',5);
INSERT INTO finished_courses VALUES('19931208-3605','FMNN05',3);
INSERT INTO finished_courses VALUES('19931208-3605','FMS110',5);
INSERT INTO finished_courses VALUES('19931208-3605','FMS155',5);
INSERT INTO finished_courses VALUES('19931208-3605','FMSN20',3);
INSERT INTO finished_courses VALUES('19931208-3605','FMSN30',3);
INSERT INTO finished_courses VALUES('19931208-3605','GEMA01',5);
INSERT INTO finished_courses VALUES('19931208-3605','GEMA25',4);
INSERT INTO finished_courses VALUES('19931208-3605','GEMA50',4);
INSERT INTO finished_courses VALUES('19931208-3605','GEMA65',5);
INSERT INTO finished_courses VALUES('19931208-3605','MAMN10',5);
INSERT INTO finished_courses VALUES('19931208-3605','MAMN25',5);
INSERT INTO finished_courses VALUES('19931208-3605','MIE090',4);
INSERT INTO finished_courses VALUES('19931208-3605','TEK210',5);
INSERT INTO finished_courses VALUES('19931208-3605','TNX097',3);
INSERT INTO finished_courses VALUES('19951004-2346','EDA095',4);
INSERT INTO finished_courses VALUES('19951004-2346','EDA260',5);
INSERT INTO finished_courses VALUES('19951004-2346','EDAA05',4);
INSERT INTO finished_courses VALUES('19951004-2346','EDAF10',4);
INSERT INTO finished_courses VALUES('19951004-2346','EDAN15',5);
INSERT INTO finished_courses VALUES('19951004-2346','EDAN20',5);
INSERT INTO finished_courses VALUES('19951004-2346','EDAN40',4);
INSERT INTO finished_courses VALUES('19951004-2346','EDAN55',4);
INSERT INTO finished_courses VALUES('19951004-2346','EDIN05',5);
INSERT INTO finished_courses VALUES('19951004-2346','EIE061',5);
INSERT INTO finished_courses VALUES('19951004-2346','EIEF01',3);
INSERT INTO finished_courses VALUES('19951004-2346','EIEN01',5);
INSERT INTO finished_courses VALUES('19951004-2346','EIT070',3);
INSERT INTO finished_courses VALUES('19951004-2346','EIT140',4);
INSERT INTO finished_courses VALUES('19951004-2346','EITF35',3);
INSERT INTO finished_courses VALUES('19951004-2346','EITF40',5);
INSERT INTO finished_courses VALUES('19951004-2346','EITN10',4);
INSERT INTO finished_courses VALUES('19951004-2346','ETI265',5);
INSERT INTO finished_courses VALUES('19951004-2346','ETIN10',5);
INSERT INTO finished_courses VALUES('19951004-2346','ETIN45',5);
INSERT INTO finished_courses VALUES('19951004-2346','ETS200',5);
INSERT INTO finished_courses VALUES('19951004-2346','ETSF10',4);
INSERT INTO finished_courses VALUES('19951004-2346','ETSN01',4);
INSERT INTO finished_courses VALUES('19951004-2346','ETSN05',3);
INSERT INTO finished_courses VALUES('19951004-2346','ETT051',5);
INSERT INTO finished_courses VALUES('19951004-2346','EXTF60',3);
INSERT INTO finished_courses VALUES('19951004-2346','FAFF20',3);
INSERT INTO finished_courses VALUES('19951004-2346','FMA091',4);
INSERT INTO finished_courses VALUES('19951004-2346','FMAF05',5);
INSERT INTO finished_courses VALUES('19951004-2346','FMI040',3);
INSERT INTO finished_courses VALUES('19951004-2346','FMIF15',5);
INSERT INTO finished_courses VALUES('19951004-2346','FMNN05',3);
INSERT INTO finished_courses VALUES('19951004-2346','FMS091',5);
INSERT INTO finished_courses VALUES('19951004-2346','FMS110',3);
INSERT INTO finished_courses VALUES('19951004-2346','FMSF15',3);
INSERT INTO finished_courses VALUES('19951004-2346','FMSN30',3);
INSERT INTO finished_courses VALUES('19951004-2346','FRT010',3);
INSERT INTO finished_courses VALUES('19951004-2346','FRTN15',5);
INSERT INTO finished_courses VALUES('19951004-2346','GEMA25',4);
INSERT INTO finished_courses VALUES('19951004-2346','GEMA65',4);
INSERT INTO finished_courses VALUES('19951004-2346','MAM101',4);
INSERT INTO finished_courses VALUES('19951004-2346','MAMN10',3);
INSERT INTO finished_courses VALUES('19951004-2346','MIO012',5);
INSERT INTO finished_courses VALUES('19951004-2346','MIO022',3);
INSERT INTO finished_courses VALUES('19951004-2346','MMKF15',5);
INSERT INTO finished_courses VALUES('19951004-2346','TNX097',5);
INSERT INTO finished_courses VALUES('19910915-2068','EDA031',4);
INSERT INTO finished_courses VALUES('19910915-2068','EDA040',5);
INSERT INTO finished_courses VALUES('19910915-2068','EDA221',5);
INSERT INTO finished_courses VALUES('19910915-2068','EDA230',5);
INSERT INTO finished_courses VALUES('19910915-2068','EDA260',4);
INSERT INTO finished_courses VALUES('19910915-2068','EDA385',5);
INSERT INTO finished_courses VALUES('19910915-2068','EDAA25',3);
INSERT INTO finished_courses VALUES('19910915-2068','EDAF01',4);
INSERT INTO finished_courses VALUES('19910915-2068','EDAF05',4);
INSERT INTO finished_courses VALUES('19910915-2068','EDAN01',3);
INSERT INTO finished_courses VALUES('19910915-2068','EDAN15',4);
INSERT INTO finished_courses VALUES('19910915-2068','EDAN35',4);
INSERT INTO finished_courses VALUES('19910915-2068','EDAN40',5);
INSERT INTO finished_courses VALUES('19910915-2068','EDAN50',5);
INSERT INTO finished_courses VALUES('19910915-2068','EDIN01',4);
INSERT INTO finished_courses VALUES('19910915-2068','EITF05',4);
INSERT INTO finished_courses VALUES('19910915-2068','EITF20',4);
INSERT INTO finished_courses VALUES('19910915-2068','ETIF05',4);
INSERT INTO finished_courses VALUES('19910915-2068','ETIN10',3);
INSERT INTO finished_courses VALUES('19910915-2068','ETIN15',3);
INSERT INTO finished_courses VALUES('19910915-2068','ETS052',3);
INSERT INTO finished_courses VALUES('19910915-2068','ETS170',5);
INSERT INTO finished_courses VALUES('19910915-2068','ETSF10',5);
INSERT INTO finished_courses VALUES('19910915-2068','FAFF20',4);
INSERT INTO finished_courses VALUES('19910915-2068','FMA091',3);
INSERT INTO finished_courses VALUES('19910915-2068','FMA125',5);
INSERT INTO finished_courses VALUES('19910915-2068','FMA170',5);
INSERT INTO finished_courses VALUES('19910915-2068','FMA200',5);
INSERT INTO finished_courses VALUES('19910915-2068','FMA240',5);
INSERT INTO finished_courses VALUES('19910915-2068','FMA270',3);
INSERT INTO finished_courses VALUES('19910915-2068','FMAF05',5);
INSERT INTO finished_courses VALUES('19910915-2068','FMI050',3);
INSERT INTO finished_courses VALUES('19910915-2068','FMS091',5);
INSERT INTO finished_courses VALUES('19910915-2068','FMS155',3);
INSERT INTO finished_courses VALUES('19910915-2068','FMSF10',4);
INSERT INTO finished_courses VALUES('19910915-2068','FMSN20',3);
INSERT INTO finished_courses VALUES('19910915-2068','FMSN30',4);
INSERT INTO finished_courses VALUES('19910915-2068','FRTN01',4);
INSERT INTO finished_courses VALUES('19910915-2068','GEMA40',3);
INSERT INTO finished_courses VALUES('19910915-2068','GEMA70',4);
INSERT INTO finished_courses VALUES('19910915-2068','MAM101',5);
INSERT INTO finished_courses VALUES('19910915-2068','MAMN15',4);
INSERT INTO finished_courses VALUES('19910915-2068','MAMN25',5);
INSERT INTO finished_courses VALUES('19910915-2068','MIE080',3);
INSERT INTO finished_courses VALUES('19910915-2068','MIE090',5);
INSERT INTO finished_courses VALUES('19910915-2068','MIOA01',4);
INSERT INTO finished_courses VALUES('19910915-2068','MMKF15',5);
INSERT INTO finished_courses VALUES('19910915-2068','TEK280',5);
INSERT INTO finished_courses VALUES('19860206-1065','EDA221',4);
INSERT INTO finished_courses VALUES('19860206-1065','EDAF10',5);
INSERT INTO finished_courses VALUES('19860206-1065','EDI042',4);
INSERT INTO finished_courses VALUES('19860206-1065','EITF01',4);
INSERT INTO finished_courses VALUES('19860206-1065','EITF05',3);
INSERT INTO finished_courses VALUES('19860206-1065','ESSF10',3);
INSERT INTO finished_courses VALUES('19860206-1065','ETS200',4);
INSERT INTO finished_courses VALUES('19860206-1065','ETSF01',4);
INSERT INTO finished_courses VALUES('19860206-1065','ETSN01',5);
INSERT INTO finished_courses VALUES('19860206-1065','EXTA10',4);
INSERT INTO finished_courses VALUES('19860206-1065','FMA135',3);
INSERT INTO finished_courses VALUES('19860206-1065','FMA170',4);
INSERT INTO finished_courses VALUES('19860206-1065','FMA175',4);
INSERT INTO finished_courses VALUES('19860206-1065','FMA430',3);
INSERT INTO finished_courses VALUES('19860206-1065','FMAA01',5);
INSERT INTO finished_courses VALUES('19860206-1065','FMI040',5);
INSERT INTO finished_courses VALUES('19860206-1065','FMS051',5);
INSERT INTO finished_courses VALUES('19860206-1065','FMS091',3);
INSERT INTO finished_courses VALUES('19860206-1065','FRT010',4);
INSERT INTO finished_courses VALUES('19860206-1065','FRT041',4);
INSERT INTO finished_courses VALUES('19860206-1065','MMKF15',4);
INSERT INTO finished_courses VALUES('19860206-1065','TEK280',5);
INSERT INTO finished_courses VALUES('19900528-1540','EDA050',3);
INSERT INTO finished_courses VALUES('19900528-1540','EDAN50',4);
INSERT INTO finished_courses VALUES('19900528-1540','EITN10',5);
INSERT INTO finished_courses VALUES('19900528-1540','FAFF20',5);
INSERT INTO finished_courses VALUES('19900528-1540','FMA120',5);
INSERT INTO finished_courses VALUES('19900528-1540','FMA135',3);
INSERT INTO finished_courses VALUES('19900528-1540','MAM032',4);
INSERT INTO finished_courses VALUES('19900528-1540','MAMN25',3);
INSERT INTO finished_courses VALUES('19900528-1540','MIO040',3);
INSERT INTO finished_courses VALUES('19900528-1540','TEK210',4);
INSERT INTO finished_courses VALUES('19930502-2040','EDA221',4);
INSERT INTO finished_courses VALUES('19930502-2040','EDAF10',4);
INSERT INTO finished_courses VALUES('19930502-2040','EDAN01',3);
INSERT INTO finished_courses VALUES('19930502-2040','EEM031',3);
INSERT INTO finished_courses VALUES('19930502-2040','EIT140',4);
INSERT INTO finished_courses VALUES('19930502-2040','ESS030',4);
INSERT INTO finished_courses VALUES('19930502-2040','ETIA01',3);
INSERT INTO finished_courses VALUES('19930502-2040','ETIA10',5);
INSERT INTO finished_courses VALUES('19930502-2040','ETIF10',3);
INSERT INTO finished_courses VALUES('19930502-2040','ETIF15',5);
INSERT INTO finished_courses VALUES('19930502-2040','ETIN55',5);
INSERT INTO finished_courses VALUES('19930502-2040','ETS200',5);
INSERT INTO finished_courses VALUES('19930502-2040','ETSF01',4);
INSERT INTO finished_courses VALUES('19930502-2040','ETSN01',4);
INSERT INTO finished_courses VALUES('19930502-2040','ETT051',5);
INSERT INTO finished_courses VALUES('19930502-2040','FMA051',5);
INSERT INTO finished_courses VALUES('19930502-2040','FMA125',3);
INSERT INTO finished_courses VALUES('19930502-2040','FMA135',5);
INSERT INTO finished_courses VALUES('19930502-2040','FMA430',4);
INSERT INTO finished_courses VALUES('19930502-2040','FMI040',5);
INSERT INTO finished_courses VALUES('19930502-2040','FMSF15',3);
INSERT INTO finished_courses VALUES('19930502-2040','FMSN20',5);
INSERT INTO finished_courses VALUES('19930502-2040','FRTN05',4);
INSERT INTO finished_courses VALUES('19930502-2040','GEMA45',3);
INSERT INTO finished_courses VALUES('19930502-2040','GEMA70',5);
INSERT INTO finished_courses VALUES('19930502-2040','MAM120',4);
INSERT INTO finished_courses VALUES('19930502-2040','MIO012',3);
INSERT INTO finished_courses VALUES('19950317-3520','EEMN10',4);
INSERT INTO finished_courses VALUES('19950317-3520','FMA051',4);
INSERT INTO finished_courses VALUES('19950317-3520','FMNN25',5);
INSERT INTO finished_courses VALUES('19950317-3520','FRT041',4);
INSERT INTO finished_courses VALUES('19950317-3520','GEMA60',4);
INSERT INTO finished_courses VALUES('19950317-3520','MAMN25',3);
INSERT INTO finished_courses VALUES('19891021-1287','EDA016',3);
INSERT INTO finished_courses VALUES('19891021-1287','EDA070',4);
INSERT INTO finished_courses VALUES('19891021-1287','EDA230',3);
INSERT INTO finished_courses VALUES('19891021-1287','EDAF05',3);
INSERT INTO finished_courses VALUES('19891021-1287','EDAN20',5);
INSERT INTO finished_courses VALUES('19891021-1287','EDIN05',3);
INSERT INTO finished_courses VALUES('19891021-1287','EEM031',3);
INSERT INTO finished_courses VALUES('19891021-1287','EEMF05',4);
INSERT INTO finished_courses VALUES('19891021-1287','EIEN01',5);
INSERT INTO finished_courses VALUES('19891021-1287','EIT070',5);
INSERT INTO finished_courses VALUES('19891021-1287','EIT140',4);
INSERT INTO finished_courses VALUES('19891021-1287','EITF05',4);
INSERT INTO finished_courses VALUES('19891021-1287','ETIN15',3);
INSERT INTO finished_courses VALUES('19891021-1287','ETIN40',4);
INSERT INTO finished_courses VALUES('19891021-1287','ETIN55',3);
INSERT INTO finished_courses VALUES('19891021-1287','ETS052',3);
INSERT INTO finished_courses VALUES('19891021-1287','ETS075',4);
INSERT INTO finished_courses VALUES('19891021-1287','ETS200',4);
INSERT INTO finished_courses VALUES('19891021-1287','ETSA05',3);
INSERT INTO finished_courses VALUES('19891021-1287','ETSF10',3);
INSERT INTO finished_courses VALUES('19891021-1287','ETTN05',4);
INSERT INTO finished_courses VALUES('19891021-1287','FAF150',3);
INSERT INTO finished_courses VALUES('19891021-1287','FMA170',3);
INSERT INTO finished_courses VALUES('19891021-1287','FMA272',4);
INSERT INTO finished_courses VALUES('19891021-1287','FMAA01',3);
INSERT INTO finished_courses VALUES('19891021-1287','FMAF01',5);
INSERT INTO finished_courses VALUES('19891021-1287','FMNN25',4);
INSERT INTO finished_courses VALUES('19891021-1287','FRT041',4);
INSERT INTO finished_courses VALUES('19891021-1287','FRT130',3);
INSERT INTO finished_courses VALUES('19891021-1287','FRTN10',3);
INSERT INTO finished_courses VALUES('19891021-1287','GEMA40',5);
INSERT INTO finished_courses VALUES('19891021-1287','GEMA65',3);
INSERT INTO finished_courses VALUES('19891021-1287','MAM032',3);
INSERT INTO finished_courses VALUES('19891021-1287','MAMN01',5);
INSERT INTO finished_courses VALUES('19891021-1287','MAMN10',3);
INSERT INTO finished_courses VALUES('19891021-1287','MIE080',4);
INSERT INTO finished_courses VALUES('19891021-1287','MIO012',4);
INSERT INTO finished_courses VALUES('19891021-1287','MIOA01',4);
INSERT INTO finished_courses VALUES('19891021-1287','TEK210',3);
INSERT INTO finished_courses VALUES('19880620-2564','EDA132',4);
INSERT INTO finished_courses VALUES('19880620-2564','EDA180',3);
INSERT INTO finished_courses VALUES('19880620-2564','EDA221',5);
INSERT INTO finished_courses VALUES('19880620-2564','EDA385',4);
INSERT INTO finished_courses VALUES('19880620-2564','EDAA25',3);
INSERT INTO finished_courses VALUES('19880620-2564','EDAF01',3);
INSERT INTO finished_courses VALUES('19880620-2564','EDAF10',4);
INSERT INTO finished_courses VALUES('19880620-2564','EDAN35',3);
INSERT INTO finished_courses VALUES('19880620-2564','EDAN40',3);
INSERT INTO finished_courses VALUES('19880620-2564','EDIN01',3);
INSERT INTO finished_courses VALUES('19880620-2564','EEMF05',4);
INSERT INTO finished_courses VALUES('19880620-2564','EEMN15',4);
INSERT INTO finished_courses VALUES('19880620-2564','EIT020',5);
INSERT INTO finished_courses VALUES('19880620-2564','EITF35',4);
INSERT INTO finished_courses VALUES('19880620-2564','ETIF10',5);
INSERT INTO finished_courses VALUES('19880620-2564','ETIN55',4);
INSERT INTO finished_courses VALUES('19880620-2564','ETS061',4);
INSERT INTO finished_courses VALUES('19880620-2564','ETSF10',5);
INSERT INTO finished_courses VALUES('19880620-2564','ETTN05',5);
INSERT INTO finished_courses VALUES('19880620-2564','ETTN15',4);
INSERT INTO finished_courses VALUES('19880620-2564','EXTA10',4);
INSERT INTO finished_courses VALUES('19880620-2564','EXTF60',4);
INSERT INTO finished_courses VALUES('19880620-2564','FMA051',5);
INSERT INTO finished_courses VALUES('19880620-2564','FMA125',4);
INSERT INTO finished_courses VALUES('19880620-2564','FMA140',4);
INSERT INTO finished_courses VALUES('19880620-2564','FMA200',4);
INSERT INTO finished_courses VALUES('19880620-2564','FMA272',4);
INSERT INTO finished_courses VALUES('19880620-2564','FMA420',5);
INSERT INTO finished_courses VALUES('19880620-2564','FMAF05',3);
INSERT INTO finished_courses VALUES('19880620-2564','FMN011',3);
INSERT INTO finished_courses VALUES('19880620-2564','FMNN05',3);
INSERT INTO finished_courses VALUES('19880620-2564','FMS072',5);
INSERT INTO finished_courses VALUES('19880620-2564','FMSF15',4);
INSERT INTO finished_courses VALUES('19880620-2564','FMSN20',3);
INSERT INTO finished_courses VALUES('19880620-2564','FRTN01',3);
INSERT INTO finished_courses VALUES('19880620-2564','FRTN05',4);
INSERT INTO finished_courses VALUES('19880620-2564','FRTN15',4);
INSERT INTO finished_courses VALUES('19880620-2564','GEMA01',4);
INSERT INTO finished_courses VALUES('19880620-2564','GEMA25',5);
INSERT INTO finished_courses VALUES('19880620-2564','GEMA45',5);
INSERT INTO finished_courses VALUES('19880620-2564','GEMA60',3);
INSERT INTO finished_courses VALUES('19880620-2564','GEMA65',5);
INSERT INTO finished_courses VALUES('19880620-2564','KII010',3);
INSERT INTO finished_courses VALUES('19880620-2564','MAM032',5);
INSERT INTO finished_courses VALUES('19880620-2564','MAMN01',4);
INSERT INTO finished_courses VALUES('19880620-2564','MIE080',4);
INSERT INTO finished_courses VALUES('19880620-2564','MIE090',4);
INSERT INTO finished_courses VALUES('19880620-2564','MIO012',3);
INSERT INTO finished_courses VALUES('19880620-2564','MIOA01',4);
INSERT INTO finished_courses VALUES('19880620-2564','TEK210',5);
INSERT INTO finished_courses VALUES('19940802-3861','EDA270',3);
INSERT INTO finished_courses VALUES('19940802-3861','EDAN55',3);
INSERT INTO finished_courses VALUES('19940802-3861','ESS030',5);
INSERT INTO finished_courses VALUES('19940802-3861','ETIF10',4);
INSERT INTO finished_courses VALUES('19940802-3861','ETSF10',5);
INSERT INTO finished_courses VALUES('19940802-3861','ETTN10',3);
INSERT INTO finished_courses VALUES('19940802-3861','EXTA10',5);
INSERT INTO finished_courses VALUES('19940802-3861','FMA021',4);
INSERT INTO finished_courses VALUES('19940802-3861','FMA272',4);
INSERT INTO finished_courses VALUES('19940802-3861','FMA430',3);
INSERT INTO finished_courses VALUES('19940802-3861','FMAN10',5);
INSERT INTO finished_courses VALUES('19940802-3861','FMN011',4);
INSERT INTO finished_courses VALUES('19940802-3861','FMSF10',4);
INSERT INTO finished_courses VALUES('19940802-3861','FMSF15',5);
INSERT INTO finished_courses VALUES('19940802-3861','FMSN35',3);
INSERT INTO finished_courses VALUES('19940802-3861','FRT010',5);
INSERT INTO finished_courses VALUES('19940802-3861','GEMA45',5);
INSERT INTO finished_courses VALUES('19940802-3861','GEMA55',3);
INSERT INTO finished_courses VALUES('19940802-3861','GEMA65',3);
INSERT INTO finished_courses VALUES('19850706-2762','EEMN10',4);
INSERT INTO finished_courses VALUES('19850706-2762','ETI265',5);
INSERT INTO finished_courses VALUES('19850706-2762','MAM101',3);
INSERT INTO finished_courses VALUES('19850706-2762','MMKF15',3);
INSERT INTO finished_courses VALUES('19890622-1928','EDA180',5);
INSERT INTO finished_courses VALUES('19890622-1928','EDAF75',4);
INSERT INTO finished_courses VALUES('19890622-1928','EDA221',3);
INSERT INTO finished_courses VALUES('19890622-1928','EDAN15',5);
INSERT INTO finished_courses VALUES('19890622-1928','EDAN20',3);
INSERT INTO finished_courses VALUES('19890622-1928','EDAN30',3);
INSERT INTO finished_courses VALUES('19890622-1928','EDAN40',5);
INSERT INTO finished_courses VALUES('19890622-1928','EDIN05',3);
INSERT INTO finished_courses VALUES('19890622-1928','EIE061',3);
INSERT INTO finished_courses VALUES('19890622-1928','EIEF01',5);
INSERT INTO finished_courses VALUES('19890622-1928','EIT070',4);
INSERT INTO finished_courses VALUES('19890622-1928','EIT140',4);
INSERT INTO finished_courses VALUES('19890622-1928','EITF40',5);
INSERT INTO finished_courses VALUES('19890622-1928','EITN45',4);
INSERT INTO finished_courses VALUES('19890622-1928','EITN50',3);
INSERT INTO finished_courses VALUES('19890622-1928','ETI265',5);
INSERT INTO finished_courses VALUES('19890622-1928','ETS075',3);
INSERT INTO finished_courses VALUES('19890622-1928','ETS200',4);
INSERT INTO finished_courses VALUES('19890622-1928','FMAN10',3);
INSERT INTO finished_courses VALUES('19890622-1928','FMIF15',3);
INSERT INTO finished_courses VALUES('19890622-1928','FRTN10',4);
INSERT INTO finished_courses VALUES('19890622-1928','GEMA65',5);
INSERT INTO finished_courses VALUES('19890622-1928','MAMF15',5);
INSERT INTO finished_courses VALUES('19890622-1928','MAMN25',5);
INSERT INTO finished_courses VALUES('19890622-1928','MIE090',5);
INSERT INTO finished_courses VALUES('19890622-1928','MIO012',5);
INSERT INTO finished_courses VALUES('19890622-1928','MMKF15',5);
INSERT INTO finished_courses VALUES('19890622-1928','TEK280',5);
INSERT INTO finished_courses VALUES('19910226-3409','EDA180',5);
INSERT INTO finished_courses VALUES('19910226-3409','EDA221',5);
INSERT INTO finished_courses VALUES('19910226-3409','EEMF05',3);
INSERT INTO finished_courses VALUES('19910226-3409','ETIN35',5);
INSERT INTO finished_courses VALUES('19910226-3409','ETIN60',3);
INSERT INTO finished_courses VALUES('19910226-3409','FMA175',3);
INSERT INTO finished_courses VALUES('19910226-3409','FMS072',5);
INSERT INTO finished_courses VALUES('19910226-3409','FMS110',3);
INSERT INTO finished_courses VALUES('19910226-3409','MAMN25',5);
INSERT INTO finished_courses VALUES('19861103-2438','EDAA25',4);
INSERT INTO finished_courses VALUES('19861103-2438','EDAF05',3);
INSERT INTO finished_courses VALUES('19861103-2438','EDAF10',3);
INSERT INTO finished_courses VALUES('19861103-2438','EDAF15',4);
INSERT INTO finished_courses VALUES('19861103-2438','EDAN55',3);
INSERT INTO finished_courses VALUES('19861103-2438','EIEF01',4);
INSERT INTO finished_courses VALUES('19861103-2438','EITN50',5);
INSERT INTO finished_courses VALUES('19861103-2438','ETI265',5);
INSERT INTO finished_courses VALUES('19861103-2438','ETIN20',5);
INSERT INTO finished_courses VALUES('19861103-2438','ETIN55',5);
INSERT INTO finished_courses VALUES('19861103-2438','FAF150',5);
INSERT INTO finished_courses VALUES('19861103-2438','FMA135',5);
INSERT INTO finished_courses VALUES('19861103-2438','FMAA01',4);
INSERT INTO finished_courses VALUES('19861103-2438','FMI040',5);
INSERT INTO finished_courses VALUES('19861103-2438','FMIF15',5);
INSERT INTO finished_courses VALUES('19861103-2438','FMNN05',5);
INSERT INTO finished_courses VALUES('19861103-2438','FRT010',4);
INSERT INTO finished_courses VALUES('19861103-2438','FRTN01',5);
INSERT INTO finished_courses VALUES('19861103-2438','GEMA25',3);
INSERT INTO finished_courses VALUES('19861103-2438','MIOA01',5);
INSERT INTO finished_courses VALUES('19850819-2139','EDA385',4);
INSERT INTO finished_courses VALUES('19850819-2139','EDAF01',5);
INSERT INTO finished_courses VALUES('19850819-2139','EDAF05',4);
INSERT INTO finished_courses VALUES('19850819-2139','ETSA05',4);
INSERT INTO finished_courses VALUES('19850819-2139','EXTA10',3);
INSERT INTO finished_courses VALUES('19850819-2139','FAF150',3);
INSERT INTO finished_courses VALUES('19850819-2139','FMA125',4);
INSERT INTO finished_courses VALUES('19850819-2139','FMA200',4);
INSERT INTO finished_courses VALUES('19850819-2139','FMAA01',3);
INSERT INTO finished_courses VALUES('19850819-2139','FMNN05',5);
INSERT INTO finished_courses VALUES('19850819-2139','FMS091',4);
INSERT INTO finished_courses VALUES('19850819-2139','GEMA40',5);
INSERT INTO finished_courses VALUES('19940825-1934','EDA031',3);
INSERT INTO finished_courses VALUES('19940825-1934','EDIN05',3);
INSERT INTO finished_courses VALUES('19940825-1934','EEMN10',4);
INSERT INTO finished_courses VALUES('19940825-1934','EIE061',5);
INSERT INTO finished_courses VALUES('19940825-1934','EIEN01',3);
INSERT INTO finished_courses VALUES('19940825-1934','EITF35',4);
INSERT INTO finished_courses VALUES('19940825-1934','EITN10',3);
INSERT INTO finished_courses VALUES('19940825-1934','ETIN10',5);
INSERT INTO finished_courses VALUES('19940825-1934','ETIN15',3);
INSERT INTO finished_courses VALUES('19940825-1934','ETTN10',3);
INSERT INTO finished_courses VALUES('19940825-1934','FMAN10',3);
INSERT INTO finished_courses VALUES('19940825-1934','FRTN01',5);
INSERT INTO finished_courses VALUES('19940825-1934','GEMA25',4);
INSERT INTO finished_courses VALUES('19940825-1934','GEMA45',4);
INSERT INTO finished_courses VALUES('19940825-1934','KII010',5);
INSERT INTO finished_courses VALUES('19940825-1934','TEK210',5);
INSERT INTO finished_courses VALUES('19860323-1071','EDA050',4);
INSERT INTO finished_courses VALUES('19860323-1071','EDAN20',3);
INSERT INTO finished_courses VALUES('19860323-1071','ETIA01',5);
INSERT INTO finished_courses VALUES('19860323-1071','ETIN80',3);
INSERT INTO finished_courses VALUES('19860323-1071','FMN100',4);
INSERT INTO finished_courses VALUES('19860323-1071','FMSN30',4);
INSERT INTO finished_courses VALUES('19860323-1071','FRTN01',4);
INSERT INTO finished_courses VALUES('19860323-1071','GEMA55',5);
INSERT INTO finished_courses VALUES('19860323-1071','MIE080',5);
INSERT INTO finished_courses VALUES('19860323-1071','MIO040',4);
INSERT INTO finished_courses VALUES('19920308-3854','EDA016',4);
INSERT INTO finished_courses VALUES('19920308-3854','EDA050',3);
INSERT INTO finished_courses VALUES('19920308-3854','EDA095',4);
INSERT INTO finished_courses VALUES('19920308-3854','EDA132',3);
INSERT INTO finished_courses VALUES('19920308-3854','EDA180',5);
INSERT INTO finished_courses VALUES('19920308-3854','EDA230',4);
INSERT INTO finished_courses VALUES('19920308-3854','EDAA25',5);
INSERT INTO finished_courses VALUES('19920308-3854','EDAN10',3);
INSERT INTO finished_courses VALUES('19920308-3854','EDAN35',5);
INSERT INTO finished_courses VALUES('19920308-3854','EDAN40',5);
INSERT INTO finished_courses VALUES('19920308-3854','EDAN55',4);
INSERT INTO finished_courses VALUES('19920308-3854','EEMN10',3);
INSERT INTO finished_courses VALUES('19920308-3854','EIT070',4);
INSERT INTO finished_courses VALUES('19920308-3854','EITF01',4);
INSERT INTO finished_courses VALUES('19920308-3854','EITF20',5);
INSERT INTO finished_courses VALUES('19920308-3854','EITF40',4);
INSERT INTO finished_courses VALUES('19920308-3854','EITN30',3);
INSERT INTO finished_courses VALUES('19920308-3854','ESS050',5);
INSERT INTO finished_courses VALUES('19920308-3854','ETIN15',4);
INSERT INTO finished_courses VALUES('19920308-3854','ETS200',5);
INSERT INTO finished_courses VALUES('19920308-3854','ETSF01',5);
INSERT INTO finished_courses VALUES('19920308-3854','ETSF10',5);
INSERT INTO finished_courses VALUES('19920308-3854','ETTN01',4);
INSERT INTO finished_courses VALUES('19920308-3854','ETTN10',3);
INSERT INTO finished_courses VALUES('19920308-3854','EXTA35',4);
INSERT INTO finished_courses VALUES('19920308-3854','FMA111',5);
INSERT INTO finished_courses VALUES('19920308-3854','FMA125',5);
INSERT INTO finished_courses VALUES('19920308-3854','FMA170',5);
INSERT INTO finished_courses VALUES('19920308-3854','FMA200',4);
INSERT INTO finished_courses VALUES('19920308-3854','FMA240',4);
INSERT INTO finished_courses VALUES('19920308-3854','FMA272',3);
INSERT INTO finished_courses VALUES('19920308-3854','FMI040',5);
INSERT INTO finished_courses VALUES('19920308-3854','FMN100',5);
INSERT INTO finished_courses VALUES('19920308-3854','FMS091',3);
INSERT INTO finished_courses VALUES('19920308-3854','FMS110',5);
INSERT INTO finished_courses VALUES('19920308-3854','FMS155',5);
INSERT INTO finished_courses VALUES('19920308-3854','FRT041',3);
INSERT INTO finished_courses VALUES('19920308-3854','GEMA20',5);
INSERT INTO finished_courses VALUES('19920308-3854','GEMA65',3);
INSERT INTO finished_courses VALUES('19920308-3854','MAM120',4);
INSERT INTO finished_courses VALUES('19920308-3854','MAMN15',3);
INSERT INTO finished_courses VALUES('19890820-2496','EDA260',5);
INSERT INTO finished_courses VALUES('19890820-2496','EDA385',4);
INSERT INTO finished_courses VALUES('19890820-2496','EDAF15',5);
INSERT INTO finished_courses VALUES('19890820-2496','EDAN20',4);
INSERT INTO finished_courses VALUES('19890820-2496','EDAN35',4);
INSERT INTO finished_courses VALUES('19890820-2496','EDI042',3);
INSERT INTO finished_courses VALUES('19890820-2496','EEMN01',3);
INSERT INTO finished_courses VALUES('19890820-2496','EEMN15',5);
INSERT INTO finished_courses VALUES('19890820-2496','EITN30',3);
INSERT INTO finished_courses VALUES('19890820-2496','EITN40',5);
INSERT INTO finished_courses VALUES('19890820-2496','ETIF05',3);
INSERT INTO finished_courses VALUES('19890820-2496','EXTA35',3);
INSERT INTO finished_courses VALUES('19890820-2496','FMA272',5);
INSERT INTO finished_courses VALUES('19890820-2496','FMA430',5);
INSERT INTO finished_courses VALUES('19890820-2496','FMAF10',4);
INSERT INTO finished_courses VALUES('19890820-2496','FMS091',4);
INSERT INTO finished_courses VALUES('19890820-2496','FMSN20',4);
INSERT INTO finished_courses VALUES('19890820-2496','FMSN30',5);
INSERT INTO finished_courses VALUES('19890820-2496','FRTN15',5);
INSERT INTO finished_courses VALUES('19890820-2496','GEMA25',5);
INSERT INTO finished_courses VALUES('19890820-2496','GEMA55',3);
INSERT INTO finished_courses VALUES('19890820-2496','MAM101',5);
INSERT INTO finished_courses VALUES('19890820-2496','MAMN15',4);
INSERT INTO finished_courses VALUES('19890820-2496','MIE090',3);
INSERT INTO finished_courses VALUES('19920623-3258','EDA016',4);
INSERT INTO finished_courses VALUES('19920623-3258','EDA095',5);
INSERT INTO finished_courses VALUES('19920623-3258','EDAA01',3);
INSERT INTO finished_courses VALUES('19920623-3258','EDAF10',5);
INSERT INTO finished_courses VALUES('19920623-3258','EDAN15',4);
INSERT INTO finished_courses VALUES('19920623-3258','EDAN30',3);
INSERT INTO finished_courses VALUES('19920623-3258','EDAN55',5);
INSERT INTO finished_courses VALUES('19920623-3258','EDAN60',4);
INSERT INTO finished_courses VALUES('19920623-3258','EDIN05',4);
INSERT INTO finished_courses VALUES('19920623-3258','EEMN10',3);
INSERT INTO finished_courses VALUES('19920623-3258','EIE061',4);
INSERT INTO finished_courses VALUES('19920623-3258','EIT020',3);
INSERT INTO finished_courses VALUES('19920623-3258','EIT140',3);
INSERT INTO finished_courses VALUES('19920623-3258','EITF20',5);
INSERT INTO finished_courses VALUES('19920623-3258','EITF40',4);
INSERT INTO finished_courses VALUES('19920623-3258','ESSF10',4);
INSERT INTO finished_courses VALUES('19920623-3258','ETIA01',5);
INSERT INTO finished_courses VALUES('19920623-3258','ETIA10',4);
INSERT INTO finished_courses VALUES('19920623-3258','ETIF15',5);
INSERT INTO finished_courses VALUES('19920623-3258','ETIN15',5);
INSERT INTO finished_courses VALUES('19920623-3258','ETIN40',3);
INSERT INTO finished_courses VALUES('19920623-3258','ETIN45',3);
INSERT INTO finished_courses VALUES('19920623-3258','ETIN55',5);
INSERT INTO finished_courses VALUES('19920623-3258','ETS061',3);
INSERT INTO finished_courses VALUES('19920623-3258','ETS170',5);
INSERT INTO finished_courses VALUES('19920623-3258','ETSN05',3);
INSERT INTO finished_courses VALUES('19920623-3258','ETTN01',3);
INSERT INTO finished_courses VALUES('19920623-3258','FMA140',5);
INSERT INTO finished_courses VALUES('19920623-3258','FMA270',3);
INSERT INTO finished_courses VALUES('19920623-3258','FMA272',4);
INSERT INTO finished_courses VALUES('19920623-3258','FMA430',4);
INSERT INTO finished_courses VALUES('19920623-3258','FMAF10',3);
INSERT INTO finished_courses VALUES('19920623-3258','FMS091',4);
INSERT INTO finished_courses VALUES('19920623-3258','FMSN20',3);
INSERT INTO finished_courses VALUES('19920623-3258','FRT041',3);
INSERT INTO finished_courses VALUES('19920623-3258','FRTN01',5);
INSERT INTO finished_courses VALUES('19920623-3258','GEMA25',5);
INSERT INTO finished_courses VALUES('19920623-3258','GEMA55',5);
INSERT INTO finished_courses VALUES('19920623-3258','GEMA60',4);
INSERT INTO finished_courses VALUES('19920623-3258','GEMA65',3);
INSERT INTO finished_courses VALUES('19920623-3258','MAM032',5);
INSERT INTO finished_courses VALUES('19920623-3258','MAM120',4);
INSERT INTO finished_courses VALUES('19920623-3258','MAMN01',5);
INSERT INTO finished_courses VALUES('19920623-3258','MIE080',4);
INSERT INTO finished_courses VALUES('19920623-3258','MMKF15',4);
INSERT INTO finished_courses VALUES('19920623-3258','TEK280',4);
INSERT INTO finished_courses VALUES('19890621-3057','EDA016',3);
INSERT INTO finished_courses VALUES('19890621-3057','EDA031',5);
INSERT INTO finished_courses VALUES('19890621-3057','EDA132',4);
INSERT INTO finished_courses VALUES('19890621-3057','EDA230',4);
INSERT INTO finished_courses VALUES('19890621-3057','EDAF10',4);
INSERT INTO finished_courses VALUES('19890621-3057','EDAF15',3);
INSERT INTO finished_courses VALUES('19890621-3057','EDAN20',5);
INSERT INTO finished_courses VALUES('19890621-3057','EDAN30',5);
INSERT INTO finished_courses VALUES('19890621-3057','EDAN35',5);
INSERT INTO finished_courses VALUES('19890621-3057','EDI042',4);
INSERT INTO finished_courses VALUES('19890621-3057','EDIN05',4);
INSERT INTO finished_courses VALUES('19890621-3057','EEMN15',3);
INSERT INTO finished_courses VALUES('19890621-3057','EIT060',5);
INSERT INTO finished_courses VALUES('19890621-3057','EITF35',5);
INSERT INTO finished_courses VALUES('19890621-3057','ESS030',3);
INSERT INTO finished_courses VALUES('19890621-3057','ETIF05',3);
INSERT INTO finished_courses VALUES('19890621-3057','ETIF15',3);
INSERT INTO finished_courses VALUES('19890621-3057','ETIN35',4);
INSERT INTO finished_courses VALUES('19890621-3057','ETSA05',4);
INSERT INTO finished_courses VALUES('19890621-3057','ETTN01',4);
INSERT INTO finished_courses VALUES('19890621-3057','ETTN05',5);
INSERT INTO finished_courses VALUES('19890621-3057','EXTF60',3);
INSERT INTO finished_courses VALUES('19890621-3057','FMA051',4);
INSERT INTO finished_courses VALUES('19890621-3057','FMA125',3);
INSERT INTO finished_courses VALUES('19890621-3057','FMA145',5);
INSERT INTO finished_courses VALUES('19890621-3057','FMA240',4);
INSERT INTO finished_courses VALUES('19890621-3057','FMA270',3);
INSERT INTO finished_courses VALUES('19890621-3057','FMAA01',5);
INSERT INTO finished_courses VALUES('19890621-3057','FMNN05',5);
INSERT INTO finished_courses VALUES('19890621-3057','FMSN30',5);
INSERT INTO finished_courses VALUES('19890621-3057','FMSN35',4);
INSERT INTO finished_courses VALUES('19890621-3057','FRTN10',5);
INSERT INTO finished_courses VALUES('19890621-3057','GEMA01',5);
INSERT INTO finished_courses VALUES('19890621-3057','GEMA25',3);
INSERT INTO finished_courses VALUES('19890621-3057','GEMA50',5);
INSERT INTO finished_courses VALUES('19890621-3057','MAMF15',3);
INSERT INTO finished_courses VALUES('19890621-3057','MAMN01',5);
INSERT INTO finished_courses VALUES('19890621-3057','MAMN25',5);
INSERT INTO finished_courses VALUES('19890621-3057','MIE090',4);
INSERT INTO finished_courses VALUES('19890621-3057','MIO022',5);
INSERT INTO finished_courses VALUES('19890621-3057','MIOA01',4);
INSERT INTO finished_courses VALUES('19920812-1857','EDAN01',4);
INSERT INTO finished_courses VALUES('19920812-1857','EEMN01',3);
INSERT INTO finished_courses VALUES('19920812-1857','EITN40',5);
INSERT INTO finished_courses VALUES('19920812-1857','ETIF15',4);
INSERT INTO finished_courses VALUES('19920812-1857','FMA175',4);
INSERT INTO finished_courses VALUES('19920812-1857','MAM101',5);
INSERT INTO finished_courses VALUES('19850208-1213','EDAF75',3);
INSERT INTO finished_courses VALUES('19850208-1213','EDAA01',3);
INSERT INTO finished_courses VALUES('19850208-1213','EDAN35',3);
INSERT INTO finished_courses VALUES('19850208-1213','EDI042',5);
INSERT INTO finished_courses VALUES('19850208-1213','EIEN01',3);
INSERT INTO finished_courses VALUES('19850208-1213','EITF01',4);
INSERT INTO finished_courses VALUES('19850208-1213','EITN50',5);
INSERT INTO finished_courses VALUES('19850208-1213','ETIN15',5);
INSERT INTO finished_courses VALUES('19850208-1213','ETIN45',3);
INSERT INTO finished_courses VALUES('19850208-1213','ETIN60',4);
INSERT INTO finished_courses VALUES('19850208-1213','ETSA05',3);
INSERT INTO finished_courses VALUES('19850208-1213','EXTF60',4);
INSERT INTO finished_courses VALUES('19850208-1213','FMA420',3);
INSERT INTO finished_courses VALUES('19850208-1213','FMA430',5);
INSERT INTO finished_courses VALUES('19850208-1213','FMAF05',4);
INSERT INTO finished_courses VALUES('19850208-1213','FMI040',3);
INSERT INTO finished_courses VALUES('19850208-1213','FRT130',4);
INSERT INTO finished_courses VALUES('19850208-1213','GEMA20',3);
INSERT INTO finished_courses VALUES('19850208-1213','MAMN25',3);
INSERT INTO finished_courses VALUES('19850208-1213','MIOA01',5);
INSERT INTO finished_courses VALUES('19850208-1213','MMKF15',3);
INSERT INTO finished_courses VALUES('19850208-1213','TNX153',4);
INSERT INTO finished_courses VALUES('19930420-2833','EITF05',4);
INSERT INTO finished_courses VALUES('19930716-3933','EDAN15',4);
INSERT INTO finished_courses VALUES('19930716-3933','EDAN55',4);
INSERT INTO finished_courses VALUES('19930716-3933','ETIN10',3);
INSERT INTO finished_courses VALUES('19930716-3933','FMAA01',4);
INSERT INTO finished_courses VALUES('19930716-3933','FMSN20',5);
INSERT INTO finished_courses VALUES('19930716-3933','FRTN10',5);
INSERT INTO finished_courses VALUES('19930716-3933','MAM101',3);
INSERT INTO finished_courses VALUES('19940801-2971','EDA050',3);
INSERT INTO finished_courses VALUES('19940801-2971','EDA180',5);
INSERT INTO finished_courses VALUES('19940801-2971','EDIN01',4);
INSERT INTO finished_courses VALUES('19940801-2971','EITF01',4);
INSERT INTO finished_courses VALUES('19940801-2971','EITN10',4);
INSERT INTO finished_courses VALUES('19940801-2971','EITN50',5);
INSERT INTO finished_courses VALUES('19940801-2971','ESSF10',5);
INSERT INTO finished_courses VALUES('19940801-2971','ETIN55',5);
INSERT INTO finished_courses VALUES('19940801-2971','ETSF01',3);
INSERT INTO finished_courses VALUES('19940801-2971','ETT051',5);
INSERT INTO finished_courses VALUES('19940801-2971','ETTN10',3);
INSERT INTO finished_courses VALUES('19940801-2971','FMA051',3);
INSERT INTO finished_courses VALUES('19940801-2971','FMA145',5);
INSERT INTO finished_courses VALUES('19940801-2971','FMNN05',5);
INSERT INTO finished_courses VALUES('19940801-2971','FMS155',5);
INSERT INTO finished_courses VALUES('19940801-2971','FMSF15',3);
INSERT INTO finished_courses VALUES('19940801-2971','FRT041',3);
INSERT INTO finished_courses VALUES('19940801-2971','FRTN01',4);
INSERT INTO finished_courses VALUES('19940801-2971','GEMA25',4);
INSERT INTO finished_courses VALUES('19940801-2971','MAM032',4);
INSERT INTO finished_courses VALUES('19940801-2971','MAMN01',5);
INSERT INTO finished_courses VALUES('19940801-2971','MAMN15',5);
INSERT INTO finished_courses VALUES('19940801-2971','MMKF15',4);
INSERT INTO finished_courses VALUES('19931128-1333','EDA016',3);
INSERT INTO finished_courses VALUES('19931128-1333','EDAN15',3);
INSERT INTO finished_courses VALUES('19931128-1333','EDAN55',3);
INSERT INTO finished_courses VALUES('19931128-1333','EEMN10',4);
INSERT INTO finished_courses VALUES('19931128-1333','EIT070',4);
INSERT INTO finished_courses VALUES('19931128-1333','EITF05',3);
INSERT INTO finished_courses VALUES('19931128-1333','EITF40',5);
INSERT INTO finished_courses VALUES('19931128-1333','ETIA01',3);
INSERT INTO finished_courses VALUES('19931128-1333','ETIN60',3);
INSERT INTO finished_courses VALUES('19931128-1333','ETS170',3);
INSERT INTO finished_courses VALUES('19931128-1333','ETS200',5);
INSERT INTO finished_courses VALUES('19931128-1333','ETSA01',3);
INSERT INTO finished_courses VALUES('19931128-1333','ETSN01',4);
INSERT INTO finished_courses VALUES('19931128-1333','ETTN10',4);
INSERT INTO finished_courses VALUES('19931128-1333','ETTN15',5);
INSERT INTO finished_courses VALUES('19931128-1333','FMA051',4);
INSERT INTO finished_courses VALUES('19931128-1333','FMA135',4);
INSERT INTO finished_courses VALUES('19931128-1333','FMA140',4);
INSERT INTO finished_courses VALUES('19931128-1333','FMA240',3);
INSERT INTO finished_courses VALUES('19931128-1333','FMN011',4);
INSERT INTO finished_courses VALUES('19931128-1333','FMS051',4);
INSERT INTO finished_courses VALUES('19931128-1333','GEMA60',4);
INSERT INTO finished_courses VALUES('19931128-1333','MAMN15',4);
INSERT INTO finished_courses VALUES('19931128-1333','MAMN25',5);
INSERT INTO finished_courses VALUES('19931128-1333','MIO022',4);
INSERT INTO finished_courses VALUES('19940318-2373','EDA095',3);
INSERT INTO finished_courses VALUES('19940318-2373','EDAF01',5);
INSERT INTO finished_courses VALUES('19940318-2373','EDAN01',4);
INSERT INTO finished_courses VALUES('19940318-2373','EIT020',5);
INSERT INTO finished_courses VALUES('19940318-2373','EIT070',4);
INSERT INTO finished_courses VALUES('19940318-2373','EITF01',4);
INSERT INTO finished_courses VALUES('19940318-2373','EITF05',5);
INSERT INTO finished_courses VALUES('19940318-2373','EITF40',5);
INSERT INTO finished_courses VALUES('19940318-2373','ETIA01',5);
INSERT INTO finished_courses VALUES('19940318-2373','ETIN10',4);
INSERT INTO finished_courses VALUES('19940318-2373','ETIN60',5);
INSERT INTO finished_courses VALUES('19940318-2373','ETS170',5);
INSERT INTO finished_courses VALUES('19940318-2373','ETSF01',3);
INSERT INTO finished_courses VALUES('19940318-2373','ETT051',4);
INSERT INTO finished_courses VALUES('19940318-2373','EXTA10',3);
INSERT INTO finished_courses VALUES('19940318-2373','FAF150',4);
INSERT INTO finished_courses VALUES('19940318-2373','FMA091',5);
INSERT INTO finished_courses VALUES('19940318-2373','FMA140',3);
INSERT INTO finished_courses VALUES('19940318-2373','FMA420',4);
INSERT INTO finished_courses VALUES('19940318-2373','FMAN10',5);
INSERT INTO finished_courses VALUES('19940318-2373','FMI040',5);
INSERT INTO finished_courses VALUES('19940318-2373','FMNN25',4);
INSERT INTO finished_courses VALUES('19940318-2373','FMS091',4);
INSERT INTO finished_courses VALUES('19940318-2373','FMSN30',3);
INSERT INTO finished_courses VALUES('19940318-2373','FRT130',3);
INSERT INTO finished_courses VALUES('19940318-2373','GEMA01',4);
INSERT INTO finished_courses VALUES('19940318-2373','GEMA65',4);
INSERT INTO finished_courses VALUES('19940318-2373','GEMA70',4);
INSERT INTO finished_courses VALUES('19940318-2373','MAM032',4);
INSERT INTO finished_courses VALUES('19940318-2373','MIE080',4);
INSERT INTO finished_courses VALUES('19940318-2373','MIO022',3);
INSERT INTO finished_courses VALUES('19940318-2373','TNX153',3);
INSERT INTO finished_courses VALUES('19881030-2772','EDA260',3);
INSERT INTO finished_courses VALUES('19881030-2772','EDAN30',3);
INSERT INTO finished_courses VALUES('19881030-2772','EEMF05',4);
INSERT INTO finished_courses VALUES('19881030-2772','ETIN55',5);
INSERT INTO finished_courses VALUES('19881030-2772','ETS170',3);
INSERT INTO finished_courses VALUES('19881030-2772','ETSA05',4);
INSERT INTO finished_courses VALUES('19881030-2772','ETT051',3);
INSERT INTO finished_courses VALUES('19881030-2772','FAFF25',5);
INSERT INTO finished_courses VALUES('19881030-2772','FMA240',4);
INSERT INTO finished_courses VALUES('19881030-2772','FMA272',5);
INSERT INTO finished_courses VALUES('19881030-2772','FMA430',4);
INSERT INTO finished_courses VALUES('19881030-2772','FMAF01',4);
INSERT INTO finished_courses VALUES('19881030-2772','FMI050',3);
INSERT INTO finished_courses VALUES('19881030-2772','FMIF15',5);
INSERT INTO finished_courses VALUES('19881030-2772','FMS091',3);
INSERT INTO finished_courses VALUES('19881030-2772','FMSF10',3);
INSERT INTO finished_courses VALUES('19881030-2772','FRT041',3);
INSERT INTO finished_courses VALUES('19881030-2772','FRT090',5);
INSERT INTO finished_courses VALUES('19881030-2772','MAMN01',5);
INSERT INTO finished_courses VALUES('19931015-1271','EDA230',4);
INSERT INTO finished_courses VALUES('19931015-1271','ETIN20',4);
INSERT INTO finished_courses VALUES('19931015-1271','ETIN40',4);
INSERT INTO finished_courses VALUES('19900206-3735','EDA221',5);
INSERT INTO finished_courses VALUES('19900206-3735','EDAF10',4);
INSERT INTO finished_courses VALUES('19900206-3735','EDAN30',5);
INSERT INTO finished_courses VALUES('19900206-3735','EDAN55',3);
INSERT INTO finished_courses VALUES('19900206-3735','EEMN15',3);
INSERT INTO finished_courses VALUES('19900206-3735','EIEF01',4);
INSERT INTO finished_courses VALUES('19900206-3735','EITN40',4);
INSERT INTO finished_courses VALUES('19900206-3735','ETIF10',4);
INSERT INTO finished_courses VALUES('19900206-3735','ETSA01',5);
INSERT INTO finished_courses VALUES('19900206-3735','FMA145',3);
INSERT INTO finished_courses VALUES('19900206-3735','FMNN25',5);
INSERT INTO finished_courses VALUES('19900206-3735','FMS051',5);
INSERT INTO finished_courses VALUES('19900206-3735','FMS072',4);
INSERT INTO finished_courses VALUES('19900206-3735','FRT041',5);
INSERT INTO finished_courses VALUES('19900206-3735','FRTN10',5);
INSERT INTO finished_courses VALUES('19900206-3735','GEMA20',4);
INSERT INTO finished_courses VALUES('19900206-3735','GEMA25',3);
INSERT INTO finished_courses VALUES('19900206-3735','GEMA50',5);
INSERT INTO finished_courses VALUES('19900206-3735','MAMN10',4);
INSERT INTO finished_courses VALUES('19900206-3735','TNX097',3);
INSERT INTO finished_courses VALUES('19891231-2554','EDAN10',4);
INSERT INTO finished_courses VALUES('19891231-2554','EDAN25',5);
INSERT INTO finished_courses VALUES('19891231-2554','EIEF01',5);
INSERT INTO finished_courses VALUES('19891231-2554','EITF20',3);
INSERT INTO finished_courses VALUES('19891231-2554','ETIN35',4);
INSERT INTO finished_courses VALUES('19891231-2554','FMA111',3);
INSERT INTO finished_courses VALUES('19891231-2554','FMA125',3);
INSERT INTO finished_courses VALUES('19891231-2554','FMA145',4);
INSERT INTO finished_courses VALUES('19891231-2554','FRT041',3);
INSERT INTO finished_courses VALUES('19891231-2554','FRT130',4);
INSERT INTO finished_courses VALUES('19891231-2554','FRTN15',5);
INSERT INTO finished_courses VALUES('19891231-2554','TNX153',4);
INSERT INTO finished_courses VALUES('19900526-1450','EDA031',4);
INSERT INTO finished_courses VALUES('19900526-1450','FMA091',3);
INSERT INTO finished_courses VALUES('19900526-1450','FRTN01',4);
INSERT INTO finished_courses VALUES('19900526-1450','MAMN15',5);
INSERT INTO finished_courses VALUES('19950830-2637','EDAA05',3);
INSERT INTO finished_courses VALUES('19950830-2637','EDAF01',4);
INSERT INTO finished_courses VALUES('19950830-2637','EDAN10',5);
INSERT INTO finished_courses VALUES('19950830-2637','EDIN01',4);
INSERT INTO finished_courses VALUES('19950830-2637','EIE061',5);
INSERT INTO finished_courses VALUES('19950830-2637','EIEN01',5);
INSERT INTO finished_courses VALUES('19950830-2637','EITN10',5);
INSERT INTO finished_courses VALUES('19950830-2637','EITN35',4);
INSERT INTO finished_courses VALUES('19950830-2637','ETIF05',3);
INSERT INTO finished_courses VALUES('19950830-2637','ETIN60',3);
INSERT INTO finished_courses VALUES('19950830-2637','ETIN70',4);
INSERT INTO finished_courses VALUES('19950830-2637','ETSA05',5);
INSERT INTO finished_courses VALUES('19950830-2637','ETTN15',5);
INSERT INTO finished_courses VALUES('19950830-2637','EXTA10',3);
INSERT INTO finished_courses VALUES('19950830-2637','EXTA35',3);
INSERT INTO finished_courses VALUES('19950830-2637','EXTF60',3);
INSERT INTO finished_courses VALUES('19950830-2637','FMA021',3);
INSERT INTO finished_courses VALUES('19950830-2637','FMA051',5);
INSERT INTO finished_courses VALUES('19950830-2637','FMAF10',4);
INSERT INTO finished_courses VALUES('19950830-2637','FMI050',3);
INSERT INTO finished_courses VALUES('19950830-2637','FMSF10',5);
INSERT INTO finished_courses VALUES('19950830-2637','FMSF15',5);
INSERT INTO finished_courses VALUES('19950830-2637','FRT010',3);
INSERT INTO finished_courses VALUES('19880322-3951','EDA016',4);
INSERT INTO finished_courses VALUES('19880322-3951','EDA040',3);
INSERT INTO finished_courses VALUES('19880322-3951','EDAN10',5);
INSERT INTO finished_courses VALUES('19880322-3951','EDAN25',3);
INSERT INTO finished_courses VALUES('19880322-3951','EDAN60',3);
INSERT INTO finished_courses VALUES('19880322-3951','EEMN10',3);
INSERT INTO finished_courses VALUES('19880322-3951','EIT070',3);
INSERT INTO finished_courses VALUES('19880322-3951','EIT140',4);
INSERT INTO finished_courses VALUES('19880322-3951','EITF01',5);
INSERT INTO finished_courses VALUES('19880322-3951','EITN40',4);
INSERT INTO finished_courses VALUES('19880322-3951','ESSF10',4);
INSERT INTO finished_courses VALUES('19880322-3951','ETIF10',5);
INSERT INTO finished_courses VALUES('19880322-3951','ETIN20',4);
INSERT INTO finished_courses VALUES('19880322-3951','ETIN60',3);
INSERT INTO finished_courses VALUES('19880322-3951','ETS170',3);
INSERT INTO finished_courses VALUES('19880322-3951','ETSF10',4);
INSERT INTO finished_courses VALUES('19880322-3951','ETTN15',4);
INSERT INTO finished_courses VALUES('19880322-3951','EXTF60',5);
INSERT INTO finished_courses VALUES('19880322-3951','FAF150',3);
INSERT INTO finished_courses VALUES('19880322-3951','FMA091',5);
INSERT INTO finished_courses VALUES('19880322-3951','FMA145',4);
INSERT INTO finished_courses VALUES('19880322-3951','FMA272',4);
INSERT INTO finished_courses VALUES('19880322-3951','FMAF10',4);
INSERT INTO finished_courses VALUES('19880322-3951','FMNN05',5);
INSERT INTO finished_courses VALUES('19880322-3951','FMS091',3);
INSERT INTO finished_courses VALUES('19880322-3951','FMSF10',4);
INSERT INTO finished_courses VALUES('19880322-3951','FMSN20',4);
INSERT INTO finished_courses VALUES('19880322-3951','FRTN01',5);
INSERT INTO finished_courses VALUES('19880322-3951','FRTN10',4);
INSERT INTO finished_courses VALUES('19880322-3951','FRTN15',4);
INSERT INTO finished_courses VALUES('19880322-3951','GEMA01',5);
INSERT INTO finished_courses VALUES('19880322-3951','MAM032',5);
INSERT INTO finished_courses VALUES('19880322-3951','MAMN10',3);
INSERT INTO finished_courses VALUES('19880322-3951','MMKF15',5);
INSERT INTO finished_courses VALUES('19880322-3951','TNX097',5);
INSERT INTO finished_courses VALUES('19950714-2190','EDA230',5);
INSERT INTO finished_courses VALUES('19950714-2190','ETSF01',3);
INSERT INTO finished_courses VALUES('19950714-2190','FMA021',3);
INSERT INTO finished_courses VALUES('19950714-2190','MAMF15',4);
INSERT INTO finished_courses VALUES('19950714-2190','MMKF15',3);
INSERT INTO finished_courses VALUES('19911020-3538','EDA016',5);
INSERT INTO finished_courses VALUES('19911020-3538','EDA095',5);
INSERT INTO finished_courses VALUES('19911020-3538','EDAF15',5);
INSERT INTO finished_courses VALUES('19911020-3538','EDAN55',3);
INSERT INTO finished_courses VALUES('19911020-3538','EDI042',3);
INSERT INTO finished_courses VALUES('19911020-3538','EEMN05',3);
INSERT INTO finished_courses VALUES('19911020-3538','EEMN15',4);
INSERT INTO finished_courses VALUES('19911020-3538','EIEF01',3);
INSERT INTO finished_courses VALUES('19911020-3538','EITF05',3);
INSERT INTO finished_courses VALUES('19911020-3538','EITN10',3);
INSERT INTO finished_courses VALUES('19911020-3538','ESS050',3);
INSERT INTO finished_courses VALUES('19911020-3538','ETIF15',5);
INSERT INTO finished_courses VALUES('19911020-3538','ETS052',4);
INSERT INTO finished_courses VALUES('19911020-3538','ETSF01',5);
INSERT INTO finished_courses VALUES('19911020-3538','ETSN05',4);
INSERT INTO finished_courses VALUES('19911020-3538','EXTA10',4);
INSERT INTO finished_courses VALUES('19911020-3538','FMA175',4);
INSERT INTO finished_courses VALUES('19911020-3538','FMA272',5);
INSERT INTO finished_courses VALUES('19911020-3538','FMAF01',3);
INSERT INTO finished_courses VALUES('19911020-3538','FMAF10',4);
INSERT INTO finished_courses VALUES('19911020-3538','FMAN10',4);
INSERT INTO finished_courses VALUES('19911020-3538','FMIF15',5);
INSERT INTO finished_courses VALUES('19911020-3538','FMN100',3);
INSERT INTO finished_courses VALUES('19911020-3538','FMNN05',5);
INSERT INTO finished_courses VALUES('19911020-3538','FMNN25',3);
INSERT INTO finished_courses VALUES('19911020-3538','FMS155',4);
INSERT INTO finished_courses VALUES('19911020-3538','FMSN20',4);
INSERT INTO finished_courses VALUES('19911020-3538','FMSN30',4);
INSERT INTO finished_courses VALUES('19911020-3538','FRT010',3);
INSERT INTO finished_courses VALUES('19911020-3538','FRTN01',4);
INSERT INTO finished_courses VALUES('19911020-3538','GEMA50',4);
INSERT INTO finished_courses VALUES('19911020-3538','GEMA70',5);
INSERT INTO finished_courses VALUES('19911020-3538','KII010',5);
INSERT INTO finished_courses VALUES('19911020-3538','MIO040',4);
INSERT INTO finished_courses VALUES('19911020-3538','TNX153',5);
INSERT INTO finished_courses VALUES('19921222-2113','EDA040',3);
INSERT INTO finished_courses VALUES('19921222-2113','EDA095',5);
INSERT INTO finished_courses VALUES('19921222-2113','EDAF01',5);
INSERT INTO finished_courses VALUES('19921222-2113','EDAN10',4);
INSERT INTO finished_courses VALUES('19921222-2113','EEM031',5);
INSERT INTO finished_courses VALUES('19921222-2113','EEMF05',3);
INSERT INTO finished_courses VALUES('19921222-2113','EEMN10',4);
INSERT INTO finished_courses VALUES('19921222-2113','EIEN01',4);
INSERT INTO finished_courses VALUES('19921222-2113','EIT020',3);
INSERT INTO finished_courses VALUES('19921222-2113','EITF01',3);
INSERT INTO finished_courses VALUES('19921222-2113','EITN30',4);
INSERT INTO finished_courses VALUES('19921222-2113','ESS030',5);
INSERT INTO finished_courses VALUES('19921222-2113','ETI265',3);
INSERT INTO finished_courses VALUES('19921222-2113','ETIF05',3);
INSERT INTO finished_courses VALUES('19921222-2113','ETIF10',4);
INSERT INTO finished_courses VALUES('19921222-2113','ETIN15',5);
INSERT INTO finished_courses VALUES('19921222-2113','ETIN20',5);
INSERT INTO finished_courses VALUES('19921222-2113','ETIN40',4);
INSERT INTO finished_courses VALUES('19921222-2113','ETS052',3);
INSERT INTO finished_courses VALUES('19921222-2113','ETSN05',4);
INSERT INTO finished_courses VALUES('19921222-2113','ETT051',5);
INSERT INTO finished_courses VALUES('19921222-2113','ETTN05',3);
INSERT INTO finished_courses VALUES('19921222-2113','EXTF60',5);
INSERT INTO finished_courses VALUES('19921222-2113','FAFF25',3);
INSERT INTO finished_courses VALUES('19921222-2113','FMA111',5);
INSERT INTO finished_courses VALUES('19921222-2113','FMA125',4);
INSERT INTO finished_courses VALUES('19921222-2113','FMA135',5);
INSERT INTO finished_courses VALUES('19921222-2113','FMA140',3);
INSERT INTO finished_courses VALUES('19921222-2113','FMA145',5);
INSERT INTO finished_courses VALUES('19921222-2113','FMA200',4);
INSERT INTO finished_courses VALUES('19921222-2113','FMA270',4);
INSERT INTO finished_courses VALUES('19921222-2113','FMAF01',5);
INSERT INTO finished_courses VALUES('19921222-2113','FMAN10',4);
INSERT INTO finished_courses VALUES('19921222-2113','FMS012',5);
INSERT INTO finished_courses VALUES('19921222-2113','FMS072',3);
INSERT INTO finished_courses VALUES('19921222-2113','FMSF15',5);
INSERT INTO finished_courses VALUES('19921222-2113','FRT090',4);
INSERT INTO finished_courses VALUES('19921222-2113','FRT130',5);
INSERT INTO finished_courses VALUES('19921222-2113','FRTN01',5);
INSERT INTO finished_courses VALUES('19921222-2113','FRTN10',3);
INSERT INTO finished_courses VALUES('19921222-2113','GEMA40',3);
INSERT INTO finished_courses VALUES('19921222-2113','GEMA60',4);
INSERT INTO finished_courses VALUES('19921222-2113','KII010',4);
INSERT INTO finished_courses VALUES('19921222-2113','MAM101',5);
INSERT INTO finished_courses VALUES('19921222-2113','MAM120',3);
INSERT INTO finished_courses VALUES('19921222-2113','TNX153',4);
INSERT INTO finished_courses VALUES('19891106-1277','EDIN05',4);
INSERT INTO finished_courses VALUES('19891106-1277','EEM031',3);
INSERT INTO finished_courses VALUES('19891106-1277','EITF01',5);
INSERT INTO finished_courses VALUES('19891106-1277','ETT051',4);
INSERT INTO finished_courses VALUES('19891106-1277','FAFF25',3);
INSERT INTO finished_courses VALUES('19891106-1277','FMA175',3);
INSERT INTO finished_courses VALUES('19891106-1277','FMN100',5);
INSERT INTO finished_courses VALUES('19891106-1277','MIOA01',3);
INSERT INTO finished_courses VALUES('19920906-3371','EDA016',3);
INSERT INTO finished_courses VALUES('19920906-3371','EDAN01',3);
INSERT INTO finished_courses VALUES('19920906-3371','EDAN60',4);
INSERT INTO finished_courses VALUES('19920906-3371','EEMN10',5);
INSERT INTO finished_courses VALUES('19920906-3371','EIEF01',3);
INSERT INTO finished_courses VALUES('19920906-3371','EITF20',3);
INSERT INTO finished_courses VALUES('19920906-3371','ESS030',5);
INSERT INTO finished_courses VALUES('19920906-3371','ETS052',3);
INSERT INTO finished_courses VALUES('19920906-3371','ETS170',5);
INSERT INTO finished_courses VALUES('19920906-3371','ETS200',4);
INSERT INTO finished_courses VALUES('19920906-3371','ETSA01',4);
INSERT INTO finished_courses VALUES('19920906-3371','ETSN05',3);
INSERT INTO finished_courses VALUES('19920906-3371','EXTA35',4);
INSERT INTO finished_courses VALUES('19920906-3371','FMA420',5);
INSERT INTO finished_courses VALUES('19920906-3371','FMI050',5);
INSERT INTO finished_courses VALUES('19920906-3371','FMIF15',4);
INSERT INTO finished_courses VALUES('19920906-3371','FMN011',3);
INSERT INTO finished_courses VALUES('19920906-3371','FMS091',4);
INSERT INTO finished_courses VALUES('19920906-3371','FMS155',5);
INSERT INTO finished_courses VALUES('19920906-3371','FMSF15',4);
INSERT INTO finished_courses VALUES('19920906-3371','GEMA50',5);
INSERT INTO finished_courses VALUES('19920906-3371','MAMN10',3);
INSERT INTO finished_courses VALUES('19920906-3371','MIO022',5);
INSERT INTO finished_courses VALUES('19920906-3371','TNX153',5);
INSERT INTO finished_courses VALUES('19890103-1256','EDA040',4);
INSERT INTO finished_courses VALUES('19890103-1256','EDA095',5);
INSERT INTO finished_courses VALUES('19890103-1256','EDAN15',3);
INSERT INTO finished_courses VALUES('19890103-1256','EDIN01',3);
INSERT INTO finished_courses VALUES('19890103-1256','ETS075',5);
INSERT INTO finished_courses VALUES('19890103-1256','FMA091',5);
INSERT INTO finished_courses VALUES('19890103-1256','FMA430',3);
INSERT INTO finished_courses VALUES('19890103-1256','TNX153',3);
INSERT INTO finished_courses VALUES('19920514-3433','EITN40',5);
INSERT INTO finished_courses VALUES('19920514-3433','ESS030',4);
INSERT INTO finished_courses VALUES('19920514-3433','GEMA65',3);
INSERT INTO finished_courses VALUES('19920514-3433','MAMF15',3);
INSERT INTO finished_courses VALUES('19950715-2090','EDA016',4);
INSERT INTO finished_courses VALUES('19900918-3999','EDA016',5);
INSERT INTO finished_courses VALUES('19900918-3999','EDA132',4);
INSERT INTO finished_courses VALUES('19900918-3999','EDA221',5);
INSERT INTO finished_courses VALUES('19900918-3999','EDAA05',5);
INSERT INTO finished_courses VALUES('19900918-3999','EDAN01',3);
INSERT INTO finished_courses VALUES('19900918-3999','EDAN10',4);
INSERT INTO finished_courses VALUES('19900918-3999','EEMN01',4);
INSERT INTO finished_courses VALUES('19900918-3999','EIEF01',4);
INSERT INTO finished_courses VALUES('19900918-3999','EIT060',3);
INSERT INTO finished_courses VALUES('19900918-3999','EITN10',4);
INSERT INTO finished_courses VALUES('19900918-3999','EITN35',4);
INSERT INTO finished_courses VALUES('19900918-3999','ESS050',4);
INSERT INTO finished_courses VALUES('19900918-3999','ETIF10',3);
INSERT INTO finished_courses VALUES('19900918-3999','ETIN45',5);
INSERT INTO finished_courses VALUES('19900918-3999','ETS170',3);
INSERT INTO finished_courses VALUES('19900918-3999','ETS200',5);
INSERT INTO finished_courses VALUES('19900918-3999','ETSA01',5);
INSERT INTO finished_courses VALUES('19900918-3999','ETSA05',4);
INSERT INTO finished_courses VALUES('19900918-3999','FMA125',5);
INSERT INTO finished_courses VALUES('19900918-3999','FMA145',3);
INSERT INTO finished_courses VALUES('19900918-3999','FMA200',5);
INSERT INTO finished_courses VALUES('19900918-3999','FMN011',3);
INSERT INTO finished_courses VALUES('19900918-3999','FMS012',5);
INSERT INTO finished_courses VALUES('19900918-3999','FMSN30',5);
INSERT INTO finished_courses VALUES('19900918-3999','FRT041',5);
INSERT INTO finished_courses VALUES('19900918-3999','FRT090',4);
INSERT INTO finished_courses VALUES('19900918-3999','GEMA45',3);
INSERT INTO finished_courses VALUES('19900918-3999','GEMA65',5);
INSERT INTO finished_courses VALUES('19900918-3999','MIE080',3);
INSERT INTO finished_courses VALUES('19900918-3999','MIE090',5);
INSERT INTO finished_courses VALUES('19900918-3999','MMKF15',3);
INSERT INTO finished_courses VALUES('19881110-1272','EDA260',3);
INSERT INTO finished_courses VALUES('19881110-1272','EDAA05',5);
INSERT INTO finished_courses VALUES('19881110-1272','EDAF01',3);
INSERT INTO finished_courses VALUES('19881110-1272','EDAN10',3);
INSERT INTO finished_courses VALUES('19881110-1272','EDAN30',4);
INSERT INTO finished_courses VALUES('19881110-1272','EIEN01',5);
INSERT INTO finished_courses VALUES('19881110-1272','EIT140',4);
INSERT INTO finished_courses VALUES('19881110-1272','EITN35',4);
INSERT INTO finished_courses VALUES('19881110-1272','ETIA01',3);
INSERT INTO finished_courses VALUES('19881110-1272','ETSA05',5);
INSERT INTO finished_courses VALUES('19881110-1272','EXTF60',5);
INSERT INTO finished_courses VALUES('19881110-1272','FAF150',4);
INSERT INTO finished_courses VALUES('19881110-1272','FMA091',3);
INSERT INTO finished_courses VALUES('19881110-1272','FMI050',4);
INSERT INTO finished_courses VALUES('19881110-1272','FMSF10',4);
INSERT INTO finished_courses VALUES('19881110-1272','FMSN30',4);
INSERT INTO finished_courses VALUES('19881110-1272','FMSN35',3);
INSERT INTO finished_courses VALUES('19881110-1272','GEMA70',5);
INSERT INTO finished_courses VALUES('19881110-1272','MAM032',4);
INSERT INTO finished_courses VALUES('19881110-1272','TEK210',3);
INSERT INTO finished_courses VALUES('19921029-1995','EDA050',3);
INSERT INTO finished_courses VALUES('19921029-1995','EDA070',3);
INSERT INTO finished_courses VALUES('19921029-1995','EDA180',3);
INSERT INTO finished_courses VALUES('19921029-1995','EDA260',3);
INSERT INTO finished_courses VALUES('19921029-1995','EDAA01',4);
INSERT INTO finished_courses VALUES('19921029-1995','EDAA05',4);
INSERT INTO finished_courses VALUES('19921029-1995','EDAN01',5);
INSERT INTO finished_courses VALUES('19921029-1995','EDAN25',3);
INSERT INTO finished_courses VALUES('19921029-1995','EDAN35',4);
INSERT INTO finished_courses VALUES('19921029-1995','EDAN55',3);
INSERT INTO finished_courses VALUES('19921029-1995','EDIN05',5);
INSERT INTO finished_courses VALUES('19921029-1995','EEMN15',4);
INSERT INTO finished_courses VALUES('19921029-1995','EIEF01',3);
INSERT INTO finished_courses VALUES('19921029-1995','EIT060',3);
INSERT INTO finished_courses VALUES('19921029-1995','EIT140',3);
INSERT INTO finished_courses VALUES('19921029-1995','ESS050',3);
INSERT INTO finished_courses VALUES('19921029-1995','ESSF10',5);
INSERT INTO finished_courses VALUES('19921029-1995','ETIF05',5);
INSERT INTO finished_courses VALUES('19921029-1995','ETIN35',4);
INSERT INTO finished_courses VALUES('19921029-1995','ETS052',5);
INSERT INTO finished_courses VALUES('19921029-1995','ETSA05',3);
INSERT INTO finished_courses VALUES('19921029-1995','ETSF01',3);
INSERT INTO finished_courses VALUES('19921029-1995','ETSN01',4);
INSERT INTO finished_courses VALUES('19921029-1995','FAFF25',5);
INSERT INTO finished_courses VALUES('19921029-1995','FMA175',3);
INSERT INTO finished_courses VALUES('19921029-1995','FMAN10',3);
INSERT INTO finished_courses VALUES('19921029-1995','FMI040',3);
INSERT INTO finished_courses VALUES('19921029-1995','FMS012',4);
INSERT INTO finished_courses VALUES('19921029-1995','FMS110',3);
INSERT INTO finished_courses VALUES('19921029-1995','FMSN30',4);
INSERT INTO finished_courses VALUES('19921029-1995','FRTN15',4);
INSERT INTO finished_courses VALUES('19921029-1995','GEMA50',4);
INSERT INTO finished_courses VALUES('19921029-1995','GEMA60',5);
INSERT INTO finished_courses VALUES('19921029-1995','GEMA70',3);
INSERT INTO finished_courses VALUES('19921029-1995','MAMN15',3);
INSERT INTO finished_courses VALUES('19921029-1995','MIO022',5);
INSERT INTO finished_courses VALUES('19921029-1995','MIO040',4);
INSERT INTO finished_courses VALUES('19921029-1995','TNX153',5);
INSERT INTO finished_courses VALUES('19901030-1895','EDAN01',5);
INSERT INTO finished_courses VALUES('19901030-1895','EDAN35',4);
INSERT INTO finished_courses VALUES('19901030-1895','EDAN55',3);
INSERT INTO finished_courses VALUES('19901030-1895','EIE061',3);
INSERT INTO finished_courses VALUES('19901030-1895','EIEF01',5);
INSERT INTO finished_courses VALUES('19901030-1895','EIT020',5);
INSERT INTO finished_courses VALUES('19901030-1895','EITF40',5);
INSERT INTO finished_courses VALUES('19901030-1895','EITN35',5);
INSERT INTO finished_courses VALUES('19901030-1895','ESSF10',3);
INSERT INTO finished_courses VALUES('19901030-1895','ETIA10',4);
INSERT INTO finished_courses VALUES('19901030-1895','ETIF05',5);
INSERT INTO finished_courses VALUES('19901030-1895','ETIF10',4);
INSERT INTO finished_courses VALUES('19901030-1895','ETSN05',4);
INSERT INTO finished_courses VALUES('19901030-1895','ETT051',4);
INSERT INTO finished_courses VALUES('19901030-1895','EXTA10',3);
INSERT INTO finished_courses VALUES('19901030-1895','EXTA35',5);
INSERT INTO finished_courses VALUES('19901030-1895','FMA051',3);
INSERT INTO finished_courses VALUES('19901030-1895','FMA125',5);
INSERT INTO finished_courses VALUES('19901030-1895','FMA240',5);
INSERT INTO finished_courses VALUES('19901030-1895','FMAN10',3);
INSERT INTO finished_courses VALUES('19901030-1895','FMIF15',3);
INSERT INTO finished_courses VALUES('19901030-1895','FMNN05',5);
INSERT INTO finished_courses VALUES('19901030-1895','GEMA65',5);
INSERT INTO finished_courses VALUES('19901030-1895','MAMF15',4);
INSERT INTO finished_courses VALUES('19901030-1895','MIOA01',5);
INSERT INTO finished_courses VALUES('19901030-1895','TEK280',3);
INSERT INTO finished_courses VALUES('19920921-2499','EDA031',3);
INSERT INTO finished_courses VALUES('19920921-2499','EDA221',3);
INSERT INTO finished_courses VALUES('19920921-2499','EDA270',3);
INSERT INTO finished_courses VALUES('19920921-2499','EDAA01',5);
INSERT INTO finished_courses VALUES('19920921-2499','EDAF05',5);
INSERT INTO finished_courses VALUES('19920921-2499','EDAF15',3);
INSERT INTO finished_courses VALUES('19920921-2499','EDAN30',3);
INSERT INTO finished_courses VALUES('19920921-2499','EEMN01',4);
INSERT INTO finished_courses VALUES('19920921-2499','EEMN05',3);
INSERT INTO finished_courses VALUES('19920921-2499','EIT060',5);
INSERT INTO finished_courses VALUES('19920921-2499','EITN45',4);
INSERT INTO finished_courses VALUES('19920921-2499','ETIF10',3);
INSERT INTO finished_courses VALUES('19920921-2499','ETIN40',5);
INSERT INTO finished_courses VALUES('19920921-2499','ETS052',3);
INSERT INTO finished_courses VALUES('19920921-2499','ETSF10',3);
INSERT INTO finished_courses VALUES('19920921-2499','ETSN01',4);
INSERT INTO finished_courses VALUES('19920921-2499','EXTA10',4);
INSERT INTO finished_courses VALUES('19920921-2499','FMA091',4);
INSERT INTO finished_courses VALUES('19920921-2499','FMA120',3);
INSERT INTO finished_courses VALUES('19920921-2499','FMN011',5);
INSERT INTO finished_courses VALUES('19920921-2499','FMNN05',3);
INSERT INTO finished_courses VALUES('19920921-2499','FMS012',3);
INSERT INTO finished_courses VALUES('19920921-2499','FMS051',4);
INSERT INTO finished_courses VALUES('19920921-2499','FMSF15',5);
INSERT INTO finished_courses VALUES('19920921-2499','FMSN20',3);
INSERT INTO finished_courses VALUES('19920921-2499','FMSN30',4);
INSERT INTO finished_courses VALUES('19920921-2499','FRTN01',4);
INSERT INTO finished_courses VALUES('19920921-2499','FRTN10',4);
INSERT INTO finished_courses VALUES('19920921-2499','GEMA40',5);
INSERT INTO finished_courses VALUES('19920921-2499','GEMA45',5);
INSERT INTO finished_courses VALUES('19920921-2499','GEMA60',5);
INSERT INTO finished_courses VALUES('19920921-2499','MAM032',3);
INSERT INTO finished_courses VALUES('19920921-2499','MAM101',4);
INSERT INTO finished_courses VALUES('19920921-2499','MAM120',5);
INSERT INTO finished_courses VALUES('19920921-2499','MAMF15',5);
INSERT INTO finished_courses VALUES('19920921-2499','MAMN25',4);
INSERT INTO finished_courses VALUES('19920921-2499','MIE080',3);
INSERT INTO finished_courses VALUES('19920921-2499','MIE090',5);
INSERT INTO finished_courses VALUES('19930804-3050','EDA070',3);
INSERT INTO finished_courses VALUES('19930804-3050','EDAF10',5);
INSERT INTO finished_courses VALUES('19930804-3050','EDAN55',3);
INSERT INTO finished_courses VALUES('19930804-3050','EDIN01',5);
INSERT INTO finished_courses VALUES('19930804-3050','EIE061',4);
INSERT INTO finished_courses VALUES('19930804-3050','EIT070',5);
INSERT INTO finished_courses VALUES('19930804-3050','EITF20',4);
INSERT INTO finished_courses VALUES('19930804-3050','EITF35',5);
INSERT INTO finished_courses VALUES('19930804-3050','EITN40',3);
INSERT INTO finished_courses VALUES('19930804-3050','ESS050',3);
INSERT INTO finished_courses VALUES('19930804-3050','ESSF10',4);
INSERT INTO finished_courses VALUES('19930804-3050','ETS061',5);
INSERT INTO finished_courses VALUES('19930804-3050','ETS170',5);
INSERT INTO finished_courses VALUES('19930804-3050','FAFF20',4);
INSERT INTO finished_courses VALUES('19930804-3050','FMA200',5);
INSERT INTO finished_courses VALUES('19930804-3050','FMS091',3);
INSERT INTO finished_courses VALUES('19930804-3050','FRT010',4);
INSERT INTO finished_courses VALUES('19930804-3050','FRTN01',4);
INSERT INTO finished_courses VALUES('19930804-3050','FRTN15',5);
INSERT INTO finished_courses VALUES('19930804-3050','MAM032',4);
INSERT INTO finished_courses VALUES('19930804-3050','MAM120',3);
INSERT INTO finished_courses VALUES('19910101-1234','EDA070',3);
INSERT INTO finished_courses VALUES('19910101-1234','EDA385',5);
INSERT INTO finished_courses VALUES('19910101-1234','EDAA25',4);
INSERT INTO finished_courses VALUES('19910101-1234','EDAF05',3);
INSERT INTO finished_courses VALUES('19910101-1234','EEMN10',5);
INSERT INTO finished_courses VALUES('19910101-1234','EIT020',3);
INSERT INTO finished_courses VALUES('19910101-1234','EIT060',4);
INSERT INTO finished_courses VALUES('19910101-1234','EITF40',5);
INSERT INTO finished_courses VALUES('19910101-1234','EITN40',3);
INSERT INTO finished_courses VALUES('19910101-1234','EITN50',4);
INSERT INTO finished_courses VALUES('19910101-1234','ESS050',5);
INSERT INTO finished_courses VALUES('19910101-1234','ETIF10',5);
INSERT INTO finished_courses VALUES('19910101-1234','ETIF15',5);
INSERT INTO finished_courses VALUES('19910101-1234','ETIN35',4);
INSERT INTO finished_courses VALUES('19910101-1234','ETS052',5);
INSERT INTO finished_courses VALUES('19910101-1234','ETS075',4);
INSERT INTO finished_courses VALUES('19910101-1234','ETS200',3);
INSERT INTO finished_courses VALUES('19910101-1234','ETSA01',3);
INSERT INTO finished_courses VALUES('19910101-1234','EXTA10',4);
INSERT INTO finished_courses VALUES('19910101-1234','EXTA35',4);
INSERT INTO finished_courses VALUES('19910101-1234','FAFF20',4);
INSERT INTO finished_courses VALUES('19910101-1234','FAFF25',4);
INSERT INTO finished_courses VALUES('19910101-1234','FMA145',3);
INSERT INTO finished_courses VALUES('19910101-1234','FMA420',5);
INSERT INTO finished_courses VALUES('19910101-1234','FMAA01',5);
INSERT INTO finished_courses VALUES('19910101-1234','FMAF05',3);
INSERT INTO finished_courses VALUES('19910101-1234','FMS012',3);
INSERT INTO finished_courses VALUES('19910101-1234','FMSF15',4);
INSERT INTO finished_courses VALUES('19910101-1234','FMSN30',5);
INSERT INTO finished_courses VALUES('19910101-1234','FMSN35',5);
INSERT INTO finished_courses VALUES('19910101-1234','FRTN10',5);
INSERT INTO finished_courses VALUES('19910101-1234','GEMA45',3);
INSERT INTO finished_courses VALUES('19910101-1234','GEMA70',4);
INSERT INTO finished_courses VALUES('19910101-1234','MAMF15',4);
INSERT INTO finished_courses VALUES('19910101-1234','TEK210',3);
COMMIT;
